/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.time.InstantSource;

public class JobRecurProcessor
implements TypedRecordProcessor<JobRecord> {
    private static final String NOT_FAILED_JOB_MESSAGE = "Expected to back off failed job with key '%d', but %s";
    private final JobState jobState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final InstantSource clock;

    public JobRecurProcessor(ProcessingState processingState, Writers writers, BpmnJobActivationBehavior jobActivationBehavior, InstantSource clock) {
        this.jobState = processingState.getJobState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.jobActivationBehavior = jobActivationBehavior;
        this.clock = clock;
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobRecord job = this.jobState.getJob(jobKey);
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.FAILED && this.hasRecurred(job)) {
            JobRecord recurredJob = this.jobState.getJob(jobKey);
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.RECURRED_AFTER_BACKOFF, (RecordValue)recurredJob);
            this.jobActivationBehavior.publishWork(jobKey, recurredJob);
        } else {
            String errorMesage = String.format(NOT_FAILED_JOB_MESSAGE, jobKey, switch (state) {
                case JobState.State.ACTIVATABLE -> "it is already activable";
                case JobState.State.ACTIVATED -> "it is already activated";
                case JobState.State.ERROR_THROWN -> "it is in error state";
                default -> "no such job was found";
            });
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, errorMesage);
        }
    }

    private boolean hasRecurred(JobRecord job) {
        return job.getRecurringTime() < this.clock.millis();
    }
}

