/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import java.time.InstantSource;

public final class PendingMessageSubscriptionChecker
implements Runnable {
    private final SubscriptionCommandSender commandSender;
    private final PendingMessageSubscriptionState state;
    private final long subscriptionTimeout;
    private final InstantSource clock;

    public PendingMessageSubscriptionChecker(SubscriptionCommandSender commandSender, PendingMessageSubscriptionState state, long subscriptionTimeout, InstantSource clock) {
        this.commandSender = commandSender;
        this.state = state;
        this.subscriptionTimeout = subscriptionTimeout;
        this.clock = clock;
    }

    @Override
    public void run() {
        this.state.visitPending(this.clock.millis() - this.subscriptionTimeout, this::sendCommand);
    }

    private boolean sendCommand(MessageSubscription subscription) {
        MessageSubscriptionRecord record = subscription.getRecord();
        this.commandSender.sendDirectCorrelateProcessMessageSubscription(record.getProcessInstanceKey(), record.getElementInstanceKey(), record.getBpmnProcessIdBuffer(), record.getMessageNameBuffer(), record.getMessageKey(), record.getVariablesBuffer(), record.getCorrelationKeyBuffer(), record.getTenantId());
        long sentTime = this.clock.millis();
        this.state.onSent(record, sentTime);
        return true;
    }
}

