/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.JobIntent;

public class JobErrorThrownApplier
implements TypedEventApplier<JobIntent, JobRecord> {
    private final MutableJobState jobState;
    private final MutableElementInstanceState elementInstanceState;

    JobErrorThrownApplier(MutableProcessingState state) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
    }

    @Override
    public void applyState(long jobKey, JobRecord job) {
        String serviceTaskInstanceId = job.getElementId();
        this.jobState.throwError(jobKey, job);
        if (!"NO_CATCH_EVENT_FOUND".equals(serviceTaskInstanceId)) {
            ElementInstance serviceTaskInstance = this.elementInstanceState.getInstance(job.getElementInstanceKey());
            this.removeJobReference(jobKey, job, serviceTaskInstance);
        }
    }

    private void removeJobReference(long jobKey, JobRecord job, ElementInstance serviceTaskInstance) {
        serviceTaskInstance.setJobKey(-1L);
        this.elementInstanceState.updateInstance(serviceTaskInstance);
        this.jobState.delete(jobKey, job);
    }
}

