/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.behaviour.JobUpdateBehaviour;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class JobUpdateProcessor
implements TypedRecordProcessor<JobRecord> {
    private final JobUpdateBehaviour jobUpdateBehaviour;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final StateWriter stateWriter;

    public JobUpdateProcessor(JobUpdateBehaviour jobUpdateBehaviour, Writers writers) {
        this.jobUpdateBehaviour = jobUpdateBehaviour;
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.stateWriter = writers.state();
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> command) {
        long jobKey = command.getKey();
        this.jobUpdateBehaviour.getJob(jobKey, command).ifRightOrLeft(job -> {
            ArrayList<String> errors = new ArrayList<String>();
            Set changeset = ((JobRecord)command.getValue()).getChangedAttributes();
            job.setChangedAttributes(changeset);
            this.jobChange(changeset, "retries", ((JobRecord)command.getValue()).getRetries(), retries -> this.jobUpdateBehaviour.updateJobRetries(jobKey, (int)retries, (JobRecord)job), errors);
            this.jobChange(changeset, "timeout", ((JobRecord)command.getValue()).getTimeout(), timeout -> this.jobUpdateBehaviour.updateJobTimeout(jobKey, (long)timeout, (JobRecord)job), errors);
            if (errors.isEmpty()) {
                this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.UPDATED, (RecordValue)job);
                this.responseWriter.writeEventOnCommand(jobKey, (Intent)JobIntent.UPDATED, (UnpackedObject)job, command);
            } else {
                this.handleRejection(errors, command);
            }
        }, errorMessage -> this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, (String)errorMessage));
    }

    private <T extends Number> void jobChange(Set<String> changeset, String key, T value, Function<T, Optional<String>> updateFunction, List<String> errors) {
        if (changeset.contains(key)) {
            updateFunction.apply(value).ifPresent(errors::add);
        }
    }

    private void handleRejection(List<String> errors, TypedRecord<JobRecord> command) {
        String errorMessage = String.join((CharSequence)", ", errors);
        this.rejectionWriter.appendRejection(command, RejectionType.INVALID_ARGUMENT, errorMessage);
        this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_ARGUMENT, errorMessage);
    }
}

