/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.routing;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.engine.state.immutable.RoutingState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.value.IntegerValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class PersistedRoutingInfo
extends UnpackedObject
implements DbValue {
    private final ArrayProperty<IntegerValue> partitions = new ArrayProperty("partitions", IntegerValue::new);
    private final EnumProperty<MessageCorrelationStrategy> messageCorrelationStrategy = new EnumProperty("messageCorrelationStrategy", MessageCorrelationStrategy.class, (Enum)MessageCorrelationStrategy.HASH_MOD);
    private final IntegerProperty hashModPartitionCount = new IntegerProperty("hashModPartitionCount", -1);

    public PersistedRoutingInfo() {
        super(3);
        this.declareProperty((BaseProperty)this.partitions).declareProperty(this.messageCorrelationStrategy).declareProperty((BaseProperty)this.hashModPartitionCount);
    }

    public Set<Integer> getPartitions() {
        return this.partitions.stream().map(IntegerValue::getValue).collect(Collectors.toUnmodifiableSet());
    }

    public void setPartitions(Set<Integer> partitions) {
        this.partitions.reset();
        for (Integer partition : partitions) {
            ((IntegerValue)this.partitions.add()).setValue(partition.intValue());
        }
    }

    public RoutingState.MessageCorrelation getMessageCorrelation() {
        switch (((MessageCorrelationStrategy)this.messageCorrelationStrategy.getValue()).ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        return new RoutingState.MessageCorrelation.HashMod(this.hashModPartitionCount.getValue());
    }

    public void setMessageCorrelation(RoutingState.MessageCorrelation messageCorrelation) {
        int partitionCount;
        RoutingState.MessageCorrelation messageCorrelation2 = messageCorrelation;
        Objects.requireNonNull(messageCorrelation2);
        RoutingState.MessageCorrelation messageCorrelation3 = messageCorrelation2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RoutingState.MessageCorrelation.HashMod.class}, (Object)messageCorrelation3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        RoutingState.MessageCorrelation.HashMod hashMod = (RoutingState.MessageCorrelation.HashMod)messageCorrelation3;
        try {
            int n2;
            partitionCount = n2 = hashMod.partitionCount();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        this.messageCorrelationStrategy.setValue((Enum)MessageCorrelationStrategy.HASH_MOD);
        this.hashModPartitionCount.setValue(partitionCount);
    }

    static enum MessageCorrelationStrategy {
        HASH_MOD;

    }
}

