/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.message.Subscriptions;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import org.agrona.DirectBuffer;

public final class MessageCorrelateBehavior {
    private final MessageStartEventSubscriptionState startEventSubscriptionState;
    private final MessageSubscriptionState messageSubscriptionState;
    private final MessageState messageState;
    private final EventHandle eventHandle;
    private final StateWriter stateWriter;
    private final SubscriptionCommandSender commandSender;

    public MessageCorrelateBehavior(MessageStartEventSubscriptionState startEventSubscriptionState, MessageState messageState, EventHandle eventHandle, StateWriter stateWriter, MessageSubscriptionState messageSubscriptionState, SubscriptionCommandSender commandSender) {
        this.startEventSubscriptionState = startEventSubscriptionState;
        this.messageSubscriptionState = messageSubscriptionState;
        this.messageState = messageState;
        this.eventHandle = eventHandle;
        this.stateWriter = stateWriter;
        this.commandSender = commandSender;
    }

    public void correlateToMessageStartEvents(MessageData messageData, Subscriptions correlatingSubscriptions) {
        this.startEventSubscriptionState.visitSubscriptionsByMessageName(messageData.tenantId(), messageData.messageName(), subscription -> {
            MessageStartEventSubscriptionRecord subscriptionRecord = subscription.getRecord();
            DirectBuffer bpmnProcessIdBuffer = subscriptionRecord.getBpmnProcessIdBuffer();
            if (!(correlatingSubscriptions.contains(bpmnProcessIdBuffer) || messageData.correlationKey().capacity() != 0 && this.messageState.existActiveProcessInstance(messageData.tenantId(), bpmnProcessIdBuffer, messageData.correlationKey()))) {
                long processInstanceKey = this.eventHandle.triggerMessageStartEvent(subscription.getKey(), subscriptionRecord, messageData.messageKey(), messageData.messageName(), messageData.correlationKey(), messageData.variables());
                subscriptionRecord.setProcessInstanceKey(processInstanceKey);
                correlatingSubscriptions.add(subscriptionRecord);
            }
        });
    }

    public void correlateToMessageEvents(MessageData messageData, Subscriptions correlatingSubscriptions) {
        this.messageSubscriptionState.visitSubscriptions(messageData.tenantId(), messageData.messageName(), messageData.correlationKey(), subscription -> {
            if (!subscription.isCorrelating() && !correlatingSubscriptions.contains(subscription.getRecord().getBpmnProcessIdBuffer())) {
                MessageSubscriptionRecord correlatingSubscription = subscription.getRecord().setMessageKey(messageData.messageKey()).setVariables(messageData.variables());
                this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)MessageSubscriptionIntent.CORRELATING, (RecordValue)correlatingSubscription);
                correlatingSubscriptions.add(correlatingSubscription);
            }
            return true;
        });
    }

    public void sendCorrelateCommands(MessageData messageData, Subscriptions correlatingSubscriptions) {
        correlatingSubscriptions.visitSubscriptions(subscription -> this.commandSender.correlateProcessMessageSubscription(subscription.getProcessInstanceKey(), subscription.getElementInstanceKey(), subscription.getBpmnProcessId(), messageData.messageName(), messageData.messageKey(), messageData.variables(), messageData.correlationKey(), messageData.tenantId()));
    }

    public record MessageData(long messageKey, DirectBuffer messageName, DirectBuffer correlationKey, DirectBuffer variables, String tenantId) {
    }
}

