/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor.writers;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.AbstractResultBuilderBackedWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.ProcessingResultBuilder;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.function.Supplier;

public class ResultBuilderBackedTypedResponseWriter
extends AbstractResultBuilderBackedWriter
implements TypedResponseWriter {
    ResultBuilderBackedTypedResponseWriter(Supplier<ProcessingResultBuilder> resultBuilderSupplier) {
        super(resultBuilderSupplier);
    }

    @Override
    public void writeRejectionOnCommand(TypedRecord<?> command, RejectionType type, String reason) {
        this.writeRejection(command, type, reason, command.getRequestId(), command.getRequestStreamId());
    }

    @Override
    public void writeRejection(TypedRecord<?> command, RejectionType type, String reason, long requestId, int requestStreamId) {
        this.resultBuilder().withResponse(RecordType.COMMAND_REJECTION, command.getKey(), command.getIntent(), (UnpackedObject)command.getValue(), command.getValueType(), type, reason, requestId, requestStreamId);
    }

    @Override
    public void writeEvent(TypedRecord<?> event) {
        this.writeResponse(event.getKey(), event.getIntent(), (UnpackedObject)event.getValue(), event.getValueType(), event.getRequestId(), event.getRequestStreamId());
    }

    @Override
    public void writeEventOnCommand(long eventKey, Intent eventState, UnpackedObject eventValue, TypedRecord<?> command) {
        this.writeResponse(eventKey, eventState, eventValue, command.getValueType(), command.getRequestId(), command.getRequestStreamId());
    }

    @Override
    public void writeResponse(long eventKey, Intent eventState, UnpackedObject eventValue, ValueType valueType, long requestId, int requestStreamId) {
        this.resultBuilder().withResponse(RecordType.EVENT, eventKey, eventState, eventValue, valueType, RejectionType.NULL_VAL, "", requestId, requestStreamId);
    }
}

