/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.user;

import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.UserState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import org.agrona.DirectBuffer;

public class UserUpdateProcessor
implements DistributedTypedRecordProcessor<UserRecord> {
    private final UserState userState;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final CommandDistributionBehavior distributionBehavior;

    public UserUpdateProcessor(KeyGenerator keyGenerator, ProcessingState state, Writers writers, CommandDistributionBehavior distributionBehavior) {
        this.keyGenerator = keyGenerator;
        this.userState = state.getUserState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.distributionBehavior = distributionBehavior;
    }

    @Override
    public void processNewCommand(TypedRecord<UserRecord> command) {
        DirectBuffer username = ((UserRecord)command.getValue()).getUsernameBuffer();
        UserRecord persistedUser = this.userState.getUser(username);
        if (persistedUser == null) {
            String rejectionMessage = "Expected to update user with username %s, but a user with this username does not exist".formatted(((UserRecord)command.getValue()).getUsername());
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, rejectionMessage);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, rejectionMessage);
            return;
        }
        UserRecord updatedUser = this.overlayUser(persistedUser, (UserRecord)command.getValue());
        long key = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(key, (Intent)UserIntent.UPDATED, (RecordValue)updatedUser);
        this.responseWriter.writeEventOnCommand(key, (Intent)UserIntent.UPDATED, (UnpackedObject)updatedUser, command);
        this.distributionBehavior.withKey(key).unordered().distribute(command);
    }

    @Override
    public void processDistributedCommand(TypedRecord<UserRecord> command) {
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)UserIntent.UPDATED, (RecordValue)command.getValue());
        this.distributionBehavior.acknowledgeCommand(command);
    }

    private UserRecord overlayUser(UserRecord persistedUser, UserRecord updatedUser) {
        if (!updatedUser.getName().isEmpty()) {
            persistedUser.setName(updatedUser.getName());
        }
        if (!updatedUser.getEmail().isEmpty()) {
            persistedUser.setEmail(updatedUser.getEmail());
        }
        if (!updatedUser.getPassword().isEmpty()) {
            persistedUser.setPassword(updatedUser.getPassword());
        }
        return persistedUser;
    }
}

