/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.distribution;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.distribution.PersistedCommandDistribution;
import io.camunda.zeebe.engine.state.immutable.DistributionState;
import io.camunda.zeebe.engine.state.mutable.MutableDistributionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import java.util.Optional;
import org.agrona.collections.MutableBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.collections.MutableReference;
import org.slf4j.Logger;

public class DbDistributionState
implements MutableDistributionState {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final DbLong distributionKey = new DbLong();
    private final DbInt partitionKey;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbInt> distributionPartitionKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbInt>, DbNil> pendingDistributionColumnFamily;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbInt>, DbNil> retriableDistributionColumnFamily;
    private final ColumnFamily<DbLong, PersistedCommandDistribution> commandDistributionRecordColumnFamily;
    private final ColumnFamily<DbCompositeKey<DbString, DbCompositeKey<DbInt, DbForeignKey<DbLong>>>, DbNil> queuedCommandDistributionColumnFamily;
    private final DbString queueId;
    private final DbCompositeKey<DbString, DbInt> queuePerPartitionKey;
    private final DbCompositeKey<DbString, DbCompositeKey<DbInt, DbForeignKey<DbLong>>> queuedDistributionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, PersistedCommandDistribution> continuationCommandColumnFamily;
    private final DbLong continuationKey;
    private final DbCompositeKey<DbString, DbLong> continuationByQueueKey;

    public DbDistributionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        DbForeignKey fkDistribution = new DbForeignKey((DbKey)this.distributionKey, (Enum)ZbColumnFamilies.COMMAND_DISTRIBUTION_RECORD);
        this.commandDistributionRecordColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.COMMAND_DISTRIBUTION_RECORD, transactionContext, (DbKey)this.distributionKey, (DbValue)new PersistedCommandDistribution());
        this.partitionKey = new DbInt();
        this.distributionPartitionKey = new DbCompositeKey((DbKey)fkDistribution, (DbKey)this.partitionKey);
        this.pendingDistributionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PENDING_DISTRIBUTION, transactionContext, this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
        this.retriableDistributionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.RETRIABLE_DISTRIBUTION, transactionContext, this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
        this.queueId = new DbString();
        this.queuePerPartitionKey = new DbCompositeKey((DbKey)this.queueId, (DbKey)this.partitionKey);
        this.queuedDistributionKey = new DbCompositeKey((DbKey)this.queueId, (DbKey)new DbCompositeKey((DbKey)this.partitionKey, (DbKey)fkDistribution));
        this.queuedCommandDistributionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.QUEUED_DISTRIBUTION, transactionContext, this.queuedDistributionKey, (DbValue)DbNil.INSTANCE);
        this.continuationKey = new DbLong();
        this.continuationByQueueKey = new DbCompositeKey((DbKey)this.queueId, (DbKey)this.continuationKey);
        this.continuationCommandColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DISTRIBUTION_CONTINUATION, transactionContext, this.continuationByQueueKey, (DbValue)new PersistedCommandDistribution());
    }

    @Override
    public void addCommandDistribution(long distributionKey, CommandDistributionRecord commandDistributionRecord) {
        this.distributionKey.wrapLong(distributionKey);
        this.commandDistributionRecordColumnFamily.insert((DbKey)this.distributionKey, (DbValue)new PersistedCommandDistribution().wrap(commandDistributionRecord));
    }

    @Override
    public void removeCommandDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        this.commandDistributionRecordColumnFamily.deleteIfExists((DbKey)this.distributionKey);
    }

    @Override
    public void addRetriableDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.retriableDistributionColumnFamily.insert(this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeRetriableDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.retriableDistributionColumnFamily.deleteExisting(this.distributionPartitionKey);
    }

    @Override
    public void addPendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDistributionColumnFamily.upsert(this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removePendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDistributionColumnFamily.deleteExisting(this.distributionPartitionKey);
    }

    @Override
    public void enqueueCommandDistribution(String queue, long distributionKey, int partition) {
        this.queueId.wrapString(queue);
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.queuedCommandDistributionColumnFamily.insert(this.queuedDistributionKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeQueuedDistribution(String queue, int partition, long distributionKey) {
        this.queueId.wrapString(queue);
        this.partitionKey.wrapInt(partition);
        this.distributionKey.wrapLong(distributionKey);
        this.queuedCommandDistributionColumnFamily.deleteExisting(this.queuedDistributionKey);
    }

    @Override
    public void addContinuationCommand(long continuationKey, CommandDistributionRecord record) {
        this.queueId.wrapString(record.getQueueId());
        this.continuationKey.wrapLong(continuationKey);
        this.continuationCommandColumnFamily.insert(this.continuationByQueueKey, (DbValue)new PersistedCommandDistribution().wrap(record));
    }

    @Override
    public void removeContinuationCommand(long continuationKey, String queue) {
        this.queueId.wrapString(queue);
        this.continuationKey.wrapLong(continuationKey);
        this.continuationCommandColumnFamily.deleteExisting(this.continuationByQueueKey);
    }

    @Override
    public boolean hasRetriableDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        MutableBoolean hasRetriable = new MutableBoolean();
        this.retriableDistributionColumnFamily.whileEqualPrefix((DbKey)this.distributionKey, (compositeKey, dbNil) -> {
            hasRetriable.set(true);
            return false;
        });
        return hasRetriable.get();
    }

    @Override
    public boolean hasPendingDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        MutableBoolean hasPending = new MutableBoolean();
        this.pendingDistributionColumnFamily.whileEqualPrefix((DbKey)this.distributionKey, (compositeKey, dbNil) -> {
            hasPending.set(true);
            return false;
        });
        return hasPending.get();
    }

    @Override
    public boolean hasRetriableDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        return this.retriableDistributionColumnFamily.exists(this.distributionPartitionKey);
    }

    @Override
    public boolean hasPendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        return this.pendingDistributionColumnFamily.exists(this.distributionPartitionKey);
    }

    @Override
    public CommandDistributionRecord getCommandDistributionRecord(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        PersistedCommandDistribution persistedDistribution = (PersistedCommandDistribution)this.commandDistributionRecordColumnFamily.get((DbKey)this.distributionKey);
        if (persistedDistribution == null) {
            return null;
        }
        return new CommandDistributionRecord().setPartitionId(partition).setValueType(persistedDistribution.getValueType()).setIntent(persistedDistribution.getIntent()).setCommandValue(persistedDistribution.getCommandValue());
    }

    @Override
    public void foreachRetriableDistribution(DistributionState.PendingDistributionVisitor visitor) {
        MutableLong lastDistributionKey = new MutableLong(0L);
        MutableReference lastPendingDistribution = new MutableReference();
        this.retriableDistributionColumnFamily.forEach((compositeKey, nil) -> {
            long distributionKey = ((DbLong)((DbForeignKey)compositeKey.first()).inner()).getValue();
            int partitionId = ((DbInt)compositeKey.second()).getValue();
            if (lastDistributionKey.value != distributionKey) {
                CommandDistributionRecord pendingDistribution = this.getCommandDistributionRecord(distributionKey, partitionId);
                if (pendingDistribution == null) {
                    LOG.warn("Expected to find a pending distribution with key {} for a partition {}, but none found. The state is inconsistent", (Object)distributionKey, (Object)partitionId);
                    return;
                }
                lastDistributionKey.set(distributionKey);
                lastPendingDistribution.set((Object)pendingDistribution);
            }
            CommandDistributionRecord commandDistributionRecord = new CommandDistributionRecord();
            commandDistributionRecord.wrap((CommandDistributionRecord)lastPendingDistribution.get()).setPartitionId(partitionId);
            visitor.visit(distributionKey, commandDistributionRecord);
        });
    }

    @Override
    public Optional<Long> getNextQueuedDistributionKey(String queue, int partition) {
        this.queueId.wrapString(queue);
        this.partitionKey.wrapInt(partition);
        MutableReference nextDistributionKey = new MutableReference(null);
        this.queuedCommandDistributionColumnFamily.whileEqualPrefix(this.queuePerPartitionKey, (key, value) -> {
            nextDistributionKey.set((Object)((DbLong)((DbForeignKey)((DbCompositeKey)key.second()).second()).inner()).getValue());
            return false;
        });
        return Optional.ofNullable((Long)nextDistributionKey.get());
    }

    @Override
    public Optional<String> getQueueIdForDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        return Optional.ofNullable((PersistedCommandDistribution)this.commandDistributionRecordColumnFamily.get((DbKey)this.distributionKey)).flatMap(PersistedCommandDistribution::getQueueId);
    }

    @Override
    public boolean hasQueuedDistributions(String queue) {
        this.queueId.wrapString(queue);
        MutableBoolean hasQueuedDistributions = new MutableBoolean();
        this.queuedCommandDistributionColumnFamily.whileEqualPrefix((DbKey)this.queueId, (key, value) -> {
            hasQueuedDistributions.set(true);
            return false;
        });
        return hasQueuedDistributions.get();
    }

    @Override
    public void forEachContinuationCommand(String queue, DistributionState.ContinuationCommandVisitor consumer) {
        this.queueId.wrapString(queue);
        this.continuationCommandColumnFamily.whileEqualPrefix((DbKey)this.queueId, (key, value) -> {
            long continuationKey = ((DbLong)key.second()).getValue();
            consumer.visit(continuationKey);
            return true;
        });
    }

    @Override
    public CommandDistributionRecord getContinuationRecord(String queue, long key) {
        this.queueId.wrapString(queue);
        this.continuationKey.wrapLong(key);
        PersistedCommandDistribution persistedCommandDistribution = (PersistedCommandDistribution)this.continuationCommandColumnFamily.get(this.continuationByQueueKey);
        if (persistedCommandDistribution == null) {
            return null;
        }
        return new CommandDistributionRecord().setQueueId(queue).setValueType(persistedCommandDistribution.getValueType()).setIntent(persistedCommandDistribution.getIntent()).setCommandValue(persistedCommandDistribution.getCommandValue());
    }
}

