/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.migration.DbMigrator;
import io.camunda.zeebe.engine.state.migration.JobBackoffCleanupMigration;
import io.camunda.zeebe.engine.state.migration.JobBackoffRestoreMigration;
import io.camunda.zeebe.engine.state.migration.JobTimeoutCleanupMigration;
import io.camunda.zeebe.engine.state.migration.MessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.MigrationTask;
import io.camunda.zeebe.engine.state.migration.MigrationTaskContextImpl;
import io.camunda.zeebe.engine.state.migration.MutableMigrationTaskContext;
import io.camunda.zeebe.engine.state.migration.ProcessMessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.RoutingInfoMigration;
import io.camunda.zeebe.engine.state.migration.TemporaryVariableMigration;
import io.camunda.zeebe.engine.state.migration.VersionCompatibilityCheck;
import io.camunda.zeebe.engine.state.migration.to_8_2.DecisionMigration;
import io.camunda.zeebe.engine.state.migration.to_8_2.DecisionRequirementsMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyDecisionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyJobStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageStartEventSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyProcessMessageSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyProcessStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.ProcessInstanceByProcessDefinitionMigration;
import io.camunda.zeebe.engine.state.migration.to_8_4.MultiTenancySignalSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_5.ColumnFamilyPrefixCorrectionMigration;
import io.camunda.zeebe.engine.state.migration.to_8_6.OrderedCommandDistributionMigration;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.stream.api.ClusterContext;
import io.camunda.zeebe.util.VersionUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigratorImpl
implements DbMigrator {
    public static final List<MigrationTask> MIGRATION_TASKS = List.of(new ProcessMessageSubscriptionSentTimeMigration(), new MessageSubscriptionSentTimeMigration(), new TemporaryVariableMigration(), new DecisionMigration(), new DecisionRequirementsMigration(), new ProcessInstanceByProcessDefinitionMigration(), new JobTimeoutCleanupMigration(), new JobBackoffCleanupMigration(), new MultiTenancyProcessStateMigration(), new MultiTenancyDecisionStateMigration(), new MultiTenancyMessageStateMigration(), new MultiTenancyMessageStartEventSubscriptionStateMigration(), new MultiTenancyMessageSubscriptionStateMigration(), new MultiTenancyProcessMessageSubscriptionStateMigration(), new MultiTenancyJobStateMigration(), new ColumnFamilyPrefixCorrectionMigration(), new MultiTenancySignalSubscriptionStateMigration(), new JobBackoffRestoreMigration(), new RoutingInfoMigration(), new OrderedCommandDistributionMigration());
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DbMigratorImpl.class.getPackageName());
    private final MutableMigrationTaskContext migrationTaskContext;
    private final List<MigrationTask> migrationTasks;

    public DbMigratorImpl(ClusterContext clusterContext, MutableProcessingState processingState) {
        this(new MigrationTaskContextImpl(clusterContext, processingState), MIGRATION_TASKS);
    }

    public DbMigratorImpl(MutableMigrationTaskContext migrationTaskContext, List<MigrationTask> migrationTasks) {
        this.migrationTaskContext = migrationTaskContext;
        this.migrationTasks = migrationTasks;
    }

    @Override
    public void runMigrations() {
        if (this.checkVersionCompatibility() instanceof VersionCompatibilityCheck.CheckResult.Compatible.SameVersion) {
            LOGGER.info("No migrations to run, snapshot is the same as current version");
            return;
        }
        this.logPreview(this.migrationTasks);
        ArrayList<MigrationTask> executedMigrations = new ArrayList<MigrationTask>();
        for (int index = 1; index <= this.migrationTasks.size(); ++index) {
            MigrationTask migration = this.migrationTasks.get(index - 1);
            boolean executed = this.handleMigrationTask(migration, index, this.migrationTasks.size());
            if (!executed) continue;
            executedMigrations.add(migration);
        }
        this.markMigrationsAsCompleted();
        this.logSummary(executedMigrations);
    }

    private VersionCompatibilityCheck.CheckResult checkVersionCompatibility() {
        VersionCompatibilityCheck.CheckResult checkResult;
        String migratedByVersion = this.migrationTaskContext.processingState().getMigrationState().getMigratedByVersion();
        String currentVersion = VersionUtil.getVersion();
        VersionCompatibilityCheck.CheckResult checkResult2 = checkResult = VersionCompatibilityCheck.check(migratedByVersion, currentVersion);
        Objects.requireNonNull(checkResult2);
        VersionCompatibilityCheck.CheckResult checkResult3 = checkResult2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VersionCompatibilityCheck.CheckResult.Indeterminate.PreviousVersionUnknown.class, VersionCompatibilityCheck.CheckResult.Indeterminate.class, VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion.class, VersionCompatibilityCheck.CheckResult.Incompatible.class, VersionCompatibilityCheck.CheckResult.Compatible.SameVersion.class, VersionCompatibilityCheck.CheckResult.Compatible.class}, (Object)checkResult3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                VersionCompatibilityCheck.CheckResult.Indeterminate.PreviousVersionUnknown previousVersionUnknown = (VersionCompatibilityCheck.CheckResult.Indeterminate.PreviousVersionUnknown)checkResult3;
                LOGGER.trace("Snapshot is from an unknown version, not checking compatibility with current version: {}", (Object)previousVersionUnknown);
                break;
            }
            case 1: {
                VersionCompatibilityCheck.CheckResult.Indeterminate indeterminate = (VersionCompatibilityCheck.CheckResult.Indeterminate)checkResult3;
                LOGGER.warn("Could not check compatibility of snapshot with current version: {}", (Object)indeterminate);
                break;
            }
            case 2: {
                VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion preRelease = (VersionCompatibilityCheck.CheckResult.Incompatible.UseOfPreReleaseVersion)checkResult3;
                throw new IllegalStateException("Cannot upgrade to or from a pre-release version: %s".formatted(preRelease));
            }
            case 3: {
                VersionCompatibilityCheck.CheckResult.Incompatible incompatible = (VersionCompatibilityCheck.CheckResult.Incompatible)checkResult3;
                throw new IllegalStateException("Snapshot is not compatible with current version: %s".formatted(incompatible));
            }
            case 4: {
                VersionCompatibilityCheck.CheckResult.Compatible.SameVersion sameVersion = (VersionCompatibilityCheck.CheckResult.Compatible.SameVersion)checkResult3;
                LOGGER.trace("Snapshot is from the same version as the current version: {}", (Object)sameVersion);
                break;
            }
            case 5: {
                VersionCompatibilityCheck.CheckResult.Compatible compatible = (VersionCompatibilityCheck.CheckResult.Compatible)checkResult3;
                LOGGER.info("Snapshot is compatible with current version: {}", (Object)compatible);
            }
        }
        return checkResult;
    }

    private void markMigrationsAsCompleted() {
        this.migrationTaskContext.processingState().getMigrationState().setMigratedByVersion(VersionUtil.getVersion());
    }

    private void logPreview(List<MigrationTask> migrationTasks) {
        LOGGER.info("Starting processing of migration tasks (use LogLevel.DEBUG for more details) ... ");
        LOGGER.debug("Found {} migration tasks: {}", (Object)migrationTasks.size(), (Object)migrationTasks.stream().map(MigrationTask::getIdentifier).collect(Collectors.joining(", ")));
    }

    private void logSummary(List<MigrationTask> migrationTasks) {
        LOGGER.info("Completed processing of migration tasks (use LogLevel.DEBUG for more details) ... ");
        LOGGER.debug("Executed {} migration tasks: {}", (Object)migrationTasks.size(), (Object)migrationTasks.stream().map(MigrationTask::getIdentifier).collect(Collectors.joining(", ")));
    }

    private boolean handleMigrationTask(MigrationTask migrationTask, int index, int total) {
        if (migrationTask.needsToRun(this.migrationTaskContext)) {
            this.runMigration(migrationTask, index, total);
            return true;
        }
        this.logMigrationSkipped(migrationTask, index, total);
        return false;
    }

    private void logMigrationSkipped(MigrationTask migrationTask, int index, int total) {
        LOGGER.info("Skipping {} migration ({}/{}).  It was determined it does not need to run right now.", new Object[]{migrationTask.getIdentifier(), index, total});
    }

    private void runMigration(MigrationTask migrationTask, int index, int total) {
        LOGGER.info("Starting {} migration ({}/{})", new Object[]{migrationTask.getIdentifier(), index, total});
        long startTime = System.currentTimeMillis();
        migrationTask.runMigration(this.migrationTaskContext);
        long duration = System.currentTimeMillis() - startTime;
        LOGGER.debug("{} migration completed in {} ms.", (Object)migrationTask.getIdentifier(), (Object)duration);
        LOGGER.info("Finished {} migration ({}/{})", new Object[]{migrationTask.getIdentifier(), index, total});
    }
}

