/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine;

import java.time.Duration;

public final class EngineConfiguration {
    public static final int DEFAULT_MESSAGES_TTL_CHECKER_BATCH_LIMIT = Integer.MAX_VALUE;
    public static final Duration DEFAULT_MESSAGES_TTL_CHECKER_INTERVAL = Duration.ofMinutes(1L);
    public static final int DEFAULT_MAX_ERROR_MESSAGE_SIZE = 10000;
    public static final int BATCH_SIZE_CALCULATION_BUFFER = 8192;
    public static final int DEFAULT_DRG_CACHE_CAPACITY = 1000;
    public static final int DEFAULT_FORM_CACHE_CAPACITY = 1000;
    public static final int DEFAULT_PROCESS_CACHE_CAPACITY = 1000;
    public static final Duration DEFAULT_JOBS_TIMEOUT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    public static final int DEFAULT_JOBS_TIMEOUT_CHECKER_BATCH_LIMIT = Integer.MAX_VALUE;
    public static final int DEFAULT_VALIDATORS_RESULTS_OUTPUT_MAX_SIZE = 12288;
    public static final boolean DEFAULT_ENABLE_AUTHORIZATION_CHECKS = false;
    public static final int DEFAULT_MAX_PROCESS_DEPTH = 1000;
    private int messagesTtlCheckerBatchLimit = Integer.MAX_VALUE;
    private Duration messagesTtlCheckerInterval = DEFAULT_MESSAGES_TTL_CHECKER_INTERVAL;
    private int drgCacheCapacity = 1000;
    private int formCacheCapacity = 1000;
    private int resourceCacheCapacity = 1000;
    private int processCacheCapacity = 1000;
    private Duration jobsTimeoutCheckerPollingInterval = DEFAULT_JOBS_TIMEOUT_POLLING_INTERVAL;
    private int jobsTimeoutCheckerBatchLimit = Integer.MAX_VALUE;
    private int validatorsResultsOutputMaxSize = 12288;
    private boolean enableAuthorization = false;
    private int maxProcessDepth = 1000;

    public int getMessagesTtlCheckerBatchLimit() {
        return this.messagesTtlCheckerBatchLimit;
    }

    public EngineConfiguration setMessagesTtlCheckerBatchLimit(int messagesTtlCheckerBatchLimit) {
        this.messagesTtlCheckerBatchLimit = messagesTtlCheckerBatchLimit;
        return this;
    }

    public Duration getMessagesTtlCheckerInterval() {
        return this.messagesTtlCheckerInterval;
    }

    public EngineConfiguration setMessagesTtlCheckerInterval(Duration messagesTtlCheckerInterval) {
        this.messagesTtlCheckerInterval = messagesTtlCheckerInterval;
        return this;
    }

    public int getDrgCacheCapacity() {
        return this.drgCacheCapacity;
    }

    public EngineConfiguration setDrgCacheCapacity(int drgCacheCapacity) {
        this.drgCacheCapacity = drgCacheCapacity;
        return this;
    }

    public int getFormCacheCapacity() {
        return this.formCacheCapacity;
    }

    public EngineConfiguration setFormCacheCapacity(int formCacheCapacity) {
        this.formCacheCapacity = formCacheCapacity;
        return this;
    }

    public int getResourceCacheCapacity() {
        return this.resourceCacheCapacity;
    }

    public EngineConfiguration setResourceCacheCapacity(int resourceCacheCapacity) {
        this.resourceCacheCapacity = resourceCacheCapacity;
        return this;
    }

    public int getProcessCacheCapacity() {
        return this.processCacheCapacity;
    }

    public EngineConfiguration setProcessCacheCapacity(int processCacheCapacity) {
        this.processCacheCapacity = processCacheCapacity;
        return this;
    }

    public Duration getJobsTimeoutCheckerPollingInterval() {
        return this.jobsTimeoutCheckerPollingInterval;
    }

    public EngineConfiguration setJobsTimeoutCheckerPollingInterval(Duration jobsTimeoutCheckerPollingInterval) {
        this.jobsTimeoutCheckerPollingInterval = jobsTimeoutCheckerPollingInterval;
        return this;
    }

    public int getJobsTimeoutCheckerBatchLimit() {
        return this.jobsTimeoutCheckerBatchLimit;
    }

    public EngineConfiguration setJobsTimeoutCheckerBatchLimit(int jobsTimeoutCheckerBatchLimit) {
        this.jobsTimeoutCheckerBatchLimit = jobsTimeoutCheckerBatchLimit;
        return this;
    }

    public int getValidatorsResultsOutputMaxSize() {
        return this.validatorsResultsOutputMaxSize;
    }

    public EngineConfiguration setValidatorsResultsOutputMaxSize(int maxSize) {
        this.validatorsResultsOutputMaxSize = maxSize;
        return this;
    }

    public boolean isEnableAuthorization() {
        return this.enableAuthorization;
    }

    public EngineConfiguration setEnableAuthorization(boolean enableAuthorization) {
        this.enableAuthorization = enableAuthorization;
        return this;
    }

    public int getMaxProcessDepth() {
        return this.maxProcessDepth;
    }

    public EngineConfiguration setMaxProcessDepth(int maxProcessDepth) {
        this.maxProcessDepth = maxProcessDepth;
        return this;
    }
}

