/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.util.Either;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class ExpressionTransformer {
    private ExpressionTransformer() {
        throw new IllegalStateException("Expected to instantiate this class, but it is a Utility class");
    }

    public static Either<Failure, List<String>> parseListOfCsv(String value) {
        if (value.isEmpty()) {
            return Either.right(List.of());
        }
        List values = Arrays.stream(value.split(",")).filter(Predicate.not(String::isBlank)).map(String::trim).collect(Collectors.toList());
        if (values.size() < StringUtils.countMatches((CharSequence)value, (CharSequence)",") + 1) {
            return Either.left((Object)new Failure("Expected to parse list of CSV, but " + value + " is not CSV"));
        }
        return Either.right(values);
    }

    public static String asListLiteral(List<String> values) {
        return values.stream().map(ExpressionTransformer::asStringLiteral).collect(Collectors.joining(",", "[", "]"));
    }

    public static String asStringLiteral(String value) {
        return String.format("\"%s\"", value);
    }

    public static String asFeelExpressionString(String expression) {
        return String.format("=%s", expression);
    }
}

