/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceBatchRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceBatchIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ProcessInstanceBatchTerminateProcessor
implements TypedRecordProcessor<ProcessInstanceBatchRecord> {
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;
    private final KeyGenerator keyGenerator;
    private final ElementInstanceState elementInstanceState;

    public ProcessInstanceBatchTerminateProcessor(Writers writers, KeyGenerator keyGenerator, ElementInstanceState elementInstanceState) {
        this.commandWriter = writers.command();
        this.stateWriter = writers.state();
        this.keyGenerator = keyGenerator;
        this.elementInstanceState = elementInstanceState;
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceBatchRecord> record) {
        ProcessInstanceBatchRecord recordValue = (ProcessInstanceBatchRecord)record.getValue();
        List<ElementInstance> children = this.getChildInstances(recordValue, 2);
        if (!children.isEmpty()) {
            ElementInstance childInstance = children.getFirst();
            this.commandWriter.appendFollowUpCommand(childInstance.getKey(), (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)childInstance.getValue());
        }
        if (children.size() > 1) {
            this.appendFollowupBatchCommand(children.getLast(), recordValue);
        } else {
            this.stateWriter.appendFollowUpEvent(record.getKey(), (Intent)ProcessInstanceBatchIntent.TERMINATED, (RecordValue)recordValue);
        }
    }

    private List<ElementInstance> getChildInstances(ProcessInstanceBatchRecord recordValue, int limit) {
        CopyOnWriteArrayList<ElementInstance> elementInstances = new CopyOnWriteArrayList<ElementInstance>();
        this.elementInstanceState.forEachChild(recordValue.getBatchElementInstanceKey(), recordValue.getIndex(), (childKey, childInstance) -> {
            elementInstances.add((ElementInstance)((Object)childInstance));
            return elementInstances.size() < limit;
        }, childInstance -> childInstance.canTerminate());
        return elementInstances;
    }

    private void appendFollowupBatchCommand(ElementInstance childInstance, ProcessInstanceBatchRecord recordValue) {
        ProcessInstanceBatchRecord nextBatchRecord = new ProcessInstanceBatchRecord().setProcessInstanceKey(recordValue.getProcessInstanceKey()).setBatchElementInstanceKey(recordValue.getBatchElementInstanceKey()).setIndex(childInstance.getKey());
        this.commandWriter.appendFollowUpCommand(this.keyGenerator.nextKey(), (Intent)ProcessInstanceBatchIntent.TERMINATE, (RecordValue)nextBatchRecord);
    }
}

