/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.auth.impl.TenantAuthorizationCheckerImpl;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableUserTask;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.DistributionState;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class ProcessInstanceMigrationPreconditions {
    private static final EnumSet<BpmnElementType> SUPPORTED_ELEMENT_TYPES = EnumSet.of(BpmnElementType.PROCESS, new BpmnElementType[]{BpmnElementType.SERVICE_TASK, BpmnElementType.USER_TASK, BpmnElementType.SUB_PROCESS, BpmnElementType.CALL_ACTIVITY, BpmnElementType.INTERMEDIATE_CATCH_EVENT, BpmnElementType.RECEIVE_TASK, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.EXCLUSIVE_GATEWAY, BpmnElementType.EVENT_BASED_GATEWAY, BpmnElementType.BUSINESS_RULE_TASK, BpmnElementType.SCRIPT_TASK, BpmnElementType.SEND_TASK, BpmnElementType.MULTI_INSTANCE_BODY});
    private static final Set<BpmnElementType> UNSUPPORTED_ELEMENT_TYPES = EnumSet.complementOf(SUPPORTED_ELEMENT_TYPES);
    private static final Set<BpmnEventType> SUPPORTED_INTERMEDIATE_CATCH_EVENT_TYPES = EnumSet.of(BpmnEventType.MESSAGE, BpmnEventType.TIMER, BpmnEventType.SIGNAL);
    private static final String ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND = "Expected to migrate process instance but no process instance found with key '%d'";
    private static final String ERROR_MESSAGE_PROCESS_DEFINITION_NOT_FOUND = "Expected to migrate process instance to process definition but no process definition found with key '%d'";
    private static final String ERROR_MESSAGE_PROCESS_DEFINITION_HAS_START_EVENT_INSTANCE = "Expected to migrate process instance '%d' but target process definition '%s' has an active instance triggered by a message start event with correlation key '%s'. Only one instance per correlation key is allowed for message start events.";
    private static final String ERROR_MESSAGE_DUPLICATE_SOURCE_ELEMENT_IDS = "Expected to migrate process instance '%s' but the mapping instructions contain duplicate source element ids '%s'.";
    private static final String ERROR_SOURCE_ELEMENT_ID_NOT_FOUND = "Expected to migrate process instance '%s' but mapping instructions contain a non-existing source element id '%s'. Elements provided in mapping instructions must exist in the source process definition.";
    private static final String ERROR_TARGET_ELEMENT_ID_NOT_FOUND = "Expected to migrate process instance '%s' but mapping instructions contain a non-existing target element id '%s'. Elements provided in mapping instructions must exist in the target process definition.";
    private static final String ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_PROCESS_INSTANCE = "Expected to migrate process instance '%s' but active process with id '%s' has one or more event subprocesses with start events of types '%s'. Migrating event subprocesses with start events of these types is not possible yet.";
    private static final String ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_TARGET_PROCESS = "Expected to migrate process instance '%s' but target process with id '%s' has one or more event subprocesses with start events of types '%s'. Migrating event subprocesses with start events of these types is not possible yet.";
    private static final String ERROR_UNSUPPORTED_ELEMENT_TYPE = "Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported.";
    private static final String ERROR_UNSUPPORTED_INTERMEDIATE_CATCH_EVENT_TYPE = "Expected to migrate process instance '%s' but active element with id '%s' is intermediate catch event of type '%s'. Migrating active intermediate catch event of this type is not possible yet.";
    private static final String ERROR_UNSUPPORTED_ATTACHED_TO_EVENT_BASED_GATEWAY = "Expected to migrate process instance '%s' but active element with id '%s' is an intermediate catch event attached to an event-based gateway. Migrating active events attached to an event-based gateway is not possible yet.";
    private static final String ERROR_UNMAPPED_ACTIVE_ELEMENT = "Expected to migrate process instance '%s' but no mapping instruction defined for active element with id '%s'. Elements cannot be migrated without a mapping.";
    private static final String ERROR_ELEMENT_TYPE_CHANGED = "Expected to migrate process instance '%s' but active element with id '%s' and type '%s' is mapped to an element with id '%s' and different type '%s'. Elements must be mapped to elements of the same type.";
    private static final String ERROR_USER_TASK_IMPLEMENTATION_CHANGED = "Expected to migrate process instance '%s' but active user task with id '%s' and implementation '%s' is mapped to an user task with id '%s' and different implementation '%s'. Elements must be mapped to elements of the same implementation.";
    private static final String ERROR_MESSAGE_ELEMENT_FLOW_SCOPE_CHANGED = "Expected to migrate process instance '%s' but the flow scope of active element with id '%s' is changed. The flow scope of the active element is expected to be '%s' but was '%s'. The flow scope of an element cannot be changed during migration yet.";
    private static final String ERROR_ACTIVE_ELEMENT_WITH_BOUNDARY_EVENT = "Expected to migrate process instance '%s' but active element with id '%s' has one or more boundary events of types '%s'. Migrating active elements with boundary events of these types is not possible yet.";
    private static final String ERROR_TARGET_ELEMENT_WITH_BOUNDARY_EVENT = "Expected to migrate process instance '%s' but target element with id '%s' has one or more boundary events of types '%s'. Migrating target elements with boundary events of these types is not possible yet.";
    private static final String ERROR_CATCH_EVENT_DETACHED_FROM_ELEMENT = "Expected to migrate process instance '%s' but active element with id '%s' is mapped to an element with id '%s' and has a catch event with id '%s' that is mapped to a catch event with id '%s'. These mappings detach the catch event from the element in the target process. Catch events must stay attached to the same element instance.";
    private static final String ERROR_PENDING_DISTRIBUTION = "Expected to migrate process instance '%s' but active element with id '%s' has a pending message subscription migration distribution for event with id '%s'.";
    private static final String ERROR_CONCURRENT_COMMAND = "Expected to migrate process instance '%s' but a concurrent command was executed on the process instance. Please retry the migration.";
    private static final String ERROR_UPDATED_LOOP_CHARACTERISTICS = "Expected to migrate process instance '%s' but active element with id '%s' has a different loop characteristics than the target element with id '%s'. Both elements must have either sequential or parallel loop characteristics.";
    private static final String ZEEBE_USER_TASK_IMPLEMENTATION = "zeebe user task";
    private static final String JOB_WORKER_IMPLEMENTATION = "job worker";

    public static void requireNonNullProcessInstance(ElementInstance record, long processInstanceKey) {
        if (record == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, processInstanceKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.NOT_FOUND);
        }
    }

    public static void requireAuthorizedTenant(Map<String, Object> authorizations, String tenantId, long processInstanceKey) {
        boolean isTenantAuthorized = TenantAuthorizationCheckerImpl.fromAuthorizationMap(authorizations).isAuthorized(tenantId);
        if (!isTenantAuthorized) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, processInstanceKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.NOT_FOUND);
        }
    }

    public static void requireNonNullTargetProcessDefinition(DeployedProcess targetProcessDefinition, long targetProcessDefinitionKey) {
        if (targetProcessDefinition == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_DEFINITION_NOT_FOUND, targetProcessDefinitionKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.NOT_FOUND);
        }
    }

    public static void requireNoStartEventInstanceForTargetProcess(ElementInstance processInstance, DeployedProcess targetProcessDefinition, MessageState messageState) {
        if (processInstance.getValue().getBpmnProcessIdBuffer().equals((Object)targetProcessDefinition.getBpmnProcessId())) {
            return;
        }
        if (!targetProcessDefinition.getProcess().hasMessageStartEvent()) {
            return;
        }
        DirectBuffer correlationKey = messageState.getProcessInstanceCorrelationKey(processInstance.getKey());
        if (correlationKey == null) {
            return;
        }
        boolean activeProcessInstanceExistsForTarget = messageState.existActiveProcessInstance(processInstance.getValue().getTenantId(), targetProcessDefinition.getBpmnProcessId(), correlationKey);
        if (activeProcessInstanceExistsForTarget) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_DEFINITION_HAS_START_EVENT_INSTANCE, processInstance.getKey(), targetProcessDefinition.getKey(), BufferUtil.bufferAsString((DirectBuffer)correlationKey));
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNonDuplicateSourceElementIds(List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions, long processInstanceKey) {
        Map<String, Long> countBySourceElementId = mappingInstructions.stream().collect(Collectors.groupingBy(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue::getSourceElementId, Collectors.counting()));
        List<String> duplicateSourceElementIds = countBySourceElementId.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).toList();
        if (!duplicateSourceElementIds.isEmpty()) {
            String reason = String.format(ERROR_MESSAGE_DUPLICATE_SOURCE_ELEMENT_IDS, processInstanceKey, duplicateSourceElementIds);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_ARGUMENT);
        }
    }

    public static void requireReferredElementsExist(DeployedProcess sourceProcessDefinition, DeployedProcess targetProcessDefinition, List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions, long processInstanceKey) {
        mappingInstructions.forEach(instruction -> {
            String sourceElementId = instruction.getSourceElementId();
            if (sourceProcessDefinition.getProcess().getElementById(sourceElementId) == null) {
                String reason = String.format(ERROR_SOURCE_ELEMENT_ID_NOT_FOUND, processInstanceKey, sourceElementId);
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_ARGUMENT);
            }
            String targetElementId = instruction.getTargetElementId();
            if (targetProcessDefinition.getProcess().getElementById(targetElementId) == null) {
                String reason = String.format(ERROR_TARGET_ELEMENT_ID_NOT_FOUND, processInstanceKey, targetElementId);
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_ARGUMENT);
            }
        });
    }

    public static void requireNoEventSubprocessInSource(DeployedProcess sourceProcessDefinition, ProcessInstanceRecord elementInstanceRecord, EnumSet<BpmnEventType> allowedEventTypes) {
        ProcessInstanceMigrationPreconditions.requireNoEventSubprocess(sourceProcessDefinition, elementInstanceRecord, elementInstanceRecord.getElementId(), allowedEventTypes, ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_PROCESS_INSTANCE);
    }

    public static void requireNoEventSubprocessInTarget(DeployedProcess targetProcessDefinition, String targetElementId, ProcessInstanceRecord elementInstanceRecord, EnumSet<BpmnEventType> allowedEventTypes) {
        ProcessInstanceMigrationPreconditions.requireNoEventSubprocess(targetProcessDefinition, elementInstanceRecord, targetElementId, allowedEventTypes, ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_TARGET_PROCESS);
    }

    private static void requireNoEventSubprocess(DeployedProcess sourceProcessDefinition, ProcessInstanceRecord elementInstanceRecord, String elementId, EnumSet<BpmnEventType> allowedEventTypes, String errorTemplate) {
        AbstractFlowElement sourceElement = sourceProcessDefinition.getProcess().getElementById(elementId);
        if (!(sourceElement instanceof ExecutableActivity)) {
            return;
        }
        ExecutableActivity sourceActivity = (ExecutableActivity)sourceElement;
        List<ExecutableStartEvent> rejectedEvents = sourceActivity.getEventSubprocesses().stream().flatMap(sub -> sub.getStartEvents().stream()).filter(start -> !allowedEventTypes.contains(start.getEventType())).toList();
        if (!rejectedEvents.isEmpty()) {
            String rejectedEventTypes = rejectedEvents.stream().map(AbstractFlowElement::getEventType).map(Enum::name).collect(Collectors.joining(","));
            String reason = errorTemplate.formatted(elementInstanceRecord.getProcessInstanceKey(), elementId, rejectedEventTypes);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireSupportedElementType(ProcessInstanceRecord elementInstanceRecord, long processInstanceKey, DeployedProcess sourceProcessDefinition) {
        BpmnElementType bpmnElementType = elementInstanceRecord.getBpmnElementType();
        if (UNSUPPORTED_ELEMENT_TYPES.contains(bpmnElementType)) {
            String reason = String.format(ERROR_UNSUPPORTED_ELEMENT_TYPE, processInstanceKey, elementInstanceRecord.getElementId(), bpmnElementType);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
        BpmnEventType bpmnEventType = elementInstanceRecord.getBpmnEventType();
        if (bpmnElementType == BpmnElementType.INTERMEDIATE_CATCH_EVENT) {
            if (!SUPPORTED_INTERMEDIATE_CATCH_EVENT_TYPES.contains(bpmnEventType)) {
                String reason = String.format(ERROR_UNSUPPORTED_INTERMEDIATE_CATCH_EVENT_TYPE, processInstanceKey, elementInstanceRecord.getElementId(), bpmnEventType);
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
            }
            ExecutableCatchEventElement intermediateCatchEvent = sourceProcessDefinition.getProcess().getElementById(elementInstanceRecord.getElementIdBuffer(), ExecutableCatchEventElement.class);
            if (intermediateCatchEvent.isConnectedToEventBasedGateway()) {
                String reason = String.format(ERROR_UNSUPPORTED_ATTACHED_TO_EVENT_BASED_GATEWAY, processInstanceKey, elementInstanceRecord.getElementId());
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
            }
        }
    }

    public static void requireNonNullTargetElementId(String targetElementId, long processInstanceKey, String sourceElementId) {
        if (targetElementId == null) {
            String reason = String.format(ERROR_UNMAPPED_ACTIVE_ELEMENT, processInstanceKey, sourceElementId);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireSameElementType(DeployedProcess targetProcessDefinition, String targetElementId, ElementInstance elementInstance, long processInstanceKey) {
        ProcessInstanceRecord elementInstanceRecord = elementInstance.getValue();
        BpmnElementType targetElementType = targetProcessDefinition.getProcess().getElementById(targetElementId).getElementType();
        if (elementInstanceRecord.getBpmnElementType() == targetElementType) {
            return;
        }
        if (elementInstance.getMultiInstanceLoopCounter() > 0 && targetElementType == BpmnElementType.MULTI_INSTANCE_BODY) {
            ExecutableMultiInstanceBody targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableMultiInstanceBody.class);
            targetElementType = targetElement.getInnerActivity().getElementType();
            if (elementInstanceRecord.getBpmnElementType() == targetElementType) {
                return;
            }
        }
        String reason = String.format(ERROR_ELEMENT_TYPE_CHANGED, processInstanceKey, elementInstanceRecord.getElementId(), elementInstanceRecord.getBpmnElementType(), targetElementId, targetElementType);
        throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
    }

    public static void requireSameUserTaskImplementation(DeployedProcess targetProcessDefinition, String targetElementId, ElementInstance elementInstance, long processInstanceKey) {
        String sourceUserTaskType;
        ProcessInstanceRecord elementInstanceRecord = elementInstance.getValue();
        if (elementInstanceRecord.getBpmnElementType() != BpmnElementType.USER_TASK) {
            return;
        }
        AbstractFlowElement targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId);
        BpmnElementType targetElementType = targetElement.getElementType();
        if (targetElementType != BpmnElementType.USER_TASK) {
            return;
        }
        ExecutableUserTask targetUserTask = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableUserTask.class);
        String targetUserTaskType = targetUserTask.getUserTaskProperties() != null ? ZEEBE_USER_TASK_IMPLEMENTATION : JOB_WORKER_IMPLEMENTATION;
        String string = sourceUserTaskType = elementInstance.getUserTaskKey() > 0L ? ZEEBE_USER_TASK_IMPLEMENTATION : JOB_WORKER_IMPLEMENTATION;
        if (!targetUserTaskType.equals(sourceUserTaskType)) {
            String reason = String.format(ERROR_USER_TASK_IMPLEMENTATION_CHANGED, processInstanceKey, elementInstanceRecord.getElementId(), sourceUserTaskType, targetElementId, targetUserTaskType);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireUnchangedFlowScope(ElementInstanceState elementInstanceState, ProcessInstanceRecord elementInstanceRecord, DeployedProcess targetProcessDefinition, String targetElementId) {
        ElementInstance sourceFlowScopeElement = elementInstanceState.getInstance(elementInstanceRecord.getFlowScopeKey());
        if (sourceFlowScopeElement != null) {
            ExecutableMultiInstanceBody targetElement;
            DirectBuffer actualFlowScopeId;
            DirectBuffer expectedFlowScopeId = sourceFlowScopeElement.getValue().getElementIdBuffer();
            AbstractFlowElement targetFlowElement = targetProcessDefinition.getProcess().getElementById(targetElementId);
            if (targetFlowElement.getElementType() == BpmnElementType.MULTI_INSTANCE_BODY && expectedFlowScopeId.equals((Object)(actualFlowScopeId = (targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableMultiInstanceBody.class)).getInnerActivity().getFlowScope().getId()))) {
                return;
            }
            actualFlowScopeId = targetFlowElement.getFlowScope().getId();
            if (expectedFlowScopeId.equals((Object)actualFlowScopeId)) {
                return;
            }
            String reason = String.format(ERROR_MESSAGE_ELEMENT_FLOW_SCOPE_CHANGED, elementInstanceRecord.getProcessInstanceKey(), elementInstanceRecord.getElementId(), BufferUtil.bufferAsString((DirectBuffer)expectedFlowScopeId), BufferUtil.bufferAsString((DirectBuffer)actualFlowScopeId));
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoBoundaryEventInSource(DeployedProcess sourceProcessDefinition, ProcessInstanceRecord elementInstanceRecord, EnumSet<BpmnEventType> allowedEventTypes) {
        ProcessInstanceMigrationPreconditions.requireNoBoundaryEvent(sourceProcessDefinition, elementInstanceRecord, elementInstanceRecord.getElementId(), allowedEventTypes, ERROR_ACTIVE_ELEMENT_WITH_BOUNDARY_EVENT);
    }

    public static void requireNoBoundaryEventInTarget(DeployedProcess targetProcessDefinition, String targetElementId, ProcessInstanceRecord elementInstanceRecord, EnumSet<BpmnEventType> allowedEventTypes) {
        ProcessInstanceMigrationPreconditions.requireNoBoundaryEvent(targetProcessDefinition, elementInstanceRecord, targetElementId, allowedEventTypes, ERROR_TARGET_ELEMENT_WITH_BOUNDARY_EVENT);
    }

    private static void requireNoBoundaryEvent(DeployedProcess sourceProcessDefinition, ProcessInstanceRecord elementInstanceRecord, String elementId, EnumSet<BpmnEventType> allowedEventTypes, String errorTemplate) {
        AbstractFlowElement sourceElement = sourceProcessDefinition.getProcess().getElementById(elementId);
        if (!(sourceElement instanceof ExecutableActivity)) {
            return;
        }
        ExecutableActivity sourceActivity = (ExecutableActivity)sourceElement;
        List<ExecutableBoundaryEvent> rejectedBoundaryEvents = sourceActivity.getBoundaryEvents().stream().filter(event -> !allowedEventTypes.contains(event.getEventType())).toList();
        if (!rejectedBoundaryEvents.isEmpty()) {
            String rejectedEventTypes = rejectedBoundaryEvents.stream().map(AbstractFlowElement::getEventType).map(Enum::name).collect(Collectors.joining(","));
            String reason = errorTemplate.formatted(elementInstanceRecord.getProcessInstanceKey(), elementId, rejectedEventTypes);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireMappedCatchEventsToStayAttachedToSameElement(long processInstanceKey, DeployedProcess sourceProcessDefinition, DeployedProcess targetProcessDefinition, String sourceElementId, String targetElementId, Map<String, String> sourceElementIdToTargetElementId) {
        AbstractFlowElement sourceElement = sourceProcessDefinition.getProcess().getElementById(sourceElementId);
        if (!(sourceElement instanceof ExecutableCatchEventSupplier)) {
            return;
        }
        ExecutableCatchEventSupplier sourceCatchEventSupplier = (ExecutableCatchEventSupplier)((Object)sourceElement);
        for (DirectBuffer eventIdBuffer : sourceCatchEventSupplier.getEvents().stream().map(ExecutableFlowElement::getId).toList()) {
            String sourceCatchEventId = BufferUtil.bufferAsString((DirectBuffer)eventIdBuffer);
            if (!sourceElementIdToTargetElementId.containsKey(sourceCatchEventId)) continue;
            String targetCatchEventId = sourceElementIdToTargetElementId.get(sourceCatchEventId);
            ExecutableCatchEventSupplier targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableCatchEventSupplier.class);
            if (!targetElement.getEvents().stream().map(catchEvent -> BufferUtil.bufferAsString((DirectBuffer)catchEvent.getId())).noneMatch(targetCatchEventId::equals)) continue;
            String reason = String.format(ERROR_CATCH_EVENT_DETACHED_FROM_ELEMENT, processInstanceKey, sourceElementId, targetElementId, sourceCatchEventId, targetCatchEventId);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoDuplicateTargetsInCatchEventMappings(long processInstanceKey, DeployedProcess sourceProcessDefinition, String sourceElementId, Map<String, String> mappingInstructions) {
        AbstractFlowElement sourceElement = sourceProcessDefinition.getProcess().getElementById(sourceElementId);
        if (!(sourceElement instanceof ExecutableCatchEventSupplier)) {
            return;
        }
        ExecutableCatchEventSupplier sourceElementWithEvents = (ExecutableCatchEventSupplier)((Object)sourceElement);
        HashMap<String, List> sourceCatchEventIdsByTargetCatchEventId = new HashMap<String, List>();
        sourceElementWithEvents.getEvents().stream().map(catchEvent -> BufferUtil.bufferAsString((DirectBuffer)catchEvent.getId())).filter(mappingInstructions::containsKey).forEach(sourceCatchEventId -> {
            String targetCatchEventId = (String)mappingInstructions.get(sourceCatchEventId);
            sourceCatchEventIdsByTargetCatchEventId.computeIfAbsent(targetCatchEventId, k -> new ArrayList()).add(sourceCatchEventId);
        });
        sourceCatchEventIdsByTargetCatchEventId.forEach((targetCatchEventId, sourceCatchEventIds) -> {
            if (sourceCatchEventIds.size() > 1) {
                String reason = String.format("Expected to migrate process instance '%s' but active element with id '%s' has a catch event attached that is mapped to a catch event with id '%s'. There are multiple mapping instructions that target this catch event: '%s'. Catch events cannot be merged by process instance migration. Please ensure the mapping instructions target a catch event only once.", processInstanceKey, sourceElementId, targetCatchEventId, sourceCatchEventIds.stream().sorted().collect(Collectors.joining("', '")));
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
            }
        });
    }

    public static void requireNoCatchEventMappingToChangeEventType(long processInstanceKey, Map<String, String> mappingInstructions, DeployedProcess sourceProcessDefinition, DeployedProcess targetProcessDefinition, String sourceElementId) {
        AbstractFlowElement sourceElement = sourceProcessDefinition.getProcess().getElementById(sourceElementId);
        if (!(sourceElement instanceof ExecutableCatchEventSupplier)) {
            return;
        }
        ExecutableCatchEventSupplier sourceElementWithEvents = (ExecutableCatchEventSupplier)((Object)sourceElement);
        for (ExecutableCatchEvent sourceCatchEvent : sourceElementWithEvents.getEvents()) {
            String sourceCatchEventId = BufferUtil.bufferAsString((DirectBuffer)sourceCatchEvent.getId());
            if (!mappingInstructions.containsKey(sourceCatchEventId)) continue;
            String targetCatchEventId = mappingInstructions.get(sourceCatchEventId);
            AbstractFlowElement targetCatchEvent = targetProcessDefinition.getProcess().getElementById(targetCatchEventId);
            if (sourceCatchEvent.getEventType() == targetCatchEvent.getEventType()) continue;
            String reason = String.format("Expected to migrate process instance '%s' but active element with id '%s' has a catch event with id '%s' that is mapped to a catch event with id '%s'. These catch events have different event types: '%s' and '%s'. The event type of a catch event cannot be changed by process instance migration. Please ensure the event type of the catch event remains the same or remove the mapping instruction for these catch events.", processInstanceKey, sourceElementId, sourceCatchEventId, targetCatchEventId, sourceCatchEvent.getEventType(), targetCatchEvent.getEventType());
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoConcurrentCommand(EventScopeInstanceState eventScopeInstanceState, ElementInstance elementInstance, long processInstanceKey) {
        EventTrigger eventTrigger = eventScopeInstanceState.peekEventTrigger(elementInstance.getKey());
        if (eventTrigger != null || elementInstance.getActiveSequenceFlows() > 0L) {
            String reason = String.format(ERROR_CONCURRENT_COMMAND, processInstanceKey);
            throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoSubscriptionForMessage(boolean existSubscriptionForMessageName, ElementInstance elementInstance, DirectBuffer messageName, String targetCatchEventId) {
        if (existSubscriptionForMessageName) {
            long processInstanceKey = elementInstance.getValue().getProcessInstanceKey();
            String elementId = elementInstance.getValue().getElementId();
            String messageNameString = BufferUtil.bufferAsString((DirectBuffer)messageName);
            throw new ProcessInstanceMigrationPreconditionFailedException("Expected to migrate process instance '%s' but active element with id '%s' attempts to subscribe to a message it is already subscribed to with name '%s'. Migrating active elements that subscribe to a message they are already subscribed to is not possible yet. Please provide a mapping instruction to message catch event with id '%s' to migrate the respective message subscription.".formatted(processInstanceKey, elementId, messageNameString, targetCatchEventId), RejectionType.INVALID_STATE);
        }
    }

    public static void requireNoPendingMsgSubMigrationDistribution(DistributionState distributionState, long distributionKey, String elementId, long processInstanceKey, String eventElementId) {
        String message = ERROR_PENDING_DISTRIBUTION.formatted(processInstanceKey, elementId, eventElementId);
        ProcessInstanceMigrationPreconditions.requireNoPendingMigrationDistribution(distributionState, distributionKey, message);
    }

    public static void requireSameMultiInstanceLoopCharacteristics(DeployedProcess sourceProcessDefinition, String sourceElementId, DeployedProcess targetProcessDefinition, String targetElementId, long processInstanceKey) {
        BpmnElementType targetElementType = targetProcessDefinition.getProcess().getElementById(targetElementId).getElementType();
        BpmnElementType sourceElementType = sourceProcessDefinition.getProcess().getElementById(sourceElementId).getElementType();
        if (sourceElementType == BpmnElementType.MULTI_INSTANCE_BODY && targetElementType == BpmnElementType.MULTI_INSTANCE_BODY) {
            ExecutableMultiInstanceBody targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableMultiInstanceBody.class);
            ExecutableMultiInstanceBody sourceElement = sourceProcessDefinition.getProcess().getElementById(sourceElementId, ExecutableMultiInstanceBody.class);
            if (targetElement.getLoopCharacteristics().isSequential() != sourceElement.getLoopCharacteristics().isSequential()) {
                String reason = String.format(ERROR_UPDATED_LOOP_CHARACTERISTICS, processInstanceKey, sourceElementId, targetElementId);
                throw new ProcessInstanceMigrationPreconditionFailedException(reason, RejectionType.INVALID_STATE);
            }
        }
    }

    private static void requireNoPendingMigrationDistribution(DistributionState distributionState, long distributionKey, String message) {
        if (distributionState.hasPendingDistribution(distributionKey)) {
            throw new ProcessInstanceMigrationPreconditionFailedException(message, RejectionType.INVALID_STATE);
        }
    }

    public static final class ProcessInstanceMigrationPreconditionFailedException
    extends RuntimeException {
        private final RejectionType rejectionType;

        public ProcessInstanceMigrationPreconditionFailedException(String message, RejectionType rejectionType) {
            super(message);
            this.rejectionType = rejectionType;
        }

        public RejectionType getRejectionType() {
            return this.rejectionType;
        }
    }
}

