/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.Vibrator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.OrientationEventListener;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import io.card.payment.CameraUnavailableException;
import io.card.payment.CardScanner;
import io.card.payment.CreditCard;
import io.card.payment.DataEntryActivity;
import io.card.payment.DetectionInfo;
import io.card.payment.OverlayView;
import io.card.payment.Preview;
import io.card.payment.Util;
import io.card.payment.i18n.LocalizedStrings;
import io.card.payment.i18n.StringKey;
import io.card.payment.ui.ActivityHelper;
import io.card.payment.ui.ViewUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Date;

public final class CardIOActivity
extends Activity {
    public static final String EXTRA_NO_CAMERA = "io.card.payment.noCamera";
    public static final String EXTRA_REQUIRE_EXPIRY = "io.card.payment.requireExpiry";
    public static final String EXTRA_SCAN_EXPIRY = "io.card.payment.scanExpiry";
    public static final String EXTRA_UNBLUR_DIGITS = "io.card.payment.unblurDigits";
    public static final String EXTRA_REQUIRE_CVV = "io.card.payment.requireCVV";
    public static final String EXTRA_REQUIRE_POSTAL_CODE = "io.card.payment.requirePostalCode";
    public static final String EXTRA_RESTRICT_POSTAL_CODE_TO_NUMERIC_ONLY = "io.card.payment.restrictPostalCodeToNumericOnly";
    public static final String EXTRA_REQUIRE_CARDHOLDER_NAME = "io.card.payment.requireCardholderName";
    public static final String EXTRA_USE_CARDIO_LOGO = "io.card.payment.useCardIOLogo";
    public static final String EXTRA_SCAN_RESULT = "io.card.payment.scanResult";
    public static final String EXTRA_SUPPRESS_MANUAL_ENTRY = "io.card.payment.suppressManual";
    public static final String EXTRA_LANGUAGE_OR_LOCALE = "io.card.payment.languageOrLocale";
    public static final String EXTRA_GUIDE_COLOR = "io.card.payment.guideColor";
    public static final String EXTRA_SUPPRESS_CONFIRMATION = "io.card.payment.suppressConfirmation";
    public static final String EXTRA_HIDE_CARDIO_LOGO = "io.card.payment.hideLogo";
    public static final String EXTRA_SCAN_INSTRUCTIONS = "io.card.payment.scanInstructions";
    public static final String EXTRA_SUPPRESS_SCAN = "io.card.payment.suppressScan";
    public static final String EXTRA_CAPTURED_CARD_IMAGE = "io.card.payment.capturedCardImage";
    public static final String EXTRA_RETURN_CARD_IMAGE = "io.card.payment.returnCardImage";
    public static final String EXTRA_SCAN_OVERLAY_LAYOUT_ID = "io.card.payment.scanOverlayLayoutId";
    public static final String EXTRA_USE_PAYPAL_ACTIONBAR_ICON = "io.card.payment.intentSenderIsPayPal";
    public static final String EXTRA_KEEP_APPLICATION_THEME = "io.card.payment.keepApplicationTheme";
    private static int lastResult = 13274384;
    public static final int RESULT_CARD_INFO = lastResult++;
    public static final int RESULT_ENTRY_CANCELED = lastResult++;
    public static final int RESULT_SCAN_NOT_AVAILABLE = lastResult++;
    public static final int RESULT_SCAN_SUPPRESSED = lastResult++;
    public static final int RESULT_CONFIRMATION_SUPPRESSED = lastResult++;
    private static final String TAG = CardIOActivity.class.getSimpleName();
    private static final long[] VIBRATE_PATTERN = new long[]{0L, 70L, 10L, 40L};
    private OverlayView mOverlay;
    private OrientationEventListener orientationListener;
    Preview mPreview;
    private CreditCard mDetectedCard;
    private Rect mGuideFrame;
    private int mLastDegrees;
    private int mFrameOrientation;
    private boolean suppressManualEntry;
    private boolean mDetectOnly;
    private LinearLayout customOverlayLayout;
    private boolean waitingForPermission;
    private RelativeLayout mUIBar;
    private FrameLayout mMainLayout;
    private boolean useApplicationTheme;
    private static int numActivityAllocations;
    private CardScanner mCardScanner;
    private boolean manualEntryFallbackOrForced = false;
    static Bitmap markedCardImage;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (++numActivityAllocations != 1) {
            Log.i((String)TAG, (String)String.format("INTERNAL WARNING: There are %d (not 1) CardIOActivity allocations!", numActivityAllocations));
        }
        Intent clientData = this.getIntent();
        this.useApplicationTheme = this.getIntent().getBooleanExtra(EXTRA_KEEP_APPLICATION_THEME, false);
        ActivityHelper.setActivityTheme(this, this.useApplicationTheme);
        LocalizedStrings.setLanguage(clientData);
        this.mDetectOnly = clientData.getBooleanExtra(EXTRA_SUPPRESS_SCAN, false);
        ResolveInfo resolveInfo = this.getPackageManager().resolveActivity(clientData, 65536);
        String errorMsg = Util.manifestHasConfigChange(resolveInfo, CardIOActivity.class);
        if (errorMsg != null) {
            throw new RuntimeException(errorMsg);
        }
        this.suppressManualEntry = clientData.getBooleanExtra(EXTRA_SUPPRESS_MANUAL_ENTRY, false);
        if (savedInstanceState != null) {
            this.waitingForPermission = savedInstanceState.getBoolean("io.card.payment.waitingForPermission");
        }
        if (clientData.getBooleanExtra(EXTRA_NO_CAMERA, false)) {
            Log.i((String)"card.io", (String)"EXTRA_NO_CAMERA set to true. Skipping camera.");
            this.manualEntryFallbackOrForced = true;
        } else if (!CardScanner.processorSupported()) {
            Log.i((String)"card.io", (String)"Processor not Supported. Skipping camera.");
            this.manualEntryFallbackOrForced = true;
        } else {
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    if (!this.waitingForPermission) {
                        if (this.checkSelfPermission("android.permission.CAMERA") == -1) {
                            Log.d((String)TAG, (String)"permission denied to camera - requesting it");
                            String[] permissions = new String[]{"android.permission.CAMERA"};
                            this.waitingForPermission = true;
                            this.requestPermissions(permissions, 11);
                        } else {
                            this.checkCamera();
                            this.android23AndAboveHandleCamera();
                        }
                    }
                } else {
                    this.checkCamera();
                    this.android22AndBelowHandleCamera();
                }
            }
            catch (Exception e) {
                this.handleGeneralExceptionError(e);
            }
        }
    }

    private void android23AndAboveHandleCamera() {
        if (this.manualEntryFallbackOrForced) {
            this.finishIfSuppressManualEntry();
        } else {
            this.showCameraScannerOverlay();
        }
    }

    private void android22AndBelowHandleCamera() {
        if (this.manualEntryFallbackOrForced) {
            this.finishIfSuppressManualEntry();
        } else {
            this.requestWindowFeature(1);
            this.showCameraScannerOverlay();
        }
    }

    private void finishIfSuppressManualEntry() {
        if (this.suppressManualEntry) {
            Log.i((String)"card.io", (String)"Camera not available and manual entry suppressed.");
            this.setResultAndFinish(RESULT_SCAN_NOT_AVAILABLE, null);
        }
    }

    private void checkCamera() {
        try {
            if (!Util.hardwareSupported()) {
                StringKey errorKey = StringKey.ERROR_NO_DEVICE_SUPPORT;
                String localizedError = LocalizedStrings.getString(errorKey);
                Log.w((String)"card.io", (String)((Object)((Object)errorKey) + ": " + localizedError));
                this.manualEntryFallbackOrForced = true;
            }
        }
        catch (CameraUnavailableException e) {
            StringKey errorKey = StringKey.ERROR_CAMERA_CONNECT_FAIL;
            String localizedError = LocalizedStrings.getString(errorKey);
            Log.e((String)"card.io", (String)((Object)((Object)errorKey) + ": " + localizedError));
            Toast toast = Toast.makeText((Context)this, (CharSequence)localizedError, (int)1);
            toast.setGravity(17, 0, -75);
            toast.show();
            this.manualEntryFallbackOrForced = true;
        }
    }

    private void showCameraScannerOverlay() {
        if (Build.VERSION.SDK_INT >= 16) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 4;
            decorView.setSystemUiVisibility(uiOptions);
            ActionBar actionBar = this.getActionBar();
            if (null != actionBar) {
                actionBar.hide();
            }
        }
        try {
            this.mGuideFrame = new Rect();
            this.mFrameOrientation = 1;
            if (this.getIntent().getBooleanExtra("io.card.payment.cameraBypassTestMode", false)) {
                if (!this.getPackageName().contentEquals("io.card.development")) {
                    throw new IllegalStateException("Illegal access of private extra");
                }
                Class<?> testScannerClass = Class.forName("io.card.payment.CardScannerTester");
                Constructor<?> cons = testScannerClass.getConstructor(((Object)((Object)this)).getClass(), Integer.TYPE);
                this.mCardScanner = (CardScanner)cons.newInstance(new Object[]{this, this.mFrameOrientation});
            } else {
                this.mCardScanner = new CardScanner(this, this.mFrameOrientation);
            }
            this.mCardScanner.prepareScanner();
            this.setPreviewLayout();
            this.orientationListener = new OrientationEventListener((Context)this, 2){

                public void onOrientationChanged(int orientation) {
                    CardIOActivity.this.doOrientationChange(orientation);
                }
            };
        }
        catch (Exception e) {
            this.handleGeneralExceptionError(e);
        }
    }

    private void handleGeneralExceptionError(Exception e) {
        StringKey errorKey = StringKey.ERROR_CAMERA_UNEXPECTED_FAIL;
        String localizedError = LocalizedStrings.getString(errorKey);
        Log.e((String)"card.io", (String)"Unknown exception, please post the stack trace as a GitHub issue", (Throwable)e);
        Toast toast = Toast.makeText((Context)this, (CharSequence)localizedError, (int)1);
        toast.setGravity(17, 0, -75);
        toast.show();
        this.manualEntryFallbackOrForced = true;
    }

    private void doOrientationChange(int orientation) {
        if (orientation < 0 || this.mCardScanner == null) {
            return;
        }
        if ((orientation += this.mCardScanner.getRotationalOffset()) > 360) {
            orientation -= 360;
        }
        int degrees = -1;
        if (orientation < 15 || orientation > 345) {
            degrees = 0;
            this.mFrameOrientation = 1;
        } else if (orientation > 75 && orientation < 105) {
            degrees = 90;
            this.mFrameOrientation = 4;
        } else if (orientation > 165 && orientation < 195) {
            degrees = 180;
            this.mFrameOrientation = 2;
        } else if (orientation > 255 && orientation < 285) {
            degrees = 270;
            this.mFrameOrientation = 3;
        }
        if (degrees >= 0 && degrees != this.mLastDegrees) {
            this.mCardScanner.setDeviceOrientation(this.mFrameOrientation);
            this.setDeviceDegrees(degrees);
            if (degrees == 90) {
                this.rotateCustomOverlay(270.0f);
            } else if (degrees == 270) {
                this.rotateCustomOverlay(90.0f);
            } else {
                this.rotateCustomOverlay(degrees);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.waitingForPermission) {
            if (this.manualEntryFallbackOrForced) {
                this.nextActivity();
                return;
            }
            Util.logNativeMemoryStats();
            this.getWindow().addFlags(1024);
            this.getWindow().addFlags(128);
            ActivityHelper.setFlagSecure(this);
            this.setRequestedOrientation(1);
            this.orientationListener.enable();
            if (!this.restartPreview()) {
                Log.e((String)TAG, (String)"Could not connect to camera.");
                StringKey error = StringKey.ERROR_CAMERA_UNEXPECTED_FAIL;
                this.showErrorMessage(LocalizedStrings.getString(error));
                this.nextActivity();
            } else {
                this.setFlashOn(false);
            }
            this.doOrientationChange(this.mLastDegrees);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("io.card.payment.waitingForPermission", this.waitingForPermission);
    }

    protected void onPause() {
        super.onPause();
        if (this.orientationListener != null) {
            this.orientationListener.disable();
        }
        this.setFlashOn(false);
        if (this.mCardScanner != null) {
            this.mCardScanner.pauseScanning();
        }
    }

    protected void onDestroy() {
        this.mOverlay = null;
        --numActivityAllocations;
        if (this.orientationListener != null) {
            this.orientationListener.disable();
        }
        this.setFlashOn(false);
        if (this.mCardScanner != null) {
            this.mCardScanner.endScanning();
            this.mCardScanner = null;
        }
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 11) {
            this.waitingForPermission = false;
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.showCameraScannerOverlay();
            } else {
                this.manualEntryFallbackOrForced = true;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 10: {
                if (resultCode == 0) {
                    Log.d((String)TAG, (String)"ignoring onActivityResult(RESULT_CANCELED) caused only when Camera Permissions are Denied in Android 23");
                    break;
                }
                if (resultCode == RESULT_CARD_INFO || resultCode == RESULT_ENTRY_CANCELED || this.manualEntryFallbackOrForced) {
                    if (data != null && data.hasExtra(EXTRA_SCAN_RESULT)) {
                        Log.v((String)TAG, (String)("EXTRA_SCAN_RESULT: " + data.getParcelableExtra(EXTRA_SCAN_RESULT)));
                    } else {
                        Log.d((String)TAG, (String)"no data in EXTRA_SCAN_RESULT");
                    }
                    this.setResultAndFinish(resultCode, data);
                    break;
                }
                if (this.mUIBar == null) break;
                this.mUIBar.setVisibility(0);
            }
        }
    }

    public void onBackPressed() {
        if (!this.manualEntryFallbackOrForced && this.mOverlay.isAnimating()) {
            try {
                this.restartPreview();
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)("*** could not return to preview: " + re));
            }
        } else if (this.mCardScanner != null) {
            super.onBackPressed();
        }
    }

    public static boolean canReadCardWithCamera() {
        try {
            return Util.hardwareSupported();
        }
        catch (CameraUnavailableException e) {
            return false;
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"RuntimeException accessing Util.hardwareSupported()");
            return false;
        }
    }

    public static String sdkVersion() {
        return "5.5.1";
    }

    public static Date sdkBuildDate() {
        return new Date("03/17/2017 14:23:12 -0400");
    }

    public static Bitmap getCapturedCardImage(Intent intent) {
        if (intent == null || !intent.hasExtra(EXTRA_CAPTURED_CARD_IMAGE)) {
            return null;
        }
        byte[] imageData = intent.getByteArrayExtra(EXTRA_CAPTURED_CARD_IMAGE);
        ByteArrayInputStream inStream = new ByteArrayInputStream(imageData);
        Bitmap result = BitmapFactory.decodeStream((InputStream)inStream, null, (BitmapFactory.Options)new BitmapFactory.Options());
        return result;
    }

    void onFirstFrame(int orientation) {
        SurfaceView sv = this.mPreview.getSurfaceView();
        if (this.mOverlay != null) {
            this.mOverlay.setCameraPreviewRect(new Rect(sv.getLeft(), sv.getTop(), sv.getRight(), sv.getBottom()));
        }
        this.mFrameOrientation = 1;
        this.setDeviceDegrees(0);
        if (orientation != this.mFrameOrientation) {
            Log.wtf((String)"card.io", (String)"the orientation of the scanner doesn't match the orientation of the activity");
        }
        this.onEdgeUpdate(new DetectionInfo());
    }

    void onEdgeUpdate(DetectionInfo dInfo) {
        this.mOverlay.setDetectionInfo(dInfo);
    }

    void onCardDetected(Bitmap detectedBitmap, DetectionInfo dInfo) {
        try {
            Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
            vibrator.vibrate(VIBRATE_PATTERN, -1);
        }
        catch (SecurityException e) {
            Log.e((String)"card.io", (String)"Could not activate vibration feedback. Please add <uses-permission android:name=\"android.permission.VIBRATE\" /> to your application's manifest.");
        }
        catch (Exception e) {
            Log.w((String)"card.io", (String)"Exception while attempting to vibrate: ", (Throwable)e);
        }
        this.mCardScanner.pauseScanning();
        this.mUIBar.setVisibility(4);
        if (dInfo.predicted()) {
            this.mDetectedCard = dInfo.creditCard();
            this.mOverlay.setDetectedCard(this.mDetectedCard);
        }
        float sf = this.mFrameOrientation == 1 || this.mFrameOrientation == 2 ? (float)this.mGuideFrame.right / 428.0f * 0.95f : (float)this.mGuideFrame.right / 428.0f * 1.15f;
        Matrix m = new Matrix();
        m.postScale(sf, sf);
        Bitmap scaledCard = Bitmap.createBitmap((Bitmap)detectedBitmap, (int)0, (int)0, (int)detectedBitmap.getWidth(), (int)detectedBitmap.getHeight(), (Matrix)m, (boolean)false);
        this.mOverlay.setBitmap(scaledCard);
        if (this.mDetectOnly) {
            Intent dataIntent = new Intent();
            Util.writeCapturedCardImageIfNecessary(this.getIntent(), dataIntent, this.mOverlay);
            this.setResultAndFinish(RESULT_SCAN_SUPPRESSED, dataIntent);
        } else {
            this.nextActivity();
        }
    }

    private void nextActivity() {
        final Intent origIntent = this.getIntent();
        if (origIntent != null && origIntent.getBooleanExtra(EXTRA_SUPPRESS_CONFIRMATION, false)) {
            Intent dataIntent = new Intent((Context)this, DataEntryActivity.class);
            if (this.mDetectedCard != null) {
                dataIntent.putExtra(EXTRA_SCAN_RESULT, (Parcelable)this.mDetectedCard);
                this.mDetectedCard = null;
            }
            Util.writeCapturedCardImageIfNecessary(origIntent, dataIntent, this.mOverlay);
            this.setResultAndFinish(RESULT_CONFIRMATION_SUPPRESSED, dataIntent);
        } else {
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    CardIOActivity.this.getWindow().clearFlags(1024);
                    CardIOActivity.this.getWindow().addFlags(512);
                    Intent dataIntent = new Intent((Context)CardIOActivity.this, DataEntryActivity.class);
                    Util.writeCapturedCardImageIfNecessary(origIntent, dataIntent, CardIOActivity.this.mOverlay);
                    if (CardIOActivity.this.mOverlay != null) {
                        CardIOActivity.this.mOverlay.markupCard();
                        if (markedCardImage != null && !markedCardImage.isRecycled()) {
                            markedCardImage.recycle();
                        }
                        markedCardImage = CardIOActivity.this.mOverlay.getCardImage();
                    }
                    if (CardIOActivity.this.mDetectedCard != null) {
                        dataIntent.putExtra(CardIOActivity.EXTRA_SCAN_RESULT, (Parcelable)CardIOActivity.this.mDetectedCard);
                        CardIOActivity.this.mDetectedCard = null;
                    } else {
                        dataIntent.putExtra("io.card.payment.manualEntryScanResult", true);
                    }
                    dataIntent.putExtras(CardIOActivity.this.getIntent());
                    dataIntent.addFlags(1082195968);
                    CardIOActivity.this.startActivityForResult(dataIntent, 10);
                }
            });
        }
    }

    private void showErrorMessage(String msgStr) {
        Log.e((String)"card.io", (String)("error display: " + msgStr));
        Toast toast = Toast.makeText((Context)this, (CharSequence)msgStr, (int)1);
        toast.show();
    }

    private boolean restartPreview() {
        this.mDetectedCard = null;
        assert (this.mPreview != null);
        boolean success = this.mCardScanner.resumeScanning(this.mPreview.getSurfaceHolder());
        if (success) {
            this.mUIBar.setVisibility(0);
        }
        return success;
    }

    private void setDeviceDegrees(int degrees) {
        SurfaceView sv = this.mPreview.getSurfaceView();
        if (sv == null) {
            Log.wtf((String)"card.io", (String)"surface view is null.. recovering... rotation might be weird.");
            return;
        }
        this.mGuideFrame = this.mCardScanner.getGuideFrame(sv.getWidth(), sv.getHeight());
        this.mGuideFrame.top += sv.getTop();
        this.mGuideFrame.bottom += sv.getTop();
        this.mOverlay.setGuideAndRotation(this.mGuideFrame, degrees);
        this.mLastDegrees = degrees;
    }

    void toggleFlash() {
        this.setFlashOn(!this.mCardScanner.isFlashOn());
    }

    void setFlashOn(boolean b) {
        boolean success;
        boolean bl = success = this.mPreview != null && this.mOverlay != null && this.mCardScanner.setFlashOn(b);
        if (success) {
            this.mOverlay.setTorchOn(b);
        }
    }

    void triggerAutoFocus() {
        this.mCardScanner.triggerAutoFocus(true);
    }

    private void setPreviewLayout() {
        this.mMainLayout = new FrameLayout((Context)this);
        this.mMainLayout.setBackgroundColor(-16777216);
        this.mMainLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        FrameLayout previewFrame = new FrameLayout((Context)this);
        previewFrame.setId(1);
        this.mPreview = new Preview((Context)this, null, this.mCardScanner.mPreviewWidth, this.mCardScanner.mPreviewHeight);
        this.mPreview.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 48));
        previewFrame.addView((View)this.mPreview);
        this.mOverlay = new OverlayView(this, null, Util.deviceSupportsTorch((Context)this));
        this.mOverlay.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        if (this.getIntent() != null) {
            boolean useCardIOLogo = this.getIntent().getBooleanExtra(EXTRA_USE_CARDIO_LOGO, false);
            this.mOverlay.setUseCardIOLogo(useCardIOLogo);
            int color = this.getIntent().getIntExtra(EXTRA_GUIDE_COLOR, 0);
            if (color != 0) {
                int alphaRemovedColor = color | 0xFF000000;
                if (color != alphaRemovedColor) {
                    Log.w((String)"card.io", (String)"Removing transparency from provided guide color.");
                }
                this.mOverlay.setGuideColor(alphaRemovedColor);
            } else {
                this.mOverlay.setGuideColor(-16711936);
            }
            boolean hideCardIOLogo = this.getIntent().getBooleanExtra(EXTRA_HIDE_CARDIO_LOGO, false);
            this.mOverlay.setHideCardIOLogo(hideCardIOLogo);
            String scanInstructions = this.getIntent().getStringExtra(EXTRA_SCAN_INSTRUCTIONS);
            if (scanInstructions != null) {
                this.mOverlay.setScanInstructions(scanInstructions);
            }
        }
        previewFrame.addView((View)this.mOverlay);
        RelativeLayout.LayoutParams previewParams = new RelativeLayout.LayoutParams(-1, -1);
        previewParams.addRule(10);
        previewParams.addRule(2, 2);
        this.mMainLayout.addView((View)previewFrame, (ViewGroup.LayoutParams)previewParams);
        this.mUIBar = new RelativeLayout((Context)this);
        this.mUIBar.setGravity(80);
        RelativeLayout.LayoutParams mUIBarParams = new RelativeLayout.LayoutParams(-1, -2);
        previewParams.addRule(12);
        this.mUIBar.setLayoutParams((ViewGroup.LayoutParams)mUIBarParams);
        this.mUIBar.setId(2);
        this.mUIBar.setGravity(85);
        if (!this.suppressManualEntry) {
            Button keyboardBtn = new Button((Context)this);
            keyboardBtn.setId(3);
            keyboardBtn.setText((CharSequence)LocalizedStrings.getString(StringKey.KEYBOARD));
            keyboardBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CardIOActivity.this.nextActivity();
                }
            });
            this.mUIBar.addView((View)keyboardBtn);
            ViewUtil.styleAsButton(keyboardBtn, false, (Context)this, this.useApplicationTheme);
            if (!this.useApplicationTheme) {
                keyboardBtn.setTextSize(14.0f);
            }
            keyboardBtn.setMinimumHeight(ViewUtil.typedDimensionValueToPixelsInt("42dip", (Context)this));
            RelativeLayout.LayoutParams keyboardParams = (RelativeLayout.LayoutParams)keyboardBtn.getLayoutParams();
            keyboardParams.width = -2;
            keyboardParams.height = -2;
            keyboardParams.addRule(12);
            ViewUtil.setPadding((View)keyboardBtn, "16dip", null, "16dip", null);
            ViewUtil.setMargins((View)keyboardBtn, "4dip", "4dip", "4dip", "4dip");
        }
        RelativeLayout.LayoutParams uiParams = new RelativeLayout.LayoutParams(-1, -2);
        uiParams.addRule(12);
        float scale = this.getResources().getDisplayMetrics().density;
        int uiBarMarginPx = (int)(15.0f * scale + 0.5f);
        uiParams.setMargins(0, uiBarMarginPx, 0, uiBarMarginPx);
        this.mMainLayout.addView((View)this.mUIBar, (ViewGroup.LayoutParams)uiParams);
        if (this.getIntent() != null) {
            int resourceId;
            if (this.customOverlayLayout != null) {
                this.mMainLayout.removeView((View)this.customOverlayLayout);
                this.customOverlayLayout = null;
            }
            if ((resourceId = this.getIntent().getIntExtra(EXTRA_SCAN_OVERLAY_LAYOUT_ID, -1)) != -1) {
                this.customOverlayLayout = new LinearLayout((Context)this);
                this.customOverlayLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                LayoutInflater inflater = this.getLayoutInflater();
                inflater.inflate(resourceId, (ViewGroup)this.customOverlayLayout);
                this.mMainLayout.addView((View)this.customOverlayLayout);
            }
        }
        this.setContentView((View)this.mMainLayout);
    }

    private void rotateCustomOverlay(float degrees) {
        if (this.customOverlayLayout != null) {
            float pivotX = this.customOverlayLayout.getWidth() / 2;
            float pivotY = this.customOverlayLayout.getHeight() / 2;
            RotateAnimation an = new RotateAnimation(0.0f, degrees, pivotX, pivotY);
            an.setDuration(0L);
            an.setRepeatCount(0);
            an.setFillAfter(true);
            this.customOverlayLayout.setAnimation((Animation)an);
        }
    }

    private void setResultAndFinish(int resultCode, Intent data) {
        this.setResult(resultCode, data);
        markedCardImage = null;
        this.finish();
    }

    public Rect getTorchRect() {
        if (this.mOverlay == null) {
            return null;
        }
        return this.mOverlay.getTorchRect();
    }

    static {
        markedCardImage = null;
    }
}

