/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import io.card.payment.CardIOActivity;
import io.card.payment.CardIONativeLibsConfig;
import io.card.payment.DetectionInfo;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;

class CardScanner
implements Camera.AutoFocusCallback,
Camera.PreviewCallback,
SurfaceHolder.Callback {
    private static final String TAG = CardScanner.class.getSimpleName();
    private Bitmap detectedBitmap;
    private static boolean manualFallbackForError;
    protected WeakReference<CardIOActivity> mScanActivityRef;
    private boolean mSuppressScan = false;
    private boolean mScanExpiry;
    private int mUnblurDigits = -1;
    final int mPreviewWidth = 640;
    final int mPreviewHeight = 480;
    private int mFrameOrientation = 1;
    private boolean mFirstPreviewFrame = true;
    private long captureStart;
    private long mAutoFocusStartedAt;
    private long mAutoFocusCompletedAt;
    private Camera mCamera;
    private byte[] mPreviewBuffer;
    protected boolean useCamera = true;
    private boolean isSurfaceValid;
    private int numManualRefocus;
    private int numAutoRefocus;
    private int numManualTorchChange;
    private int numFramesSkipped;
    private static boolean processingInProgress;

    public static native boolean nUseNeon();

    public static native boolean nUseTegra();

    public static native boolean nUseX86();

    private native void nSetup(boolean var1, float var2);

    private native void nSetup(boolean var1, float var2, int var3);

    private native void nResetAnalytics();

    private native void nGetGuideFrame(int var1, int var2, int var3, Rect var4);

    private native void nScanFrame(byte[] var1, int var2, int var3, int var4, DetectionInfo var5, Bitmap var6, boolean var7);

    private native int nGetNumFramesScanned();

    private native void nCleanup();

    private static void loadLibrary(String libraryName) throws UnsatisfiedLinkError {
        try {
            System.loadLibrary(libraryName);
        }
        catch (UnsatisfiedLinkError e) {
            String altLibsPath = CardIONativeLibsConfig.getAlternativeLibsPath();
            if (altLibsPath == null || altLibsPath.length() == 0) {
                throw e;
            }
            if (!File.separator.equals(Character.valueOf(altLibsPath.charAt(altLibsPath.length() - 1)))) {
                altLibsPath = altLibsPath + File.separator;
            }
            String fullPath = altLibsPath + Build.CPU_ABI + File.separator + System.mapLibraryName(libraryName);
            Log.d((String)"card.io", (String)("loadLibrary failed for library " + libraryName + ". Trying " + fullPath));
            System.load(fullPath);
        }
    }

    private static boolean usesSupportedProcessorArch() {
        return CardScanner.nUseNeon() || CardScanner.nUseTegra() || CardScanner.nUseX86();
    }

    static boolean processorSupported() {
        return !manualFallbackForError && CardScanner.usesSupportedProcessorArch();
    }

    CardScanner(CardIOActivity scanActivity, int currentFrameOrientation) {
        Intent scanIntent = scanActivity.getIntent();
        if (scanIntent != null) {
            this.mSuppressScan = scanIntent.getBooleanExtra("io.card.payment.suppressScan", false);
            this.mScanExpiry = scanIntent.getBooleanExtra("io.card.payment.requireExpiry", false) && scanIntent.getBooleanExtra("io.card.payment.scanExpiry", true);
            this.mUnblurDigits = scanIntent.getIntExtra("io.card.payment.unblurDigits", -1);
        }
        this.mScanActivityRef = new WeakReference<CardIOActivity>(scanActivity);
        this.mFrameOrientation = currentFrameOrientation;
        this.nSetup(this.mSuppressScan, 6.0f, this.mUnblurDigits);
    }

    private Camera connectToCamera(int checkInterval, int maxTimeout) {
        long start = System.currentTimeMillis();
        if (this.useCamera) {
            do {
                try {
                    return Camera.open();
                }
                catch (RuntimeException e) {
                    try {
                        Log.w((String)"card.io", (String)"Wasn't able to connect to camera service. Waiting and trying again...");
                        Thread.sleep(checkInterval);
                    }
                    catch (InterruptedException e1) {
                        Log.e((String)"card.io", (String)"Interrupted while waiting for camera", (Throwable)e1);
                    }
                }
                catch (Exception e) {
                    Log.e((String)"card.io", (String)"Unexpected exception. Please report it as a GitHub issue", (Throwable)e);
                    maxTimeout = 0;
                }
            } while (System.currentTimeMillis() - start < (long)maxTimeout);
        }
        Log.w((String)TAG, (String)"camera connect timeout");
        return null;
    }

    void prepareScanner() {
        this.mFirstPreviewFrame = true;
        this.mAutoFocusStartedAt = 0L;
        this.mAutoFocusCompletedAt = 0L;
        this.numManualRefocus = 0;
        this.numAutoRefocus = 0;
        this.numManualTorchChange = 0;
        this.numFramesSkipped = 0;
        if (this.useCamera && this.mCamera == null) {
            this.mCamera = this.connectToCamera(50, 5000);
            if (this.mCamera == null) {
                Log.e((String)"card.io", (String)"prepare scanner couldn't connect to camera!");
                return;
            }
            this.setCameraDisplayOrientation(this.mCamera);
            Camera.Parameters parameters = this.mCamera.getParameters();
            List supportedPreviewSizes = parameters.getSupportedPreviewSizes();
            if (supportedPreviewSizes != null) {
                Camera.Size previewSize = null;
                for (Camera.Size s : supportedPreviewSizes) {
                    if (s.width != 640 || s.height != 480) continue;
                    previewSize = s;
                    break;
                }
                if (previewSize == null) {
                    Log.w((String)"card.io", (String)"Didn't find a supported 640x480 resolution, so forcing");
                    previewSize = (Camera.Size)supportedPreviewSizes.get(0);
                    previewSize.width = 640;
                    previewSize.height = 480;
                }
            }
            parameters.setPreviewSize(640, 480);
            this.mCamera.setParameters(parameters);
        } else if (!this.useCamera) {
            Log.w((String)TAG, (String)"useCamera is false!");
        } else if (this.mCamera != null) {
            Log.v((String)TAG, (String)("we already have a camera instance: " + this.mCamera));
        }
        if (this.detectedBitmap == null) {
            this.detectedBitmap = Bitmap.createBitmap((int)428, (int)270, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    boolean resumeScanning(SurfaceHolder holder) {
        if (this.mCamera == null) {
            this.prepareScanner();
        }
        if (this.useCamera && this.mCamera == null) {
            Log.i((String)TAG, (String)"null camera. failure");
            return false;
        }
        assert (holder != null);
        if (this.useCamera && this.mPreviewBuffer == null) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            int previewFormat = parameters.getPreviewFormat();
            int bytesPerPixel = ImageFormat.getBitsPerPixel((int)previewFormat) / 8;
            int bufferSize = 307200 * bytesPerPixel * 3;
            this.mPreviewBuffer = new byte[bufferSize];
            this.mCamera.addCallbackBuffer(this.mPreviewBuffer);
        }
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setType(3);
        if (this.useCamera) {
            this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        if (this.isSurfaceValid) {
            this.makePreviewGo(holder);
        }
        this.setFlashOn(false);
        this.captureStart = System.currentTimeMillis();
        this.nResetAnalytics();
        return true;
    }

    public void pauseScanning() {
        this.setFlashOn(false);
        if (this.mCamera != null) {
            try {
                this.mCamera.stopPreview();
                this.mCamera.setPreviewDisplay(null);
            }
            catch (IOException e) {
                Log.w((String)"card.io", (String)"can't stop preview display", (Throwable)e);
            }
            this.mCamera.setPreviewCallback(null);
            this.mCamera.release();
            this.mPreviewBuffer = null;
            this.mCamera = null;
        }
    }

    public void endScanning() {
        if (this.mCamera != null) {
            this.pauseScanning();
        }
        this.nCleanup();
        this.mPreviewBuffer = null;
    }

    private boolean makePreviewGo(SurfaceHolder holder) {
        assert (holder != null);
        assert (holder.getSurface() != null);
        this.mFirstPreviewFrame = true;
        if (this.useCamera) {
            try {
                this.mCamera.setPreviewDisplay(holder);
            }
            catch (IOException e) {
                Log.e((String)"card.io", (String)"can't set preview display", (Throwable)e);
                return false;
            }
            try {
                this.mCamera.startPreview();
                this.mCamera.autoFocus((Camera.AutoFocusCallback)this);
            }
            catch (RuntimeException e) {
                Log.e((String)"card.io", (String)"startPreview failed on camera. Error: ", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (this.mCamera == null && this.useCamera) {
            Log.wtf((String)"card.io", (String)"CardScanner.surfaceCreated() - camera is null!");
            return;
        }
        this.isSurfaceValid = true;
        this.makePreviewGo(holder);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.d((String)TAG, (String)String.format("Preview.surfaceChanged(holder?:%b, f:%d, w:%d, h:%d )", holder != null, format, width, height));
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mCamera != null) {
            try {
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                Log.e((String)"card.io", (String)"error stopping camera", (Throwable)e);
            }
        }
        this.isSurfaceValid = false;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        boolean sufficientFocus;
        if (data == null) {
            Log.w((String)TAG, (String)"frame is null! skipping");
            return;
        }
        if (processingInProgress) {
            Log.e((String)TAG, (String)"processing in progress.... dropping frame");
            ++this.numFramesSkipped;
            if (camera != null) {
                camera.addCallbackBuffer(data);
            }
            return;
        }
        processingInProgress = true;
        if (this.mFirstPreviewFrame) {
            this.mFirstPreviewFrame = false;
            this.mFrameOrientation = 1;
            ((CardIOActivity)((Object)this.mScanActivityRef.get())).onFirstFrame(1);
        }
        DetectionInfo dInfo = new DetectionInfo();
        this.nScanFrame(data, 640, 480, this.mFrameOrientation, dInfo, this.detectedBitmap, this.mScanExpiry);
        boolean bl = sufficientFocus = dInfo.focusScore >= 6.0f;
        if (!sufficientFocus) {
            this.triggerAutoFocus(false);
        } else if (dInfo.predicted() || this.mSuppressScan && dInfo.detected()) {
            ((CardIOActivity)((Object)this.mScanActivityRef.get())).onCardDetected(this.detectedBitmap, dInfo);
        }
        if (camera != null) {
            camera.addCallbackBuffer(data);
        }
        processingInProgress = false;
    }

    void onEdgeUpdate(DetectionInfo dInfo) {
        ((CardIOActivity)((Object)this.mScanActivityRef.get())).onEdgeUpdate(dInfo);
    }

    Rect getGuideFrame(int orientation, int previewWidth, int previewHeight) {
        Rect r = null;
        if (CardScanner.processorSupported()) {
            r = new Rect();
            this.nGetGuideFrame(orientation, previewWidth, previewHeight, r);
        }
        return r;
    }

    Rect getGuideFrame(int width, int height) {
        return this.getGuideFrame(this.mFrameOrientation, width, height);
    }

    void setDeviceOrientation(int orientation) {
        this.mFrameOrientation = orientation;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        this.mAutoFocusCompletedAt = System.currentTimeMillis();
    }

    boolean isAutoFocusing() {
        return this.mAutoFocusCompletedAt < this.mAutoFocusStartedAt;
    }

    void triggerAutoFocus(boolean isManual) {
        if (this.useCamera && !this.isAutoFocusing()) {
            try {
                this.mAutoFocusStartedAt = System.currentTimeMillis();
                this.mCamera.autoFocus((Camera.AutoFocusCallback)this);
                if (isManual) {
                    ++this.numManualRefocus;
                } else {
                    ++this.numAutoRefocus;
                }
            }
            catch (RuntimeException e) {
                Log.w((String)TAG, (String)("could not trigger auto focus: " + e));
            }
        }
    }

    public boolean isFlashOn() {
        if (!this.useCamera) {
            return false;
        }
        Camera.Parameters params = this.mCamera.getParameters();
        return params.getFlashMode().equals("torch");
    }

    public boolean setFlashOn(boolean b) {
        if (this.mCamera != null) {
            try {
                Camera.Parameters params = this.mCamera.getParameters();
                params.setFlashMode(b ? "torch" : "off");
                this.mCamera.setParameters(params);
                ++this.numManualTorchChange;
                return true;
            }
            catch (RuntimeException e) {
                Log.w((String)TAG, (String)("Could not set flash mode: " + e));
            }
        }
        return false;
    }

    private void setCameraDisplayOrientation(Camera mCamera) {
        int result;
        if (Build.VERSION.SDK_INT >= 21) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
            int degrees = this.getRotationalOffset();
            int cameraOrientation = info.orientation;
            result = (cameraOrientation - degrees + 360) % 360;
        } else {
            result = 90;
        }
        mCamera.setDisplayOrientation(result);
    }

    int getRotationalOffset() {
        int naturalOrientation = ((WindowManager)((CardIOActivity)((Object)this.mScanActivityRef.get())).getSystemService("window")).getDefaultDisplay().getRotation();
        int rotationOffset = naturalOrientation == 0 ? 0 : (naturalOrientation == 1 ? 90 : (naturalOrientation == 2 ? 180 : (naturalOrientation == 3 ? 270 : 0)));
        return rotationOffset;
    }

    static {
        Log.i((String)"card.io", (String)"card.io 5.5.1 03/17/2017 14:23:12 -0400");
        try {
            CardScanner.loadLibrary("cardioDecider");
            Log.d((String)"card.io", (String)"Loaded card.io decider library.");
            Log.d((String)"card.io", (String)("    nUseNeon(): " + CardScanner.nUseNeon()));
            Log.d((String)"card.io", (String)("    nUseTegra():" + CardScanner.nUseTegra()));
            Log.d((String)"card.io", (String)("    nUseX86():  " + CardScanner.nUseX86()));
            if (CardScanner.usesSupportedProcessorArch()) {
                CardScanner.loadLibrary("opencv_core");
                Log.d((String)"card.io", (String)"Loaded opencv core library");
                CardScanner.loadLibrary("opencv_imgproc");
                Log.d((String)"card.io", (String)"Loaded opencv imgproc library");
            }
            if (CardScanner.nUseNeon()) {
                CardScanner.loadLibrary("cardioRecognizer");
                Log.i((String)"card.io", (String)"Loaded card.io NEON library");
            } else if (CardScanner.nUseX86()) {
                CardScanner.loadLibrary("cardioRecognizer");
                Log.i((String)"card.io", (String)"Loaded card.io x86 library");
            } else if (CardScanner.nUseTegra()) {
                CardScanner.loadLibrary("cardioRecognizer_tegra2");
                Log.i((String)"card.io", (String)"Loaded card.io Tegra2 library");
            } else {
                Log.w((String)"card.io", (String)"unsupported processor - card.io scanning requires ARMv7 or x86 architecture");
                manualFallbackForError = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            String error = "Failed to load native library: " + e.getMessage();
            Log.e((String)"card.io", (String)error);
            manualFallbackForError = true;
        }
        processingInProgress = false;
    }
}

