/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Pair;
import io.card.payment.R;
import io.card.payment.i18n.LocalizedStrings;
import io.card.payment.i18n.StringKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public enum CardType {
    AMEX("AmEx"),
    DINERSCLUB("DinersClub"),
    DISCOVER("Discover"),
    JCB("JCB"),
    MASTERCARD("MasterCard"),
    VISA("Visa"),
    MAESTRO("Maestro"),
    UNKNOWN("Unknown"),
    INSUFFICIENT_DIGITS("More digits required");

    public final String name;
    private static int minDigits;
    private static HashMap<Pair<String, String>, CardType> intervalLookup;

    private CardType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getDisplayName(String languageOrLocale) {
        switch (this) {
            case AMEX: {
                return LocalizedStrings.getString(StringKey.CARDTYPE_AMERICANEXPRESS, languageOrLocale);
            }
            case DINERSCLUB: 
            case DISCOVER: {
                return LocalizedStrings.getString(StringKey.CARDTYPE_DISCOVER, languageOrLocale);
            }
            case JCB: {
                return LocalizedStrings.getString(StringKey.CARDTYPE_JCB, languageOrLocale);
            }
            case MASTERCARD: {
                return LocalizedStrings.getString(StringKey.CARDTYPE_MASTERCARD, languageOrLocale);
            }
            case MAESTRO: {
                return LocalizedStrings.getString(StringKey.CARDTYPE_MAESTRO, languageOrLocale);
            }
            case VISA: {
                return LocalizedStrings.getString(StringKey.CARDTYPE_VISA, languageOrLocale);
            }
        }
        return null;
    }

    public int numberLength() {
        int result;
        switch (this) {
            case AMEX: {
                result = 15;
                break;
            }
            case DISCOVER: 
            case JCB: 
            case MASTERCARD: 
            case MAESTRO: 
            case VISA: {
                result = 16;
                break;
            }
            case DINERSCLUB: {
                result = 14;
                break;
            }
            case INSUFFICIENT_DIGITS: {
                result = minDigits;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    public int cvvLength() {
        int result;
        switch (this) {
            case AMEX: {
                result = 4;
                break;
            }
            case DINERSCLUB: 
            case DISCOVER: 
            case JCB: 
            case MASTERCARD: 
            case MAESTRO: 
            case VISA: {
                result = 3;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    public Bitmap imageBitmap(Context context) {
        int cardImageResource = -1;
        switch (this) {
            case AMEX: {
                cardImageResource = R.drawable.cio_ic_amex;
                break;
            }
            case VISA: {
                cardImageResource = R.drawable.cio_ic_visa;
                break;
            }
            case MASTERCARD: {
                cardImageResource = R.drawable.cio_ic_mastercard;
                break;
            }
            case DINERSCLUB: 
            case DISCOVER: {
                cardImageResource = R.drawable.cio_ic_discover;
                break;
            }
            case JCB: {
                cardImageResource = R.drawable.cio_ic_jcb;
                break;
            }
        }
        if (cardImageResource != -1) {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)cardImageResource);
        }
        return null;
    }

    private static boolean isNumberInInterval(String number, String intervalStart, String intervalEnd) {
        int numCompareStart = Math.min(number.length(), intervalStart.length());
        int numCompareEnd = Math.min(number.length(), intervalEnd.length());
        if (Integer.parseInt(number.substring(0, numCompareStart)) < Integer.parseInt(intervalStart.substring(0, numCompareStart))) {
            return false;
        }
        return Integer.parseInt(number.substring(0, numCompareEnd)) <= Integer.parseInt(intervalEnd.substring(0, numCompareEnd));
    }

    private static HashMap<Pair<String, String>, CardType> getIntervalLookup() {
        return intervalLookup;
    }

    private static Pair<String, String> getNewPair(String intervalStart, String intervalEnd) {
        if (intervalEnd == null) {
            intervalEnd = intervalStart;
        }
        return new Pair((Object)intervalStart, (Object)intervalEnd);
    }

    public static CardType fromString(String typeStr) {
        if (typeStr == null) {
            return UNKNOWN;
        }
        for (CardType type : CardType.values()) {
            if (type == UNKNOWN || type == INSUFFICIENT_DIGITS || !typeStr.equalsIgnoreCase(type.toString())) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static CardType fromCardNumber(String numStr) {
        if (TextUtils.isEmpty((CharSequence)numStr)) {
            return UNKNOWN;
        }
        HashSet<CardType> possibleCardTypes = new HashSet<CardType>();
        for (Map.Entry<Pair<String, String>, CardType> entry : CardType.getIntervalLookup().entrySet()) {
            boolean isPossibleCard = CardType.isNumberInInterval(numStr, (String)entry.getKey().first, (String)entry.getKey().second);
            if (!isPossibleCard) continue;
            possibleCardTypes.add(entry.getValue());
        }
        if (possibleCardTypes.size() > 1) {
            return INSUFFICIENT_DIGITS;
        }
        if (possibleCardTypes.size() == 1) {
            return (CardType)((Object)possibleCardTypes.iterator().next());
        }
        return UNKNOWN;
    }

    static {
        minDigits = 1;
        intervalLookup = new HashMap();
        intervalLookup.put(CardType.getNewPair("2221", "2720"), MASTERCARD);
        intervalLookup.put(CardType.getNewPair("300", "305"), DINERSCLUB);
        intervalLookup.put(CardType.getNewPair("309", null), DINERSCLUB);
        intervalLookup.put(CardType.getNewPair("34", null), AMEX);
        intervalLookup.put(CardType.getNewPair("3528", "3589"), JCB);
        intervalLookup.put(CardType.getNewPair("36", null), DINERSCLUB);
        intervalLookup.put(CardType.getNewPair("37", null), AMEX);
        intervalLookup.put(CardType.getNewPair("38", "39"), DINERSCLUB);
        intervalLookup.put(CardType.getNewPair("4", null), VISA);
        intervalLookup.put(CardType.getNewPair("50", null), MAESTRO);
        intervalLookup.put(CardType.getNewPair("51", "55"), MASTERCARD);
        intervalLookup.put(CardType.getNewPair("56", "59"), MAESTRO);
        intervalLookup.put(CardType.getNewPair("6011", null), DISCOVER);
        intervalLookup.put(CardType.getNewPair("61", null), MAESTRO);
        intervalLookup.put(CardType.getNewPair("62", null), DISCOVER);
        intervalLookup.put(CardType.getNewPair("63", null), MAESTRO);
        intervalLookup.put(CardType.getNewPair("644", "649"), DISCOVER);
        intervalLookup.put(CardType.getNewPair("65", null), DISCOVER);
        intervalLookup.put(CardType.getNewPair("66", "69"), MAESTRO);
        intervalLookup.put(CardType.getNewPair("88", null), DISCOVER);
        for (Map.Entry<Pair<String, String>, CardType> entry : CardType.getIntervalLookup().entrySet()) {
            minDigits = Math.max(minDigits, ((String)entry.getKey().first).length());
            if (entry.getKey().second == null) continue;
            minDigits = Math.max(minDigits, ((String)entry.getKey().second).length());
        }
    }
}

