/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import io.card.payment.CardType;
import io.card.payment.StringHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Date;

class CreditCardNumber {
    public static boolean passesLuhnChecksum(String number) {
        int even = 0;
        int sum = 0;
        int[][] sums = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {0, 2, 4, 6, 8, 1, 3, 5, 7, 9}};
        StringCharacterIterator iter = new StringCharacterIterator(number);
        char c = iter.last();
        while (c != '\uffff') {
            if (!Character.isDigit(c)) {
                return false;
            }
            int cInt = c - 48;
            sum += sums[even++ & 1][cInt];
            c = iter.previous();
        }
        return sum % 10 == 0;
    }

    public static String formatString(String numStr) {
        return CreditCardNumber.formatString(numStr, true, null);
    }

    public static String formatString(String numStr, boolean filterDigits, CardType type) {
        String digits = filterDigits ? StringHelper.getDigitsOnlyString(numStr) : numStr;
        if (type == null) {
            type = CardType.fromCardNumber(digits);
        }
        int numLen = type.numberLength();
        if (digits.length() == numLen) {
            if (numLen == 16) {
                return CreditCardNumber.formatSixteenString(digits);
            }
            if (numLen == 15) {
                return CreditCardNumber.formatFifteenString(digits);
            }
        }
        return numStr;
    }

    private static String formatFifteenString(String digits) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            if (i == 4 || i == 10) {
                sb.append(' ');
            }
            sb.append(digits.charAt(i));
        }
        return sb.toString();
    }

    private static String formatSixteenString(String digits) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (i != 0 && i % 4 == 0) {
                sb.append(' ');
            }
            sb.append(digits.charAt(i));
        }
        return sb.toString();
    }

    public static boolean isDateValid(int expiryMonth, int expiryYear) {
        if (expiryMonth < 1 || 12 < expiryMonth) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        int thisYear = now.get(1);
        int thisMonth = now.get(2) + 1;
        if (expiryYear < thisYear) {
            return false;
        }
        if (expiryYear == thisYear && expiryMonth < thisMonth) {
            return false;
        }
        return expiryYear <= thisYear + 15;
    }

    public static SimpleDateFormat getDateFormatForLength(int len) {
        if (len == 4) {
            return new SimpleDateFormat("MMyy");
        }
        if (len == 6) {
            return new SimpleDateFormat("MMyyyy");
        }
        return null;
    }

    public static Date getDateForString(String dateString) {
        String digitsOnly = StringHelper.getDigitsOnlyString(dateString);
        SimpleDateFormat validDate = CreditCardNumber.getDateFormatForLength(digitsOnly.length());
        if (validDate != null) {
            try {
                validDate.setLenient(false);
                Date date = validDate.parse(digitsOnly);
                return date;
            }
            catch (ParseException pe) {
                return null;
            }
        }
        return null;
    }
}

