/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.DateKeyListener;
import android.text.method.DigitsKeyListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import io.card.payment.AlwaysValid;
import io.card.payment.CardIOActivity;
import io.card.payment.CardNumberValidator;
import io.card.payment.CardType;
import io.card.payment.CreditCard;
import io.card.payment.ExpiryValidator;
import io.card.payment.FixedLengthValidator;
import io.card.payment.MaxLengthValidator;
import io.card.payment.R;
import io.card.payment.Validator;
import io.card.payment.i18n.LocalizedStrings;
import io.card.payment.i18n.StringKey;
import io.card.payment.ui.ActivityHelper;
import io.card.payment.ui.Appearance;
import io.card.payment.ui.ViewUtil;

public final class DataEntryActivity
extends Activity
implements TextWatcher {
    private int viewIdCounter = 1;
    private int editTextIdCounter = 100;
    private TextView activityTitleTextView;
    private EditText numberEdit;
    private Validator numberValidator;
    private EditText expiryEdit;
    private Validator expiryValidator;
    private EditText cvvEdit;
    private Validator cvvValidator;
    private EditText postalCodeEdit;
    private Validator postalCodeValidator;
    private EditText cardholderNameEdit;
    private Validator cardholderNameValidator;
    private ImageView cardView;
    private Button doneBtn;
    private Button cancelBtn;
    private CreditCard capture;
    private boolean autoAcceptDone;
    private String labelLeftPadding;
    private boolean useApplicationTheme;
    private int defaultTextColor;
    private static final String TAG = DataEntryActivity.class.getSimpleName();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (null == this.getIntent().getExtras()) {
            this.onBackPressed();
            return;
        }
        this.useApplicationTheme = this.getIntent().getBooleanExtra("io.card.payment.keepApplicationTheme", false);
        ActivityHelper.setActivityTheme(this, this.useApplicationTheme);
        this.defaultTextColor = new TextView((Context)this).getTextColors().getDefaultColor();
        this.labelLeftPadding = ActivityHelper.holoSupported() ? "12dip" : "2dip";
        LocalizedStrings.setLanguage(this.getIntent());
        int paddingPx = ViewUtil.typedDimensionValueToPixelsInt("4dip", (Context)this);
        RelativeLayout container = new RelativeLayout((Context)this);
        if (!this.useApplicationTheme) {
            container.setBackgroundColor(Appearance.DEFAULT_BACKGROUND_COLOR);
        }
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setId(this.viewIdCounter++);
        RelativeLayout.LayoutParams scrollParams = new RelativeLayout.LayoutParams(-1, -2);
        scrollParams.addRule(10);
        container.addView((View)scrollView, (ViewGroup.LayoutParams)scrollParams);
        LinearLayout wrapperLayout = new LinearLayout((Context)this);
        wrapperLayout.setOrientation(1);
        scrollView.addView((View)wrapperLayout, -1, -1);
        LinearLayout mainLayout = new LinearLayout((Context)this);
        mainLayout.setOrientation(1);
        LinearLayout.LayoutParams mainParams = new LinearLayout.LayoutParams(-1, -1);
        this.capture = (CreditCard)this.getIntent().getParcelableExtra("io.card.payment.scanResult");
        this.autoAcceptDone = this.getIntent().getBooleanExtra("debug_autoAcceptResult", false);
        if (this.capture != null) {
            this.numberValidator = new CardNumberValidator(this.capture.cardNumber);
            this.cardView = new ImageView((Context)this);
            LinearLayout.LayoutParams cardParams = new LinearLayout.LayoutParams(-1, -2);
            this.cardView.setPadding(0, 0, 0, paddingPx);
            cardParams.weight = 1.0f;
            this.cardView.setImageBitmap(CardIOActivity.markedCardImage);
            mainLayout.addView((View)this.cardView, (ViewGroup.LayoutParams)cardParams);
            ViewUtil.setMargins((View)this.cardView, null, null, null, "8dip");
        } else {
            this.activityTitleTextView = new TextView((Context)this);
            this.activityTitleTextView.setTextSize(24.0f);
            if (!this.useApplicationTheme) {
                this.activityTitleTextView.setTextColor(Appearance.PAY_BLUE_COLOR);
            }
            mainLayout.addView((View)this.activityTitleTextView);
            ViewUtil.setPadding((View)this.activityTitleTextView, null, null, null, "8dip");
            ViewUtil.setDimensions((View)this.activityTitleTextView, -2, -2);
            LinearLayout numberLayout = new LinearLayout((Context)this);
            numberLayout.setOrientation(1);
            ViewUtil.setPadding((View)numberLayout, null, "4dip", null, "4dip");
            TextView numberLabel = new TextView((Context)this);
            ViewUtil.setPadding((View)numberLabel, this.labelLeftPadding, null, null, null);
            numberLabel.setText((CharSequence)LocalizedStrings.getString(StringKey.ENTRY_CARD_NUMBER));
            if (!this.useApplicationTheme) {
                numberLabel.setTextColor(Appearance.TEXT_COLOR_LABEL);
            }
            numberLayout.addView((View)numberLabel, -2, -2);
            this.numberEdit = new EditText((Context)this);
            this.numberEdit.setId(this.editTextIdCounter++);
            this.numberEdit.setMaxLines(1);
            this.numberEdit.setImeOptions(6);
            this.numberEdit.setTextAppearance(this.getApplicationContext(), 0x1010040);
            this.numberEdit.setInputType(3);
            this.numberEdit.setHint((CharSequence)"1234 5678 1234 5678");
            if (!this.useApplicationTheme) {
                this.numberEdit.setHintTextColor(-3355444);
            }
            this.numberValidator = new CardNumberValidator();
            this.numberEdit.addTextChangedListener((TextWatcher)this.numberValidator);
            this.numberEdit.addTextChangedListener((TextWatcher)this);
            this.numberEdit.setFilters(new InputFilter[]{new DigitsKeyListener(), this.numberValidator});
            numberLayout.addView((View)this.numberEdit, -1, -2);
            mainLayout.addView((View)numberLayout, -1, -1);
        }
        LinearLayout optionLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams optionLayoutParam = new LinearLayout.LayoutParams(-1, -2);
        ViewUtil.setPadding((View)optionLayout, null, "4dip", null, "4dip");
        optionLayout.setOrientation(0);
        boolean requireExpiry = this.getIntent().getBooleanExtra("io.card.payment.requireExpiry", false);
        boolean requireCVV = this.getIntent().getBooleanExtra("io.card.payment.requireCVV", false);
        boolean requirePostalCode = this.getIntent().getBooleanExtra("io.card.payment.requirePostalCode", false);
        if (requireExpiry) {
            LinearLayout expiryLayout = new LinearLayout((Context)this);
            LinearLayout.LayoutParams expiryLayoutParam = new LinearLayout.LayoutParams(0, -1, 1.0f);
            expiryLayout.setOrientation(1);
            TextView expiryLabel = new TextView((Context)this);
            if (!this.useApplicationTheme) {
                expiryLabel.setTextColor(Appearance.TEXT_COLOR_LABEL);
            }
            expiryLabel.setText((CharSequence)LocalizedStrings.getString(StringKey.ENTRY_EXPIRES));
            ViewUtil.setPadding((View)expiryLabel, this.labelLeftPadding, null, null, null);
            expiryLayout.addView((View)expiryLabel, -2, -2);
            this.expiryEdit = new EditText((Context)this);
            this.expiryEdit.setId(this.editTextIdCounter++);
            this.expiryEdit.setMaxLines(1);
            this.expiryEdit.setImeOptions(6);
            this.expiryEdit.setTextAppearance(this.getApplicationContext(), 0x1010040);
            this.expiryEdit.setInputType(3);
            this.expiryEdit.setHint((CharSequence)LocalizedStrings.getString(StringKey.EXPIRES_PLACEHOLDER));
            if (!this.useApplicationTheme) {
                this.expiryEdit.setHintTextColor(-3355444);
            }
            this.expiryValidator = this.capture != null ? new ExpiryValidator(this.capture.expiryMonth, this.capture.expiryYear) : new ExpiryValidator();
            if (this.expiryValidator.hasFullLength()) {
                this.expiryEdit.setText((CharSequence)this.expiryValidator.getValue());
            }
            this.expiryEdit.addTextChangedListener((TextWatcher)this.expiryValidator);
            this.expiryEdit.addTextChangedListener((TextWatcher)this);
            this.expiryEdit.setFilters(new InputFilter[]{new DateKeyListener(), this.expiryValidator});
            expiryLayout.addView((View)this.expiryEdit, -1, -2);
            optionLayout.addView((View)expiryLayout, (ViewGroup.LayoutParams)expiryLayoutParam);
            ViewUtil.setMargins((View)expiryLayout, null, null, requireCVV || requirePostalCode ? "4dip" : null, null);
        } else {
            this.expiryValidator = new AlwaysValid();
        }
        if (requireCVV) {
            LinearLayout cvvLayout = new LinearLayout((Context)this);
            LinearLayout.LayoutParams cvvLayoutParam = new LinearLayout.LayoutParams(0, -1, 1.0f);
            cvvLayout.setOrientation(1);
            TextView cvvLabel = new TextView((Context)this);
            if (!this.useApplicationTheme) {
                cvvLabel.setTextColor(Appearance.TEXT_COLOR_LABEL);
            }
            ViewUtil.setPadding((View)cvvLabel, this.labelLeftPadding, null, null, null);
            cvvLabel.setText((CharSequence)LocalizedStrings.getString(StringKey.ENTRY_CVV));
            cvvLayout.addView((View)cvvLabel, -2, -2);
            this.cvvEdit = new EditText((Context)this);
            this.cvvEdit.setId(this.editTextIdCounter++);
            this.cvvEdit.setMaxLines(1);
            this.cvvEdit.setImeOptions(6);
            this.cvvEdit.setTextAppearance(this.getApplicationContext(), 0x1010040);
            this.cvvEdit.setInputType(3);
            this.cvvEdit.setHint((CharSequence)"123");
            if (!this.useApplicationTheme) {
                this.cvvEdit.setHintTextColor(-3355444);
            }
            int length = 4;
            if (this.capture != null) {
                CardType type = CardType.fromCardNumber(this.numberValidator.getValue());
                length = type.cvvLength();
            }
            this.cvvValidator = new FixedLengthValidator(length);
            this.cvvEdit.setFilters(new InputFilter[]{new DigitsKeyListener(), this.cvvValidator});
            this.cvvEdit.addTextChangedListener((TextWatcher)this.cvvValidator);
            this.cvvEdit.addTextChangedListener((TextWatcher)this);
            cvvLayout.addView((View)this.cvvEdit, -1, -2);
            optionLayout.addView((View)cvvLayout, (ViewGroup.LayoutParams)cvvLayoutParam);
            ViewUtil.setMargins((View)cvvLayout, requireExpiry ? "4dip" : null, null, requirePostalCode ? "4dip" : null, null);
        } else {
            this.cvvValidator = new AlwaysValid();
        }
        if (requirePostalCode) {
            LinearLayout postalCodeLayout = new LinearLayout((Context)this);
            LinearLayout.LayoutParams postalCodeLayoutParam = new LinearLayout.LayoutParams(0, -1, 1.0f);
            postalCodeLayout.setOrientation(1);
            TextView zipLabel = new TextView((Context)this);
            if (!this.useApplicationTheme) {
                zipLabel.setTextColor(Appearance.TEXT_COLOR_LABEL);
            }
            ViewUtil.setPadding((View)zipLabel, this.labelLeftPadding, null, null, null);
            zipLabel.setText((CharSequence)LocalizedStrings.getString(StringKey.ENTRY_POSTAL_CODE));
            postalCodeLayout.addView((View)zipLabel, -2, -2);
            boolean postalCodeNumericOnly = this.getIntent().getBooleanExtra("io.card.payment.restrictPostalCodeToNumericOnly", false);
            this.postalCodeEdit = new EditText((Context)this);
            this.postalCodeEdit.setId(this.editTextIdCounter++);
            this.postalCodeEdit.setMaxLines(1);
            this.postalCodeEdit.setImeOptions(6);
            this.postalCodeEdit.setTextAppearance(this.getApplicationContext(), 0x1010040);
            if (postalCodeNumericOnly) {
                this.postalCodeEdit.setInputType(3);
            } else {
                this.postalCodeEdit.setInputType(1);
            }
            if (!this.useApplicationTheme) {
                this.postalCodeEdit.setHintTextColor(-3355444);
            }
            this.postalCodeValidator = new MaxLengthValidator(20);
            this.postalCodeEdit.addTextChangedListener((TextWatcher)this.postalCodeValidator);
            this.postalCodeEdit.addTextChangedListener((TextWatcher)this);
            postalCodeLayout.addView((View)this.postalCodeEdit, -1, -2);
            optionLayout.addView((View)postalCodeLayout, (ViewGroup.LayoutParams)postalCodeLayoutParam);
            ViewUtil.setMargins((View)postalCodeLayout, requireExpiry || requireCVV ? "4dip" : null, null, null, null);
        } else {
            this.postalCodeValidator = new AlwaysValid();
        }
        mainLayout.addView((View)optionLayout, (ViewGroup.LayoutParams)optionLayoutParam);
        this.addCardholderNameIfNeeded((ViewGroup)mainLayout);
        wrapperLayout.addView((View)mainLayout, (ViewGroup.LayoutParams)mainParams);
        ViewUtil.setMargins((View)mainLayout, "16dip", "20dip", "16dip", "20dip");
        LinearLayout buttonLayout = new LinearLayout((Context)this);
        buttonLayout.setId(this.viewIdCounter++);
        RelativeLayout.LayoutParams buttonLayoutParam = new RelativeLayout.LayoutParams(-1, -2);
        buttonLayoutParam.addRule(12);
        buttonLayout.setPadding(0, paddingPx, 0, 0);
        buttonLayout.setBackgroundColor(0);
        scrollParams.addRule(2, buttonLayout.getId());
        this.doneBtn = new Button((Context)this);
        LinearLayout.LayoutParams doneParam = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        this.doneBtn.setText((CharSequence)LocalizedStrings.getString(StringKey.DONE));
        this.doneBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DataEntryActivity.this.completed();
            }
        });
        this.doneBtn.setEnabled(false);
        buttonLayout.addView((View)this.doneBtn, (ViewGroup.LayoutParams)doneParam);
        ViewUtil.styleAsButton(this.doneBtn, true, (Context)this, this.useApplicationTheme);
        ViewUtil.setPadding((View)this.doneBtn, "5dip", null, "5dip", null);
        ViewUtil.setMargins((View)this.doneBtn, "8dip", "8dip", "8dip", "8dip");
        if (!this.useApplicationTheme) {
            this.doneBtn.setTextSize(16.0f);
        }
        this.cancelBtn = new Button((Context)this);
        LinearLayout.LayoutParams cancelParam = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        this.cancelBtn.setText((CharSequence)LocalizedStrings.getString(StringKey.CANCEL));
        this.cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DataEntryActivity.this.onBackPressed();
            }
        });
        buttonLayout.addView((View)this.cancelBtn, (ViewGroup.LayoutParams)cancelParam);
        ViewUtil.styleAsButton(this.cancelBtn, false, (Context)this, this.useApplicationTheme);
        ViewUtil.setPadding((View)this.cancelBtn, "5dip", null, "5dip", null);
        ViewUtil.setMargins((View)this.cancelBtn, "4dip", "8dip", "8dip", "8dip");
        if (!this.useApplicationTheme) {
            this.cancelBtn.setTextSize(16.0f);
        }
        container.addView((View)buttonLayout, (ViewGroup.LayoutParams)buttonLayoutParam);
        ActivityHelper.addActionBarIfSupported(this);
        this.setContentView((View)container);
        Drawable icon = null;
        boolean usePayPalActionBarIcon = this.getIntent().getBooleanExtra("io.card.payment.intentSenderIsPayPal", true);
        if (usePayPalActionBarIcon) {
            icon = this.getResources().getDrawable(R.drawable.cio_ic_paypal_monogram);
        }
        if (requireExpiry && this.expiryValidator.isValid()) {
            this.afterTextChanged(this.expiryEdit.getEditableText());
        }
        ActivityHelper.setupActionBarIfSupported(this, this.activityTitleTextView, LocalizedStrings.getString(StringKey.MANUAL_ENTRY_TITLE), "card.io - ", icon);
    }

    private void completed() {
        if (this.capture == null) {
            this.capture = new CreditCard();
        }
        if (this.expiryEdit != null) {
            this.capture.expiryMonth = ((ExpiryValidator)this.expiryValidator).month;
            this.capture.expiryYear = ((ExpiryValidator)this.expiryValidator).year;
        }
        CreditCard result = new CreditCard(this.numberValidator.getValue(), this.capture.expiryMonth, this.capture.expiryYear, this.cvvValidator.getValue(), this.postalCodeValidator.getValue(), this.cardholderNameValidator.getValue());
        Intent dataIntent = new Intent();
        dataIntent.putExtra("io.card.payment.scanResult", (Parcelable)result);
        if (this.getIntent().hasExtra("io.card.payment.capturedCardImage")) {
            dataIntent.putExtra("io.card.payment.capturedCardImage", this.getIntent().getByteArrayExtra("io.card.payment.capturedCardImage"));
        }
        this.setResult(CardIOActivity.RESULT_CARD_INFO, dataIntent);
        this.finish();
    }

    public void onBackPressed() {
        this.setResult(CardIOActivity.RESULT_ENTRY_CANCELED);
        this.finish();
    }

    protected void onResume() {
        super.onResume();
        this.getWindow().setFlags(0, 1024);
        ActivityHelper.setFlagSecure(this);
        this.validateAndEnableDoneButtonIfValid();
        if (this.numberEdit == null && this.expiryEdit != null && !this.expiryValidator.isValid()) {
            this.expiryEdit.requestFocus();
        } else {
            this.advanceToNextEmptyField();
        }
        if (this.numberEdit != null || this.expiryEdit != null || this.cvvEdit != null || this.postalCodeEdit != null || this.cardholderNameEdit != null) {
            this.getWindow().setSoftInputMode(5);
        }
    }

    private EditText advanceToNextEmptyField() {
        EditText et;
        int viewId = 100;
        while ((et = (EditText)this.findViewById(viewId++)) != null) {
            if (et.getText().length() != 0 || !et.requestFocus()) continue;
            return et;
        }
        return null;
    }

    private void validateAndEnableDoneButtonIfValid() {
        this.doneBtn.setEnabled(this.numberValidator.isValid() && this.expiryValidator.isValid() && this.cvvValidator.isValid() && this.postalCodeValidator.isValid() && this.cardholderNameValidator.isValid());
        if (this.autoAcceptDone && this.numberValidator.isValid() && this.expiryValidator.isValid() && this.cvvValidator.isValid() && this.postalCodeValidator.isValid() && this.cardholderNameValidator.isValid()) {
            this.completed();
        }
    }

    public void afterTextChanged(Editable et) {
        if (this.numberEdit != null && et == this.numberEdit.getText()) {
            if (this.numberValidator.hasFullLength()) {
                if (!this.numberValidator.isValid()) {
                    this.numberEdit.setTextColor(Appearance.TEXT_COLOR_ERROR);
                } else {
                    this.setDefaultColor(this.numberEdit);
                    this.advanceToNextEmptyField();
                }
            } else {
                this.setDefaultColor(this.numberEdit);
            }
            if (this.cvvEdit != null) {
                int length;
                CardType type = CardType.fromCardNumber(this.numberValidator.getValue().toString());
                FixedLengthValidator v = (FixedLengthValidator)this.cvvValidator;
                v.requiredLength = length = type.cvvLength();
                this.cvvEdit.setHint((CharSequence)(length == 4 ? "1234" : "123"));
            }
        } else if (this.expiryEdit != null && et == this.expiryEdit.getText()) {
            if (this.expiryValidator.hasFullLength()) {
                if (!this.expiryValidator.isValid()) {
                    this.expiryEdit.setTextColor(Appearance.TEXT_COLOR_ERROR);
                } else {
                    this.setDefaultColor(this.expiryEdit);
                    this.advanceToNextEmptyField();
                }
            } else {
                this.setDefaultColor(this.expiryEdit);
            }
        } else if (this.cvvEdit != null && et == this.cvvEdit.getText()) {
            if (this.cvvValidator.hasFullLength()) {
                if (!this.cvvValidator.isValid()) {
                    this.cvvEdit.setTextColor(Appearance.TEXT_COLOR_ERROR);
                } else {
                    this.setDefaultColor(this.cvvEdit);
                    this.advanceToNextEmptyField();
                }
            } else {
                this.setDefaultColor(this.cvvEdit);
            }
        } else if (this.postalCodeEdit != null && et == this.postalCodeEdit.getText()) {
            if (this.postalCodeValidator.hasFullLength()) {
                if (!this.postalCodeValidator.isValid()) {
                    this.postalCodeEdit.setTextColor(Appearance.TEXT_COLOR_ERROR);
                } else {
                    this.setDefaultColor(this.postalCodeEdit);
                }
            } else {
                this.setDefaultColor(this.postalCodeEdit);
            }
        } else if (this.cardholderNameEdit != null && et == this.cardholderNameEdit.getText()) {
            if (this.cardholderNameValidator.hasFullLength()) {
                if (!this.cardholderNameValidator.isValid()) {
                    this.cardholderNameEdit.setTextColor(Appearance.TEXT_COLOR_ERROR);
                } else {
                    this.setDefaultColor(this.cardholderNameEdit);
                }
            } else {
                this.setDefaultColor(this.cardholderNameEdit);
            }
        }
        this.validateAndEnableDoneButtonIfValid();
    }

    private void setDefaultColor(EditText editText) {
        if (this.useApplicationTheme) {
            editText.setTextColor(this.defaultTextColor);
        } else {
            editText.setTextColor(-12303292);
        }
    }

    public void beforeTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
    }

    public void onTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
    }

    private void addCardholderNameIfNeeded(ViewGroup mainLayout) {
        boolean requireCardholderName = this.getIntent().getBooleanExtra("io.card.payment.requireCardholderName", false);
        if (requireCardholderName) {
            LinearLayout cardholderNameLayout = new LinearLayout((Context)this);
            ViewUtil.setPadding((View)cardholderNameLayout, null, "4dip", null, null);
            cardholderNameLayout.setOrientation(1);
            TextView cardholderNameLabel = new TextView((Context)this);
            if (!this.useApplicationTheme) {
                cardholderNameLabel.setTextColor(Appearance.TEXT_COLOR_LABEL);
            }
            ViewUtil.setPadding((View)cardholderNameLabel, this.labelLeftPadding, null, null, null);
            cardholderNameLabel.setText((CharSequence)LocalizedStrings.getString(StringKey.ENTRY_CARDHOLDER_NAME));
            cardholderNameLayout.addView((View)cardholderNameLabel, -2, -2);
            this.cardholderNameEdit = new EditText((Context)this);
            this.cardholderNameEdit.setId(this.editTextIdCounter++);
            this.cardholderNameEdit.setMaxLines(1);
            this.cardholderNameEdit.setImeOptions(6);
            this.cardholderNameEdit.setTextAppearance(this.getApplicationContext(), 0x1010040);
            this.cardholderNameEdit.setInputType(1);
            if (!this.useApplicationTheme) {
                this.cardholderNameEdit.setHintTextColor(-3355444);
            }
            this.cardholderNameValidator = new MaxLengthValidator(175);
            this.cardholderNameEdit.addTextChangedListener((TextWatcher)this.cardholderNameValidator);
            this.cardholderNameEdit.addTextChangedListener((TextWatcher)this);
            cardholderNameLayout.addView((View)this.cardholderNameEdit, -1, -2);
            mainLayout.addView((View)cardholderNameLayout, -1, -2);
        } else {
            this.cardholderNameValidator = new AlwaysValid();
        }
    }
}

