/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import io.card.payment.CreditCardNumber;
import io.card.payment.Validator;
import java.util.Date;

class ExpiryValidator
implements Validator {
    private static final String TAG = ExpiryValidator.class.getSimpleName();
    public int month;
    public int year;
    private boolean fullLength;

    public ExpiryValidator() {
    }

    public ExpiryValidator(int m, int y) {
        this.month = m;
        this.year = y;
        boolean bl = this.fullLength = this.month > 0 && this.year > 0;
        if (this.year < 2000) {
            this.year += 2000;
        }
    }

    public void afterTextChanged(Editable s) {
        this.fullLength = s.length() >= 5;
        String dateStr = s.toString();
        if (dateStr == null) {
            return;
        }
        Date expiry = CreditCardNumber.getDateForString(dateStr);
        if (expiry == null) {
            return;
        }
        this.month = expiry.getMonth() + 1;
        this.year = expiry.getYear();
        if (this.year < 1900) {
            this.year += 1900;
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.month = 0;
        this.year = 0;
        this.fullLength = false;
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    @Override
    public String getValue() {
        return String.format("%02d/%02d", this.month, this.year % 100);
    }

    @Override
    public boolean hasFullLength() {
        return this.fullLength;
    }

    @Override
    public boolean isValid() {
        if (this.month < 1 || 12 < this.month) {
            return false;
        }
        Date now = new Date();
        if (this.year > 1900 + now.getYear() + 15) {
            return false;
        }
        return this.year > 1900 + now.getYear() || this.year == 1900 + now.getYear() && this.month >= now.getMonth() + 1;
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        String updated;
        int loc;
        int replen;
        SpannableStringBuilder result = new SpannableStringBuilder(source);
        if (dstart == 0 && result.length() > 0 && '1' < result.charAt(0) && result.charAt(0) <= '9') {
            result.insert(0, (CharSequence)"0");
            ++end;
        }
        if (dstart - (replen = dend - dstart) <= 2 && dstart + end - replen >= 2 && ((loc = 2 - dstart) == end || 0 <= loc && loc < end && result.charAt(loc) != '/')) {
            result.insert(loc, (CharSequence)"/");
            ++end;
        }
        if ((updated = new SpannableStringBuilder((CharSequence)dest).replace(dstart, dend, (CharSequence)result, start, end).toString()).length() >= 1 && (updated.charAt(0) < '0' || '1' < updated.charAt(0))) {
            return "";
        }
        if (updated.length() >= 2) {
            if (updated.charAt(0) != '0' && updated.charAt(1) > '2') {
                return "";
            }
            if (updated.charAt(0) == '0' && updated.charAt(1) == '0') {
                return "";
            }
        }
        if (updated.length() > 5) {
            return "";
        }
        return result;
    }
}

