/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.text.Editable;
import android.text.Spanned;
import io.card.payment.Validator;

class FixedLengthValidator
implements Validator {
    public int requiredLength;
    private String value;

    public FixedLengthValidator(int length) {
        this.requiredLength = length;
    }

    public void afterTextChanged(Editable s) {
        this.value = s.toString();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean hasFullLength() {
        return this.isValid();
    }

    @Override
    public boolean isValid() {
        return this.value != null && this.value.length() == this.requiredLength;
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        if (end > 0 && dest.length() + dend - dstart + end > this.requiredLength) {
            return "";
        }
        return null;
    }
}

