/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import io.card.payment.CardIOActivity;
import io.card.payment.CreditCard;
import io.card.payment.DetectionInfo;
import io.card.payment.Logo;
import io.card.payment.Torch;
import io.card.payment.Util;
import io.card.payment.i18n.LocalizedStrings;
import io.card.payment.i18n.StringKey;
import java.lang.ref.WeakReference;

class OverlayView
extends View {
    private static final String TAG = OverlayView.class.getSimpleName();
    private static final GradientDrawable.Orientation[] GRADIENT_ORIENTATIONS = new GradientDrawable.Orientation[]{GradientDrawable.Orientation.TOP_BOTTOM, GradientDrawable.Orientation.LEFT_RIGHT, GradientDrawable.Orientation.BOTTOM_TOP, GradientDrawable.Orientation.RIGHT_LEFT};
    private final WeakReference<CardIOActivity> mScanActivityRef;
    private DetectionInfo mDInfo;
    private Bitmap mBitmap;
    private Rect mGuide;
    private CreditCard mDetectedCard;
    private int mRotation;
    private int mState;
    private int guideColor;
    private boolean hideCardIOLogo;
    private String scanInstructions;
    private GradientDrawable mGradientDrawable;
    private final Paint mGuidePaint;
    private final Paint mLockedBackgroundPaint;
    private Path mLockedBackgroundPath;
    private Rect mCameraPreviewRect;
    private final Torch mTorch;
    private final Logo mLogo;
    private Rect mTorchRect;
    private Rect mLogoRect;
    private final boolean mShowTorch;
    private int mRotationFlip;
    private float mScale = 1.0f;

    public OverlayView(CardIOActivity captureActivity, AttributeSet attributeSet, boolean showTorch) {
        super((Context)captureActivity, attributeSet);
        this.mShowTorch = showTorch;
        this.mScanActivityRef = new WeakReference<CardIOActivity>(captureActivity);
        this.mRotationFlip = 1;
        this.mScale = this.getResources().getDisplayMetrics().density / 1.5f;
        this.mTorch = new Torch(70.0f * this.mScale, 50.0f * this.mScale);
        this.mLogo = new Logo((Context)captureActivity);
        this.mGuidePaint = new Paint(1);
        this.mLockedBackgroundPaint = new Paint(1);
        this.mLockedBackgroundPaint.clearShadowLayer();
        this.mLockedBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mLockedBackgroundPaint.setColor(-1157627904);
        this.scanInstructions = LocalizedStrings.getString(StringKey.SCAN_GUIDE);
    }

    public void setGuideColor(int color) {
        this.guideColor = color;
    }

    public void setHideCardIOLogo(boolean hide) {
        this.hideCardIOLogo = hide;
    }

    public void setScanInstructions(String scanInstructions) {
        this.scanInstructions = scanInstructions;
    }

    public void setGuideAndRotation(Rect rect, int rotation) {
        Point topEdgeUIOffset;
        this.mRotation = rotation;
        this.mGuide = rect;
        this.invalidate();
        if (this.mRotation % 180 != 0) {
            topEdgeUIOffset = new Point((int)(40.0f * this.mScale), (int)(60.0f * this.mScale));
            this.mRotationFlip = -1;
        } else {
            topEdgeUIOffset = new Point((int)(60.0f * this.mScale), (int)(40.0f * this.mScale));
            this.mRotationFlip = 1;
        }
        if (this.mCameraPreviewRect != null) {
            Point torchPoint = new Point(this.mCameraPreviewRect.left + topEdgeUIOffset.x, this.mCameraPreviewRect.top + topEdgeUIOffset.y);
            this.mTorchRect = Util.rectGivenCenter(torchPoint, (int)(70.0f * this.mScale), (int)(50.0f * this.mScale));
            Point logoPoint = new Point(this.mCameraPreviewRect.right - topEdgeUIOffset.x, this.mCameraPreviewRect.top + topEdgeUIOffset.y);
            this.mLogoRect = Util.rectGivenCenter(logoPoint, (int)(100.0f * this.mScale), (int)(50.0f * this.mScale));
            int[] gradientColors = new int[]{-1, -16777216};
            GradientDrawable.Orientation gradientOrientation = GRADIENT_ORIENTATIONS[this.mRotation / 90 % 4];
            this.mGradientDrawable = new GradientDrawable(gradientOrientation, gradientColors);
            this.mGradientDrawable.setGradientType(0);
            this.mGradientDrawable.setBounds(this.mGuide);
            this.mGradientDrawable.setAlpha(50);
            this.mLockedBackgroundPath = new Path();
            this.mLockedBackgroundPath.addRect(new RectF(this.mCameraPreviewRect), Path.Direction.CW);
            this.mLockedBackgroundPath.addRect(new RectF(this.mGuide), Path.Direction.CCW);
        }
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
        }
        this.mBitmap = bitmap;
        if (this.mBitmap != null) {
            this.decorateBitmap();
        }
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setDetectionInfo(DetectionInfo dinfo) {
        if (this.mDInfo != null && !this.mDInfo.sameEdgesAs(dinfo)) {
            this.invalidate();
        }
        this.mDInfo = dinfo;
    }

    public Bitmap getCardImage() {
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            return Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)0, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight());
        }
        return null;
    }

    private Rect guideStrokeRect(int x1, int y1, int x2, int y2) {
        int t2 = (int)(8.0f * this.mScale);
        Rect r = new Rect();
        r.left = Math.min(x1, x2) - t2;
        r.right = Math.max(x1, x2) + t2;
        r.top = Math.min(y1, y2) - t2;
        r.bottom = Math.max(y1, y2) + t2;
        return r;
    }

    public void onDraw(Canvas canvas) {
        if (this.mGuide == null || this.mCameraPreviewRect == null) {
            return;
        }
        canvas.save();
        this.mGradientDrawable.draw(canvas);
        int tickLength = this.mRotation == 0 || this.mRotation == 180 ? (this.mGuide.bottom - this.mGuide.top) / 4 : (this.mGuide.right - this.mGuide.left) / 4;
        if (this.mDInfo != null && this.mDInfo.numVisibleEdges() == 4) {
            canvas.drawPath(this.mLockedBackgroundPath, this.mLockedBackgroundPaint);
        }
        this.mGuidePaint.clearShadowLayer();
        this.mGuidePaint.setStyle(Paint.Style.FILL);
        this.mGuidePaint.setColor(this.guideColor);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.left, this.mGuide.top, this.mGuide.left + tickLength, this.mGuide.top), this.mGuidePaint);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.left, this.mGuide.top, this.mGuide.left, this.mGuide.top + tickLength), this.mGuidePaint);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.right, this.mGuide.top, this.mGuide.right - tickLength, this.mGuide.top), this.mGuidePaint);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.right, this.mGuide.top, this.mGuide.right, this.mGuide.top + tickLength), this.mGuidePaint);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.left, this.mGuide.bottom, this.mGuide.left + tickLength, this.mGuide.bottom), this.mGuidePaint);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.left, this.mGuide.bottom, this.mGuide.left, this.mGuide.bottom - tickLength), this.mGuidePaint);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.right, this.mGuide.bottom, this.mGuide.right - tickLength, this.mGuide.bottom), this.mGuidePaint);
        canvas.drawRect(this.guideStrokeRect(this.mGuide.right, this.mGuide.bottom, this.mGuide.right, this.mGuide.bottom - tickLength), this.mGuidePaint);
        if (this.mDInfo != null) {
            if (this.mDInfo.topEdge) {
                canvas.drawRect(this.guideStrokeRect(this.mGuide.left, this.mGuide.top, this.mGuide.right, this.mGuide.top), this.mGuidePaint);
            }
            if (this.mDInfo.bottomEdge) {
                canvas.drawRect(this.guideStrokeRect(this.mGuide.left, this.mGuide.bottom, this.mGuide.right, this.mGuide.bottom), this.mGuidePaint);
            }
            if (this.mDInfo.leftEdge) {
                canvas.drawRect(this.guideStrokeRect(this.mGuide.left, this.mGuide.top, this.mGuide.left, this.mGuide.bottom), this.mGuidePaint);
            }
            if (this.mDInfo.rightEdge) {
                canvas.drawRect(this.guideStrokeRect(this.mGuide.right, this.mGuide.top, this.mGuide.right, this.mGuide.bottom), this.mGuidePaint);
            }
            if (this.mDInfo.numVisibleEdges() < 3) {
                float guideHeight = 34.0f * this.mScale;
                float guideFontSize = 26.0f * this.mScale;
                Util.setupTextPaintStyle(this.mGuidePaint);
                this.mGuidePaint.setTextAlign(Paint.Align.CENTER);
                this.mGuidePaint.setTextSize(guideFontSize);
                canvas.translate((float)(this.mGuide.left + this.mGuide.width() / 2), (float)(this.mGuide.top + this.mGuide.height() / 2));
                canvas.rotate((float)(this.mRotationFlip * this.mRotation));
                if (this.scanInstructions != null && this.scanInstructions != "") {
                    String[] lines = this.scanInstructions.split("\n");
                    float y = -((guideHeight * (float)(lines.length - 1) - guideFontSize) / 2.0f) - 3.0f;
                    for (int i = 0; i < lines.length; ++i) {
                        canvas.drawText(lines[i], 0.0f, y, this.mGuidePaint);
                        y += guideHeight;
                    }
                }
            }
        }
        canvas.restore();
        if (!this.hideCardIOLogo) {
            canvas.save();
            canvas.translate(this.mLogoRect.exactCenterX(), this.mLogoRect.exactCenterY());
            canvas.rotate((float)(this.mRotationFlip * this.mRotation));
            this.mLogo.draw(canvas, 100.0f * this.mScale, 50.0f * this.mScale);
            canvas.restore();
        }
        if (this.mShowTorch) {
            canvas.save();
            canvas.translate(this.mTorchRect.exactCenterX(), this.mTorchRect.exactCenterY());
            canvas.rotate((float)(this.mRotationFlip * this.mRotation));
            this.mTorch.draw(canvas);
            canvas.restore();
        }
    }

    public void setDetectedCard(CreditCard creditCard) {
        this.mDetectedCard = creditCard;
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            int action = event.getAction() & 0xFF;
            if (action == 0) {
                Point p = new Point((int)event.getX(), (int)event.getY());
                Rect r = Util.rectGivenCenter(p, 20, 20);
                if (this.mShowTorch && this.mTorchRect != null && Rect.intersects((Rect)this.mTorchRect, (Rect)r)) {
                    ((CardIOActivity)((Object)this.mScanActivityRef.get())).toggleFlash();
                } else {
                    ((CardIOActivity)((Object)this.mScanActivityRef.get())).triggerAutoFocus();
                }
            }
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"NullPointerException caught in onTouchEvent method");
        }
        return false;
    }

    private void decorateBitmap() {
        RectF roundedRect = new RectF(2.0f, 2.0f, (float)(this.mBitmap.getWidth() - 2), (float)(this.mBitmap.getHeight() - 2));
        float cornerRadius = (float)this.mBitmap.getHeight() * 0.06666667f;
        Bitmap maskBitmap = Bitmap.createBitmap((int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas maskCanvas = new Canvas(maskBitmap);
        maskCanvas.drawColor(0);
        Paint maskPaint = new Paint(1);
        maskPaint.setColor(-16777216);
        maskPaint.setStyle(Paint.Style.FILL);
        maskCanvas.drawRoundRect(roundedRect, cornerRadius, cornerRadius, maskPaint);
        Paint paint = new Paint();
        paint.setFilterBitmap(false);
        Canvas canvas = new Canvas(this.mBitmap);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawBitmap(maskBitmap, 0.0f, 0.0f, paint);
        paint.setXfermode(null);
        maskBitmap.recycle();
    }

    public void markupCard() {
        if (this.mBitmap == null) {
            return;
        }
        if (this.mDetectedCard.flipped) {
            Matrix m = new Matrix();
            m.setRotate(180.0f, (float)(this.mBitmap.getWidth() / 2), (float)(this.mBitmap.getHeight() / 2));
            this.mBitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)0, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Matrix)m, (boolean)false);
        }
        Canvas bc = new Canvas(this.mBitmap);
        Paint paint = new Paint();
        Util.setupTextPaintStyle(paint);
        paint.setTextSize(28.0f * this.mScale);
        int len = this.mDetectedCard.cardNumber.length();
        float sf = (float)this.mBitmap.getWidth() / 428.0f;
        int yOffset = (int)((float)this.mDetectedCard.yoff * sf - 6.0f);
        for (int i = 0; i < len; ++i) {
            int xOffset = (int)((float)this.mDetectedCard.xoff[i] * sf);
            bc.drawText("" + this.mDetectedCard.cardNumber.charAt(i), (float)xOffset, (float)yOffset, paint);
        }
    }

    public boolean isAnimating() {
        return this.mState != 0;
    }

    public void setCameraPreviewRect(Rect rect) {
        this.mCameraPreviewRect = rect;
    }

    public void setTorchOn(boolean b) {
        this.mTorch.setOn(b);
        this.invalidate();
    }

    public void setUseCardIOLogo(boolean useCardIOLogo) {
        this.mLogo.loadLogo(useCardIOLogo);
    }

    public Rect getTorchRect() {
        return this.mTorchRect;
    }
}

