/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment.ui;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.widget.TextView;
import io.card.payment.ui.Appearance;

public class ActivityHelper {
    @TargetApi(value=11)
    public static void addActionBarIfSupported(Activity activity) {
        if (ActivityHelper.actionBarSupported()) {
            activity.requestWindowFeature(8);
        }
    }

    public static void setupActionBarIfSupported(Activity activity, TextView titleTextView, String title, String titleTextViewPrefix, Drawable icon) {
        if (titleTextViewPrefix == null) {
            titleTextViewPrefix = "";
        }
        activity.setTitle((CharSequence)(titleTextViewPrefix + title));
        if (ActivityHelper.actionBarSupported() && ActivityHelper.actionBarNonNull(activity)) {
            ActivityHelper.setupActionBar(activity, title, icon);
            if (titleTextView != null) {
                titleTextView.setVisibility(8);
            }
        } else if (titleTextView != null) {
            titleTextView.setText((CharSequence)title);
        }
    }

    @TargetApi(value=11)
    private static boolean actionBarNonNull(Activity activity) {
        return activity.getActionBar() != null;
    }

    @TargetApi(value=11)
    private static void setupActionBar(Activity activity, String title, Drawable icon) {
        ActionBar bar = activity.getActionBar();
        bar.setBackgroundDrawable(Appearance.ACTIONBAR_BACKGROUND);
        bar.setTitle((CharSequence)title);
        int actionBarTitleId = Resources.getSystem().getIdentifier("action_bar_title", "id", "android");
        TextView actionBarTextView = (TextView)activity.findViewById(actionBarTitleId);
        if (actionBarTextView != null) {
            actionBarTextView.setTextColor(-1);
        }
        bar.setDisplayHomeAsUpEnabled(false);
        if (icon != null && Build.VERSION.SDK_INT >= 14) {
            ActivityHelper.setActionBarHomeIcon(bar, icon);
        } else {
            bar.setDisplayShowHomeEnabled(false);
        }
    }

    private static boolean actionBarSupported() {
        return Build.VERSION.SDK_INT >= 11;
    }

    @TargetApi(value=14)
    private static void setActionBarHomeIcon(ActionBar bar, Drawable icon) {
        bar.setIcon(icon);
    }

    public static boolean holoSupported() {
        return Build.VERSION.SDK_INT >= 11;
    }

    @TargetApi(value=11)
    public static void setActivityTheme(Activity activity, boolean useApplicationTheme) {
        if (useApplicationTheme && 0 != activity.getApplicationInfo().theme) {
            activity.setTheme(activity.getApplicationInfo().theme);
        } else if (ActivityHelper.holoSupported()) {
            activity.setTheme(16973934);
        } else {
            activity.setTheme(16973836);
        }
    }

    @TargetApi(value=11)
    public static void setFlagSecure(Activity activity) {
        if (Build.VERSION.SDK_INT >= 11) {
            activity.getWindow().addFlags(8192);
        }
    }
}

