/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import io.card.payment.ui.ViewUtil;

public class Appearance {
    public static final int[] BUTTON_STATE_PRESSED = new int[]{16842919, 16842910};
    public static final int[] BUTTON_STATE_NORMAL = new int[]{16842910};
    public static final int[] BUTTON_STATE_DISABLED = new int[]{-16842910};
    public static final int[] BUTTON_STATE_FOCUSED = new int[]{16842908};
    public static final int PAY_BLUE_COLOR = Color.parseColor((String)"#003087");
    public static final int PAL_BLUE_COLOR = Color.parseColor((String)"#009CDE");
    public static final int PAL_BLUE_COLOR_OPACITY_66 = Color.parseColor((String)"#aa009CDE");
    public static final Drawable ACTIONBAR_BACKGROUND = new ColorDrawable(Color.parseColor((String)"#717074"));
    public static final int DEFAULT_BACKGROUND_COLOR = Color.parseColor((String)"#f5f5f5");
    public static final int BUTTON_PRIMARY_NORMAL_COLOR = PAL_BLUE_COLOR;
    public static final int BUTTON_PRIMARY_FOCUS_COLOR = PAL_BLUE_COLOR_OPACITY_66;
    public static final int BUTTON_PRIMARY_PRESSED_COLOR = PAY_BLUE_COLOR;
    public static final int BUTTON_PRIMARY_DISABLED_COLOR = Color.parseColor((String)"#c5ddeb");
    public static final int BUTTON_SECONDARY_NORMAL_COLOR = Color.parseColor((String)"#717074");
    public static final int BUTTON_SECONDARY_FOCUS_COLOR = Color.parseColor((String)"#aa717074");
    public static final int BUTTON_SECONDARY_PRESSED_COLOR = Color.parseColor((String)"#5a5a5d");
    public static final int BUTTON_SECONDARY_DISABLED_COLOR = Color.parseColor((String)"#f5f5f5");
    public static final int TEXT_COLOR_LIGHT = Color.parseColor((String)"#515151");
    public static final int TEXT_COLOR_ERROR = Color.parseColor((String)"#b32317");
    public static final int TEXT_COLOR_LABEL = TEXT_COLOR_LIGHT;
    public static final Typeface TYPEFACE_BUTTON = Appearance.typefaceLight();

    public static Drawable buttonBackgroundPrimary(Context context) {
        StateListDrawable d = new StateListDrawable();
        d.addState(BUTTON_STATE_PRESSED, (Drawable)new ColorDrawable(BUTTON_PRIMARY_PRESSED_COLOR));
        d.addState(BUTTON_STATE_DISABLED, (Drawable)new ColorDrawable(BUTTON_PRIMARY_DISABLED_COLOR));
        d.addState(BUTTON_STATE_FOCUSED, Appearance.buttonBackgroundPrimaryFocused(context));
        d.addState(BUTTON_STATE_NORMAL, Appearance.buttonBackgroundPrimaryNormal(context));
        return d;
    }

    private static float getFocusBorderWidthPixels(Context context) {
        float scale = context.getResources().getDisplayMetrics().density;
        float adjustedwidth = ViewUtil.typedDimensionValueToPixels("4dip", context) / 2.0f * scale;
        return adjustedwidth;
    }

    private static Drawable buttonBackgroundPrimaryNormal(Context context) {
        return Appearance.buttonNormal(BUTTON_PRIMARY_NORMAL_COLOR, Appearance.getFocusBorderWidthPixels(context));
    }

    private static Drawable buttonBackgroundPrimaryFocused(Context context) {
        return Appearance.buttonFocused(BUTTON_PRIMARY_NORMAL_COLOR, BUTTON_PRIMARY_FOCUS_COLOR, Appearance.getFocusBorderWidthPixels(context));
    }

    public static Drawable buttonBackgroundSecondary(Context context) {
        StateListDrawable d = new StateListDrawable();
        d.addState(BUTTON_STATE_PRESSED, (Drawable)new ColorDrawable(BUTTON_SECONDARY_PRESSED_COLOR));
        d.addState(BUTTON_STATE_DISABLED, (Drawable)new ColorDrawable(BUTTON_SECONDARY_DISABLED_COLOR));
        d.addState(BUTTON_STATE_FOCUSED, Appearance.buttonBackgroundSecondaryFocused(context));
        d.addState(BUTTON_STATE_NORMAL, Appearance.buttonBackgroundSecondaryNormal(context));
        return d;
    }

    private static Drawable buttonBackgroundSecondaryNormal(Context context) {
        return Appearance.buttonNormal(BUTTON_SECONDARY_NORMAL_COLOR, Appearance.getFocusBorderWidthPixels(context));
    }

    private static Drawable buttonBackgroundSecondaryFocused(Context context) {
        return Appearance.buttonFocused(BUTTON_SECONDARY_NORMAL_COLOR, BUTTON_SECONDARY_FOCUS_COLOR, Appearance.getFocusBorderWidthPixels(context));
    }

    private static Drawable buttonNormal(int color, float width) {
        Drawable[] layers = new Drawable[2];
        layers[0] = new ColorDrawable(color);
        ShapeDrawable s = new ShapeDrawable((Shape)new RectShape());
        s.getPaint().setStrokeWidth(2.0f * width);
        s.getPaint().setStyle(Paint.Style.STROKE);
        s.getPaint().setColor(DEFAULT_BACKGROUND_COLOR);
        layers[1] = s;
        LayerDrawable ld = new LayerDrawable(layers);
        return ld;
    }

    private static Drawable buttonFocused(int backgroundColor, int focusBoxColor, float scaledBorderWidth) {
        Drawable[] layers = new Drawable[3];
        layers[0] = new ColorDrawable(backgroundColor);
        ShapeDrawable s = new ShapeDrawable((Shape)new RectShape());
        s.getPaint().setStrokeWidth(2.0f * scaledBorderWidth);
        s.getPaint().setStyle(Paint.Style.STROKE);
        s.getPaint().setColor(DEFAULT_BACKGROUND_COLOR);
        layers[1] = s;
        ShapeDrawable s2 = new ShapeDrawable((Shape)new RectShape());
        s2.getPaint().setStrokeWidth(scaledBorderWidth);
        s2.getPaint().setStyle(Paint.Style.STROKE);
        s2.getPaint().setColor(focusBoxColor);
        layers[2] = s2;
        LayerDrawable ld = new LayerDrawable(layers);
        return ld;
    }

    private static Typeface typefaceLight() {
        return Typeface.create((String)"sans-serif-light", (int)0);
    }
}

