/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import io.card.payment.ui.Appearance;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ViewUtil {
    private static final Map<String, Integer> DIMENSION_STRING_CONSTANT = ViewUtil.initDimensionStringConstantMap();
    static Pattern DIMENSION_VALUE_PATTERN = Pattern.compile("^\\s*(\\d+(\\.\\d+)*)\\s*([a-zA-Z]+)\\s*$");
    static HashMap<String, Float> pxDimensionLookupTable = new HashMap();

    @TargetApi(value=16)
    public static void setBackground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    static Map<String, Integer> initDimensionStringConstantMap() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("px", 0);
        m.put("dip", 1);
        m.put("dp", 1);
        m.put("sp", 2);
        m.put("pt", 3);
        m.put("in", 4);
        m.put("mm", 5);
        return Collections.unmodifiableMap(m);
    }

    public static int typedDimensionValueToPixelsInt(String dimensionValueString, Context context) {
        if (dimensionValueString == null) {
            return 0;
        }
        return (int)ViewUtil.typedDimensionValueToPixels(dimensionValueString, context);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static float typedDimensionValueToPixels(String dimensionValueString, Context context) {
        if (dimensionValueString == null) {
            return 0.0f;
        }
        if (pxDimensionLookupTable.containsKey(dimensionValueString = dimensionValueString.toLowerCase())) {
            return pxDimensionLookupTable.get(dimensionValueString).floatValue();
        }
        Matcher m = DIMENSION_VALUE_PATTERN.matcher(dimensionValueString);
        if (!m.matches()) {
            throw new NumberFormatException();
        }
        float value = Float.parseFloat(m.group(1));
        String dimensionString = m.group(3).toLowerCase();
        Integer unit = DIMENSION_STRING_CONSTANT.get(dimensionString);
        if (unit == null) {
            unit = 1;
        }
        float ret = TypedValue.applyDimension((int)unit, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
        pxDimensionLookupTable.put(dimensionValueString, Float.valueOf(ret));
        return ret;
    }

    public static void setPadding(View view, String left, String top, String right, String bottom) {
        Context context = view.getContext();
        view.setPadding(ViewUtil.typedDimensionValueToPixelsInt(left, context), ViewUtil.typedDimensionValueToPixelsInt(top, context), ViewUtil.typedDimensionValueToPixelsInt(right, context), ViewUtil.typedDimensionValueToPixelsInt(bottom, context));
    }

    public static void setMargins(View view, String left, String top, String right, String bottom) {
        Context context = view.getContext();
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (params instanceof ViewGroup.MarginLayoutParams) {
            ((ViewGroup.MarginLayoutParams)params).setMargins(ViewUtil.typedDimensionValueToPixelsInt(left, context), ViewUtil.typedDimensionValueToPixelsInt(top, context), ViewUtil.typedDimensionValueToPixelsInt(right, context), ViewUtil.typedDimensionValueToPixelsInt(bottom, context));
        }
    }

    public static void setDimensions(View view, int width, int height) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        params.width = width;
        params.height = height;
    }

    public static void styleAsButton(Button button, boolean primary, Context context, boolean useApplicationTheme) {
        ViewUtil.setDimensions((View)button, -1, -2);
        button.setFocusable(true);
        ViewUtil.setPadding((View)button, "10dip", "0dip", "10dip", "0dip");
        if (!useApplicationTheme) {
            ViewUtil.setBackground((View)button, primary ? Appearance.buttonBackgroundPrimary(context) : Appearance.buttonBackgroundSecondary(context));
            button.setGravity(17);
            button.setMinimumHeight(ViewUtil.typedDimensionValueToPixelsInt("54dip", context));
            button.setTextColor(-1);
            button.setTextSize(20.0f);
            button.setTypeface(Appearance.TYPEFACE_BUTTON);
        }
    }
}

