/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.asm;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.Type;

public final class ClassDefinition {
    private final byte[] bytecode;
    private final String internalName;
    private final List<Class<?>> preservedClasses;

    public ClassDefinition(byte[] bytecode, String internalName) {
        this(bytecode, internalName, (Iterable<? extends Class<?>>)ImmutableList.of());
    }

    public ClassDefinition(byte[] bytecode, String internalName, Iterable<? extends Class<?>> preservedClasses) {
        this.bytecode = bytecode;
        this.internalName = internalName;
        this.preservedClasses = ImmutableList.copyOf(preservedClasses);
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getClassName() {
        return Type.getObjectType((String)this.internalName).getClassName();
    }

    public List<Class<?>> getPreservedClasses() {
        return this.preservedClasses;
    }
}

