/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.lang;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;

public final class Fields {
    public static Field findField(TypeToken<?> classType, String fieldName) throws NoSuchFieldException {
        return Fields.findField(classType, fieldName, (Predicate<Field>)Predicates.alwaysTrue());
    }

    public static Field findField(TypeToken<?> classType, String fieldName, Predicate<Field> predicate) throws NoSuchFieldException {
        for (Class clz : classType.getTypes().classes().rawTypes()) {
            try {
                Field field = clz.getDeclaredField(fieldName);
                if (!predicate.apply((Object)field)) continue;
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        throw new NoSuchFieldException("Field " + fieldName + " not exists in the class hierarchy of " + classType);
    }

    private Fields() {
    }
}

