/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.lang;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.cdap.common.internal.lang.Visitor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;

public final class Reflections {
    public static boolean isResolved(Type type) {
        if (type instanceof GenericArrayType) {
            return Reflections.isResolved(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            for (Type t : ((ParameterizedType)type).getActualTypeArguments()) {
                if (Reflections.isResolved(t)) continue;
                return false;
            }
            return true;
        }
        return type instanceof Class;
    }

    public static void visit(Object instance, TypeToken<?> inspectType, Visitor firstVisitor, Visitor ... moreVisitors) {
        try {
            TypeToken type;
            ImmutableList visitors = ImmutableList.builder().add((Object)firstVisitor).add((Object[])moreVisitors).build();
            Iterator iterator = inspectType.getTypes().classes().iterator();
            while (iterator.hasNext() && !Object.class.equals((Object)(type = (TypeToken)iterator.next()).getRawType())) {
                for (Field field : type.getRawType().getDeclaredFields()) {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    for (Visitor visitor : visitors) {
                        visitor.visit(instance, inspectType, type, field);
                    }
                }
                for (AccessibleObject accessibleObject : type.getRawType().getDeclaredMethods()) {
                    if (!accessibleObject.isAccessible()) {
                        ((Method)accessibleObject).setAccessible(true);
                    }
                    for (Visitor visitor : visitors) {
                        visitor.visit(instance, inspectType, type, (Method)accessibleObject);
                    }
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Reflections() {
    }
}

