/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.lang;

import com.google.common.base.Objects;
import javax.annotation.Nullable;

public final class ClassLoaders {
    private ClassLoaders() {
    }

    public static Class<?> loadClass(String className, @Nullable ClassLoader classLoader, Object caller) throws ClassNotFoundException {
        ClassLoader cl = (ClassLoader)Objects.firstNonNull((Object)classLoader, (Object)caller.getClass().getClassLoader());
        return cl.loadClass(className);
    }

    public static ClassLoader setContextClassLoader(ClassLoader classLoader) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        return oldClassLoader;
    }
}

