/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.lang;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryClassLoader.class);
    private static final FilenameFilter JAR_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public DirectoryClassLoader(File dir, ClassLoader parent, String ... libDirs) {
        this(dir, parent, (Iterable<String>)ImmutableSet.copyOf((Object[])libDirs));
    }

    public DirectoryClassLoader(File dir, ClassLoader parent, Iterable<String> libDirs) {
        super(DirectoryClassLoader.getClassPathURLs(dir, (Set<String>)ImmutableSet.copyOf(libDirs)), parent);
    }

    private static URL[] getClassPathURLs(File dir, Set<String> libDirs) {
        try {
            ArrayList urls = Lists.newArrayList((Object[])new URL[]{dir.toURI().toURL()});
            DirectoryClassLoader.addJarURLs(dir, urls);
            for (String libDir : libDirs) {
                DirectoryClassLoader.addJarURLs(new File(dir, libDir), urls);
            }
            return urls.toArray(new URL[urls.size()]);
        }
        catch (MalformedURLException e) {
            LOG.error("Error in adding jar URLs to classPathUrls", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void addJarURLs(File dir, List<URL> result) throws MalformedURLException {
        File[] files = dir.listFiles(JAR_FILE_FILTER);
        if (files == null) {
            return;
        }
        for (File file : files) {
            result.add(file.toURI().toURL());
        }
    }
}

