/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class HandlerException
extends Exception {
    private final HttpResponseStatus failureStatus;
    private final String message;

    public HandlerException(HttpResponseStatus failureStatus, String message) {
        super(message);
        this.failureStatus = failureStatus;
        this.message = message;
    }

    HandlerException(HttpResponseStatus failureStatus, String message, Throwable cause) {
        super(message, cause);
        this.failureStatus = failureStatus;
        this.message = message;
    }

    public HttpResponse createFailureResponse() {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.failureStatus, Unpooled.copiedBuffer((CharSequence)this.message, (Charset)StandardCharsets.UTF_8));
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        return response;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

