/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.internal.ImmutablePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternPathRouterWithGroups<T> {
    public static final Pattern GROUP_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final Pattern WILD_CARD_PATTERN = Pattern.compile("\\*\\*");
    private final int maxPathParts;
    private final List<ImmutablePair<Pattern, RouteDestinationWithGroups>> patternRouteList;

    public static <T> PatternPathRouterWithGroups<T> create(int maxPathParts) {
        return new PatternPathRouterWithGroups<T>(maxPathParts);
    }

    public PatternPathRouterWithGroups(int maxPathParts) {
        this.maxPathParts = maxPathParts;
        this.patternRouteList = new ArrayList<ImmutablePair<Pattern, RouteDestinationWithGroups>>();
    }

    public void add(String source, T destination) {
        String path = source.replaceAll("/+", "/");
        path = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        String[] parts = path.split("/", this.maxPathParts + 2);
        if (parts.length - 1 > this.maxPathParts) {
            throw new IllegalArgumentException(String.format("Number of parts of path %s exceeds allowed limit %s", source, this.maxPathParts));
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (String part : parts) {
            Matcher groupMatcher = GROUP_PATTERN.matcher(part);
            if (groupMatcher.matches()) {
                groupNames.add(groupMatcher.group(1));
                sb.append("([^/]+?)");
            } else if (WILD_CARD_PATTERN.matcher(part).matches()) {
                sb.append(".*?");
            } else {
                sb.append(part);
            }
            sb.append("/");
        }
        sb.setLength(sb.length() - 1);
        Pattern pattern = Pattern.compile(sb.toString());
        this.patternRouteList.add(ImmutablePair.of(pattern, new RouteDestinationWithGroups(destination, groupNames)));
    }

    public List<RoutableDestination<T>> getDestinations(String path) {
        String cleanPath = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        ArrayList<RoutableDestination<T>> result = new ArrayList<RoutableDestination<T>>();
        for (ImmutablePair<Pattern, RouteDestinationWithGroups> patternRoute : this.patternRouteList) {
            HashMap<String, String> groupNameValuesBuilder = new HashMap<String, String>();
            Matcher matcher = patternRoute.getFirst().matcher(cleanPath);
            if (!matcher.matches()) continue;
            int matchIndex = 1;
            for (String name : patternRoute.getSecond().getGroupNames()) {
                String value = matcher.group(matchIndex);
                groupNameValuesBuilder.put(name, value);
                ++matchIndex;
            }
            result.add(new RoutableDestination(patternRoute.getSecond().getDestination(), groupNameValuesBuilder));
        }
        return result;
    }

    public static final class RoutableDestination<T> {
        private final T destination;
        private final Map<String, String> groupNameValues;

        public RoutableDestination(T destination, Map<String, String> groupNameValues) {
            this.destination = destination;
            this.groupNameValues = groupNameValues;
        }

        public T getDestination() {
            return this.destination;
        }

        public Map<String, String> getGroupNameValues() {
            return this.groupNameValues;
        }

        public String toString() {
            return "RoutableDestination{destination=" + this.destination + ", groupNameValues=" + this.groupNameValues + '}';
        }
    }

    private final class RouteDestinationWithGroups {
        private final T destination;
        private final List<String> groupNames;

        public RouteDestinationWithGroups(T destination, List<String> groupNames) {
            this.destination = destination;
            this.groupNames = groupNames;
        }

        public T getDestination() {
            return this.destination;
        }

        public List<String> getGroupNames() {
            return this.groupNames;
        }
    }
}

