/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.manager;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;

public class EnumStringTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (!rawType.isEnum()) {
            return null;
        }
        final HashMap labelMap = new HashMap();
        for (Object constant : rawType.getEnumConstants()) {
            labelMap.put(constant.toString(), constant);
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    out.value(value.toString());
                }
            }

            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                return labelMap.get(reader.nextString());
            }
        };
    }
}

