/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.manager;

import io.cdap.cdap.api.spark.AbstractExtendedSpark;
import io.cdap.cdap.api.spark.JavaSparkExecutionContext;
import io.cdap.cdap.api.spark.JavaSparkMain;
import io.cdap.cdap.api.spark.service.SparkHttpServiceHandler;
import io.cdap.mmds.manager.ModelManagerServiceHandler;
import java.util.HashMap;
import org.apache.spark.sql.SparkSession;

public class ModelManagerService
extends AbstractExtendedSpark
implements JavaSparkMain {
    public static final String NAME = "ModelManagerService";
    private final String modelMetaDataset;
    private final String modelComponentsDataset;
    private final String experimentMetaDataset;
    private final String splitsDataset;

    public ModelManagerService() {
        this("experiment_model_meta", "experiment_model_components", "experiment_meta", "experiment_splits");
    }

    ModelManagerService(String modelMetaDataset, String modelComponentsDataset, String experimentMetaDataset, String splitsDataset) {
        this.modelMetaDataset = modelMetaDataset;
        this.modelComponentsDataset = modelComponentsDataset;
        this.experimentMetaDataset = experimentMetaDataset;
        this.splitsDataset = splitsDataset;
    }

    protected void configure() {
        this.setName(NAME);
        this.setDescription("Manages Machine Learning Experiments and Models");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("modelMetaDataset", this.modelMetaDataset);
        properties.put("modelComponentsDataset", this.modelComponentsDataset);
        properties.put("experimentMetaDataset", this.experimentMetaDataset);
        properties.put("splitsDataset", this.splitsDataset);
        this.setProperties(properties);
        this.addHandlers(new SparkHttpServiceHandler[]{new ModelManagerServiceHandler()});
        this.setMainClass(ModelManagerService.class);
    }

    public void run(JavaSparkExecutionContext javaSparkExecutionContext) throws Exception {
        SparkSession.builder().appName("Model Management Service").getOrCreate();
    }
}

