/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import io.cdap.cdap.api.Transactional;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.FileSet;
import io.cdap.cdap.api.dataset.lib.IndexedTable;
import io.cdap.cdap.api.dataset.lib.PartitionedFileSet;
import io.cdap.cdap.api.service.http.HttpServiceRequest;
import io.cdap.cdap.api.service.http.HttpServiceResponder;
import io.cdap.cdap.api.spark.service.SparkHttpServiceContext;
import io.cdap.cdap.api.spark.service.SparkHttpServiceHandler;
import io.cdap.cdap.api.spark.sql.DataFrames;
import io.cdap.cdap.internal.io.SchemaTypeAdapter;
import io.cdap.mmds.ModelLogging;
import io.cdap.mmds.SplitLogging;
import io.cdap.mmds.api.Modeler;
import io.cdap.mmds.data.DataSplit;
import io.cdap.mmds.data.DataSplitInfo;
import io.cdap.mmds.data.DataSplitStats;
import io.cdap.mmds.data.DataSplitTable;
import io.cdap.mmds.data.Experiment;
import io.cdap.mmds.data.ExperimentMetaTable;
import io.cdap.mmds.data.ExperimentStore;
import io.cdap.mmds.data.ModelKey;
import io.cdap.mmds.data.ModelMeta;
import io.cdap.mmds.data.ModelTable;
import io.cdap.mmds.data.ModelTrainerInfo;
import io.cdap.mmds.data.SortInfo;
import io.cdap.mmds.data.SplitKey;
import io.cdap.mmds.manager.AlgorithmSpec;
import io.cdap.mmds.manager.DataSplitStatsGenerator;
import io.cdap.mmds.manager.EnumStringTypeAdapterFactory;
import io.cdap.mmds.manager.Id;
import io.cdap.mmds.modeler.Modelers;
import io.cdap.mmds.modeler.train.ModelOutput;
import io.cdap.mmds.modeler.train.ModelOutputWriter;
import io.cdap.mmds.modeler.train.ModelTrainer;
import io.cdap.mmds.proto.BadRequestException;
import io.cdap.mmds.proto.CreateModelRequest;
import io.cdap.mmds.proto.DirectivesRequest;
import io.cdap.mmds.proto.EndpointException;
import io.cdap.mmds.proto.TrainModelRequest;
import io.cdap.mmds.splitter.DataSplitResult;
import io.cdap.mmds.splitter.DatasetSplitter;
import io.cdap.mmds.splitter.SplitterSpec;
import io.cdap.mmds.splitter.Splitters;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.tephra.TransactionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelManagerServiceHandler
implements SparkHttpServiceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ModelManagerServiceHandler.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumStringTypeAdapterFactory()).serializeSpecialFloatingPointValues().create();
    private String modelMetaDataset;
    private String modelComponentsDataset;
    private String experimentMetaDataset;
    private String splitsDataset;
    private ModelOutputWriter modelOutputWriter;
    private SparkSession sparkSession;
    private SparkHttpServiceContext context;

    public void initialize(SparkHttpServiceContext context) throws Exception {
        this.context = context;
        this.sparkSession = context.getSparkSession();
        Map properties = context.getSpecification().getProperties();
        this.modelMetaDataset = (String)properties.get("modelMetaDataset");
        this.modelComponentsDataset = (String)properties.get("modelComponentsDataset");
        this.experimentMetaDataset = (String)properties.get("experimentMetaDataset");
        this.splitsDataset = (String)properties.get("splitsDataset");
        context.execute(datasetContext -> {
            FileSet modelComponents = (FileSet)datasetContext.getDataset(this.modelComponentsDataset);
            this.modelOutputWriter = new ModelOutputWriter(context.getAdmin(), (Transactional)context, modelComponents.getBaseLocation(), true);
        });
    }

    public void destroy() {
    }

    @GET
    @Path(value="/health")
    public void healthCheck(HttpServiceRequest request, HttpServiceResponder responder) {
        responder.sendStatus(200);
    }

    @GET
    @Path(value="/splitters")
    public void listSplitters(HttpServiceRequest request, HttpServiceResponder responder) {
        ArrayList<SplitterSpec> splitters = new ArrayList<SplitterSpec>();
        for (DatasetSplitter splitter : Splitters.getSplitters()) {
            splitters.add(splitter.getSpec());
        }
        responder.sendString(GSON.toJson(splitters));
    }

    @GET
    @Path(value="/splitters/{splitter}")
    public void getSplitter(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="splitter") String splitterType) {
        DatasetSplitter splitter = Splitters.getSplitter((String)splitterType);
        if (splitter == null) {
            responder.sendError(404, "Splitter " + splitterType + " not found.");
            return;
        }
        responder.sendString(GSON.toJson((Object)splitter.getSpec()));
    }

    @GET
    @Path(value="/algorithms")
    public void listAlgorithms(HttpServiceRequest request, HttpServiceResponder responder) {
        ArrayList<AlgorithmSpec> algorithms = new ArrayList<AlgorithmSpec>();
        for (Modeler modeler : Modelers.getModelers()) {
            List paramSpecs = modeler.getParams(new HashMap()).getSpec();
            algorithms.add(new AlgorithmSpec(modeler.getAlgorithm(), paramSpecs));
        }
        responder.sendString(GSON.toJson(algorithms));
    }

    @GET
    @Path(value="/algorithms/{algorithm}")
    public void getAlgorithm(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="algorithm") String algorithm) {
        Modeler modeler = Modelers.getModeler((String)algorithm);
        if (modeler == null) {
            responder.sendError(404, "Algorithm " + algorithm + " not found.");
            return;
        }
        List paramSpecs = modeler.getParams(new HashMap()).getSpec();
        responder.sendString(GSON.toJson((Object)new AlgorithmSpec(modeler.getAlgorithm(), paramSpecs)));
    }

    @GET
    @Path(value="/experiments")
    public void listExperiments(HttpServiceRequest request, HttpServiceResponder responder, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="srcPath") @DefaultValue(value="") String srcPath, @QueryParam(value="sort") @DefaultValue(value="name asc") String sort) {
        this.runInTx(responder, store -> {
            this.validate(offset, limit);
            Predicate<Experiment> predicate = srcPath.isEmpty() ? null : e -> e.getSrcpath().equals(srcPath);
            SortInfo sortInfo = SortInfo.parse((String)sort);
            responder.sendString(GSON.toJson((Object)store.listExperiments(offset, limit, predicate, sortInfo)));
        });
    }

    private void validate(int offset, int limit) {
        if (offset < 0) {
            throw new BadRequestException("Offset must be zero or a positive number");
        }
        if (limit <= 0) {
            throw new BadRequestException("Limit must be a positive number");
        }
    }

    @GET
    @Path(value="/experiments/{experiment-name}")
    public void getExperiment(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName) {
        this.runInTx(responder, store -> responder.sendString(GSON.toJson((Object)store.getExperimentStats(experimentName))));
    }

    @PUT
    @Path(value="/experiments/{experiment-name}")
    public void putExperiment(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName) {
        this.runInTx(responder, store -> {
            try {
                Experiment experiment = (Experiment)GSON.fromJson(Bytes.toString((ByteBuffer)request.getContent()), Experiment.class);
                experiment.validate();
                Experiment experimentInfo = new Experiment(experimentName, experiment);
                store.putExperiment(experimentInfo);
                responder.sendStatus(200);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e.getMessage());
            }
            catch (JsonSyntaxException e) {
                throw new BadRequestException(String.format("Problem occurred while parsing request body for Experiment: %s. Please provide valid json. Error: %s", experimentName, e.getMessage()));
            }
        });
    }

    @DELETE
    @Path(value="/experiments/{experiment-name}")
    public void deleteExperiment(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName) {
        this.runInTx(responder, store -> {
            store.deleteExperiment(experimentName);
            responder.sendStatus(200);
        });
    }

    @GET
    @Path(value="/experiments/{experiment-name}/models")
    public void listModels(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="sort") @DefaultValue(value="name asc") String sort) {
        this.runInTx(responder, store -> {
            this.validate(offset, limit);
            SortInfo sortInfo = SortInfo.parse((String)sort);
            responder.sendString(GSON.toJson((Object)store.listModels(experimentName, offset, limit, sortInfo)));
        });
    }

    @GET
    @Path(value="/experiments/{experiment-name}/models/{model-id}")
    public void getModel(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        ModelKey modelKey = new ModelKey(experimentName, modelId);
        this.runInTx(responder, store -> responder.sendString(GSON.toJson((Object)store.getModel(modelKey))));
    }

    @GET
    @Path(value="/experiments/{experiment-name}/models/{model-id}/status")
    public void getModelStatus(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        ModelKey modelKey = new ModelKey(experimentName, modelId);
        this.runInTx(responder, store -> {
            ModelMeta meta = store.getModel(modelKey);
            responder.sendString(GSON.toJson((Object)meta.getStatus()));
        });
    }

    @POST
    @Path(value="/experiments/{experiment-name}/models")
    public void addModel(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName) {
        this.runInTx(responder, store -> {
            try {
                CreateModelRequest createRequest = (CreateModelRequest)GSON.fromJson(Bytes.toString((ByteBuffer)request.getContent()), CreateModelRequest.class);
                if (createRequest == null) {
                    throw new BadRequestException("A request body must be provided containing the model information.");
                }
                createRequest.validate();
                String modelId = store.addModel(experimentName, createRequest);
                responder.sendString(GSON.toJson((Object)new Id(modelId)));
            }
            catch (JsonParseException e) {
                throw new BadRequestException(String.format("Problem occurred while parsing request to create model in experiment '%s'. Error: %s", experimentName, e.getMessage()));
            }
        });
    }

    @PUT
    @Path(value="/experiments/{experiment-name}/models/{model-id}/directives")
    public void setModelDirectives(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        this.runInTx(responder, store -> {
            DirectivesRequest directives = (DirectivesRequest)GSON.fromJson(Bytes.toString((ByteBuffer)request.getContent()), DirectivesRequest.class);
            if (directives == null) {
                throw new BadRequestException("A request body must be provided containing the directives.");
            }
            directives.validate();
            store.setModelDirectives(new ModelKey(experimentName, modelId), directives.getDirectives());
            responder.sendStatus(200);
        });
    }

    @POST
    @Path(value="/experiments/{experiment-name}/models/{model-id}/split")
    public void createModelSplit(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        DataSplitInfo dataSplitInfo = this.callInTx(responder, store -> {
            try {
                ModelKey modelKey = new ModelKey(experimentName, modelId);
                DataSplit splitInfo = (DataSplit)GSON.fromJson(Bytes.toString((ByteBuffer)request.getContent()), DataSplit.class);
                if (splitInfo == null) {
                    throw new BadRequestException("A request body must be provided containing split parameters.");
                }
                if (splitInfo.getDirectives().isEmpty()) {
                    ModelMeta modelMeta = store.getModel(modelKey);
                    splitInfo = new DataSplit(splitInfo.getDescription(), splitInfo.getType(), splitInfo.getParams(), modelMeta.getDirectives(), splitInfo.getSchema());
                }
                splitInfo.validate();
                DataSplitInfo info = store.addSplit(experimentName, splitInfo, System.currentTimeMillis());
                store.setModelSplit(modelKey, info.getSplitId());
                return info;
            }
            catch (JsonParseException e) {
                throw new BadRequestException(String.format("Problem occurred while parsing request for split creation for experiment '%s'. Error: %s", experimentName, e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e.getMessage());
            }
        });
        if (dataSplitInfo == null) {
            return;
        }
        this.addSplit(dataSplitInfo);
        responder.sendStatus(200);
    }

    @DELETE
    @Path(value="/experiments/{experiment-name}/models/{model-id}/split")
    public void unassignModelSplit(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        this.runInTx(responder, store -> {
            store.unassignModelSplit(new ModelKey(experimentName, modelId));
            responder.sendStatus(200);
        });
    }

    @POST
    @Path(value="/experiments/{experiment-name}/models/{model-id}/train")
    public void trainModel(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        ModelTrainerInfo trainerInfo = this.callInTx(responder, store -> {
            try {
                TrainModelRequest trainRequest = (TrainModelRequest)GSON.fromJson(Bytes.toString((ByteBuffer)request.getContent()), TrainModelRequest.class);
                if (trainRequest == null) {
                    throw new BadRequestException("A request body must be provided containing training parameters.");
                }
                trainRequest.validate();
                ModelKey modelKey = new ModelKey(experimentName, modelId);
                return store.trainModel(modelKey, trainRequest, System.currentTimeMillis());
            }
            catch (JsonParseException e) {
                throw new BadRequestException(String.format("Problem occurred while parsing request for model training for experiment '%s'. Error: %s", experimentName, e.getMessage()));
            }
        });
        if (trainerInfo == null) {
            return;
        }
        ModelKey modelKey = new ModelKey(trainerInfo.getExperiment().getName(), trainerInfo.getModelId());
        new Thread(() -> {
            ModelLogging.start((String)modelKey.getExperiment(), (String)modelKey.getModel());
            Schema schema = trainerInfo.getDataSplitStats().getSchema();
            ModelTrainer modelTrainer = new ModelTrainer(trainerInfo);
            StructType sparkSchema = (StructType)DataFrames.toDataType((Schema)schema);
            try {
                Dataset rawTraining = this.sparkSession.read().format("parquet").schema(sparkSchema).load(trainerInfo.getDataSplitStats().getTrainingPath());
                Dataset rawTest = this.sparkSession.read().format("parquet").schema(sparkSchema).load(trainerInfo.getDataSplitStats().getTestPath());
                ModelOutput modelOutput = modelTrainer.train(rawTraining, rawTest);
                this.modelOutputWriter.save(modelKey, modelOutput, trainerInfo.getModel().getPredictionsDataset());
                this.runInTx(store -> store.updateModelMetrics(modelKey, modelOutput.getEvaluationMetrics(), System.currentTimeMillis(), modelOutput.getCategoricalFeatures()));
            }
            catch (Throwable e) {
                LOG.error("Error training model {} in experiment {}.", new Object[]{modelKey.getModel(), modelKey.getExperiment(), e});
                try {
                    this.runInTx(store -> store.modelFailed(modelKey));
                }
                catch (TransactionFailureException te) {
                    LOG.error("Error marking model {} in experiment {} as failed", new Object[]{modelKey.getModel(), modelKey.getExperiment(), te});
                }
                try {
                    this.modelOutputWriter.deleteComponents(modelKey);
                }
                catch (IOException e1) {
                    LOG.error("Error during cleanup after model {} in experiment {} failed to train.", new Object[]{modelKey.getModel(), modelKey.getExperiment(), e1});
                }
            }
            finally {
                ModelLogging.finish();
            }
        }).start();
        responder.sendStatus(200);
    }

    @DELETE
    @Path(value="/experiments/{experiment-name}/models/{model-id}")
    public void deleteModel(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        ModelKey modelKey = new ModelKey(experimentName, modelId);
        this.runInTx(responder, store -> {
            store.deleteModel(modelKey);
            responder.sendStatus(200);
        });
    }

    @POST
    @Path(value="/experiments/{experiment-name}/models/{model-id}/deploy")
    public void deployModel(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="model-id") String modelId) {
        ModelKey key = new ModelKey(experimentName, modelId);
        this.runInTx(responder, store -> {
            store.deployModel(key);
            responder.sendStatus(200);
        });
    }

    @GET
    @Path(value="/experiments/{experiment-name}/splits")
    public void listSplits(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName) {
        this.runInTx(responder, store -> responder.sendString(GSON.toJson((Object)store.listSplits(experimentName))));
    }

    @POST
    @Path(value="/experiments/{experiment-name}/splits")
    public void addSplit(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName) {
        DataSplitInfo dataSplitInfo = this.callInTx(responder, store -> {
            try {
                DataSplit splitInfo = (DataSplit)GSON.fromJson(Bytes.toString((ByteBuffer)request.getContent()), DataSplit.class);
                if (splitInfo == null) {
                    throw new BadRequestException("A request body must be provided containing split parameters.");
                }
                splitInfo.validate();
                return store.addSplit(experimentName, splitInfo, System.currentTimeMillis());
            }
            catch (JsonParseException e) {
                throw new BadRequestException(String.format("Problem occurred while parsing request for split creation for experiment '%s'. Error: %s", experimentName, e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e.getMessage());
            }
        });
        if (dataSplitInfo == null) {
            return;
        }
        this.addSplit(dataSplitInfo);
        responder.sendString(GSON.toJson((Object)new Id(dataSplitInfo.getSplitId())));
    }

    @GET
    @Path(value="/experiments/{experiment-name}/splits/{split-id}")
    public void getSplit(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="split-id") String splitId) {
        SplitKey key = new SplitKey(experimentName, splitId);
        this.runInTx(responder, store -> responder.sendString(GSON.toJson((Object)store.getSplit(key))));
    }

    @GET
    @Path(value="/experiments/{experiment-name}/splits/{split-id}/status")
    public void getSplitStatus(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="split-id") String splitId) {
        SplitKey key = new SplitKey(experimentName, splitId);
        this.runInTx(responder, store -> {
            DataSplitStats stats = store.getSplit(key);
            responder.sendString(GSON.toJson((Object)stats.getStatus()));
        });
    }

    @DELETE
    @Path(value="/experiments/{experiment-name}/splits/{split-id}")
    public void deleteSplit(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="experiment-name") String experimentName, @PathParam(value="split-id") String splitId) {
        SplitKey key = new SplitKey(experimentName, splitId);
        this.runInTx(responder, store -> {
            store.deleteSplit(key);
            responder.sendStatus(200);
        });
    }

    private void runInTx(Consumer<ExperimentStore> consumer) throws TransactionFailureException {
        this.context.execute(datasetContext -> {
            IndexedTable modelMeta = (IndexedTable)datasetContext.getDataset(this.modelMetaDataset);
            IndexedTable experiments = (IndexedTable)datasetContext.getDataset(this.experimentMetaDataset);
            PartitionedFileSet splits = (PartitionedFileSet)datasetContext.getDataset(this.splitsDataset);
            ExperimentStore store = new ExperimentStore(new ExperimentMetaTable(experiments), new DataSplitTable(splits), new ModelTable(modelMeta));
            consumer.accept(store);
        });
    }

    private void runInTx(HttpServiceResponder responder, Consumer<ExperimentStore> consumer) {
        try {
            this.context.execute(datasetContext -> {
                IndexedTable modelMeta = (IndexedTable)datasetContext.getDataset(this.modelMetaDataset);
                IndexedTable experiments = (IndexedTable)datasetContext.getDataset(this.experimentMetaDataset);
                PartitionedFileSet splits = (PartitionedFileSet)datasetContext.getDataset(this.splitsDataset);
                ExperimentStore store = new ExperimentStore(new ExperimentMetaTable(experiments), new DataSplitTable(splits), new ModelTable(modelMeta));
                try {
                    consumer.accept(store);
                }
                catch (EndpointException e) {
                    responder.sendError(e.getCode(), e.getMessage());
                }
            });
        }
        catch (TransactionFailureException e) {
            LOG.error("Transaction failure during service call", (Throwable)e);
            responder.sendError(500, e.getMessage());
        }
    }

    private <T> T callInTx(HttpServiceResponder responder, Function<ExperimentStore, T> function) {
        AtomicReference ref = new AtomicReference();
        this.runInTx(responder, store -> ref.set(function.apply((ExperimentStore)store)));
        return (T)ref.get();
    }

    private void addSplit(DataSplitInfo dataSplitInfo) {
        String experimentName = dataSplitInfo.getExperiment().getName();
        String splitId = dataSplitInfo.getSplitId();
        SplitKey splitKey = new SplitKey(experimentName, splitId);
        new Thread(() -> {
            SplitLogging.start((String)experimentName, (String)splitId);
            DatasetSplitter datasetSplitter = Splitters.getSplitter((String)dataSplitInfo.getDataSplit().getType());
            try (DataSplitStatsGenerator splitStatsGenerator = new DataSplitStatsGenerator(this.sparkSession, datasetSplitter, this.context.getPluginContext(), this.context.getServiceDiscoverer());){
                DataSplitResult result = splitStatsGenerator.split(dataSplitInfo);
                this.runInTx(store -> store.finishSplit(splitKey, result.getTrainingPath(), result.getTestPath(), result.getStats(), System.currentTimeMillis()));
            }
            catch (Exception e) {
                LOG.error("Error generating split {} in experiment {}.", new Object[]{splitId, experimentName, e});
                try {
                    this.runInTx(store -> store.splitFailed(splitKey, System.currentTimeMillis()));
                }
                catch (TransactionFailureException te) {
                    LOG.error("Error marking split {} in experiment {} as failed", new Object[]{splitId, experimentName, te});
                }
            }
            finally {
                SplitLogging.finish();
            }
        }).start();
    }
}

