/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.manager;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.Config;
import io.cdap.cdap.api.app.AbstractApplication;
import io.cdap.cdap.api.dataset.DatasetProperties;
import io.cdap.cdap.api.dataset.lib.FileSet;
import io.cdap.cdap.api.dataset.lib.IndexedTable;
import io.cdap.cdap.api.dataset.lib.PartitionedFileSet;
import io.cdap.cdap.api.spark.Spark;
import io.cdap.mmds.data.DataSplitTable;
import io.cdap.mmds.data.ExperimentMetaTable;
import io.cdap.mmds.data.ModelTable;
import io.cdap.mmds.manager.ModelManagerService;

public class ModelPrepApp
extends AbstractApplication<Conf> {
    private static final String NAME = "ModelManagementApp";
    private static final String DESCRIPTION = "Model Management App";

    public void configure() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
        Conf conf = (Conf)this.getConfig();
        String modelMetaName = conf.getModelMetaDataset();
        String modelComponentsName = conf.getModelComponentDataset();
        String experimentMetaName = conf.getExperimentMetaDataset();
        String splitsName = conf.getSplitsDataset();
        this.createDataset(experimentMetaName, IndexedTable.class, ExperimentMetaTable.DATASET_PROPERTIES);
        this.createDataset(modelMetaName, IndexedTable.class, ModelTable.DATASET_PROPERTIES);
        this.createDataset(modelComponentsName, FileSet.class, DatasetProperties.EMPTY);
        this.createDataset(splitsName, PartitionedFileSet.class, DataSplitTable.DATASET_PROPERTIES);
        this.addSpark((Spark)new ModelManagerService(modelMetaName, modelComponentsName, experimentMetaName, splitsName));
    }

    public static class Conf
    extends Config {
        private String modelMetaDataset;
        private String modelComponentsDataset;
        private String experimentMetaDataset;
        private String splitsDataset;

        public Conf() {
            this("experiment_model_meta", "experiment_model_components", "experiment_meta", "experiment_splits");
        }

        @VisibleForTesting
        public Conf(String modelMetaDataset, String modelComponentsDataset, String experimentMetaDataset, String splitsDataset) {
            this.modelMetaDataset = modelMetaDataset;
            this.modelComponentsDataset = modelComponentsDataset;
            this.experimentMetaDataset = experimentMetaDataset;
            this.splitsDataset = splitsDataset;
        }

        public String getModelMetaDataset() {
            return this.modelMetaDataset;
        }

        public String getModelComponentDataset() {
            return this.modelComponentsDataset;
        }

        public String getExperimentMetaDataset() {
            return this.experimentMetaDataset;
        }

        public String getSplitsDataset() {
            return this.splitsDataset;
        }
    }
}

