/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.manager;

import com.google.common.collect.ImmutableList;
import io.cdap.cdap.api.ServiceDiscoverer;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginContext;
import io.cdap.cdap.api.spark.sql.DataFrames;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.InvalidEntry;
import io.cdap.cdap.etl.api.Transform;
import io.cdap.cdap.etl.api.TransformContext;
import io.cdap.mmds.manager.WranglerContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public class WranglerFunction
implements FlatMapFunction<Row, Row> {
    private static final Schema TEXT_SCHEMA = Schema.recordOf((String)"textRecord", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"body", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING)))});
    private final PluginContext pluginContext;
    private final Schema schema;
    private final ServiceDiscoverer serviceDiscoverer;
    private transient TranslatingEmitter emitter;
    private transient Transform<StructuredRecord, StructuredRecord> wrangler;

    public WranglerFunction(Schema schema, PluginContext pluginContext, ServiceDiscoverer serviceDiscoverer) {
        this.schema = schema;
        this.pluginContext = pluginContext;
        this.serviceDiscoverer = serviceDiscoverer;
    }

    public Iterator<Row> call(Row input) throws Exception {
        if (this.wrangler == null) {
            WranglerContext context = new WranglerContext(this.pluginContext, this.serviceDiscoverer);
            this.wrangler = (Transform)this.pluginContext.newPluginInstance("wrangler");
            this.wrangler.initialize((TransformContext)context);
            this.emitter = new TranslatingEmitter((StructType)DataFrames.toDataType((Schema)this.schema));
        }
        StructuredRecord record = StructuredRecord.builder((Schema)TEXT_SCHEMA).set("body", input.get(0)).build();
        this.emitter.reset();
        this.wrangler.transform((Object)record, (Emitter)this.emitter);
        return this.emitter.getRecords().iterator();
    }

    private static class TranslatingEmitter
    implements Emitter<StructuredRecord> {
        private final List<Row> outputRecords;
        private final StructType sparkSchema;

        private TranslatingEmitter(StructType sparkSchema) {
            this.sparkSchema = sparkSchema;
            this.outputRecords = new ArrayList<Row>();
        }

        public void emit(StructuredRecord record) {
            this.outputRecords.add(DataFrames.toRow((StructuredRecord)record, (StructType)this.sparkSchema));
        }

        public void emitAlert(Map<String, String> map) {
        }

        public void emitError(InvalidEntry<StructuredRecord> invalidEntry) {
        }

        private void reset() {
            this.outputRecords.clear();
        }

        private List<Row> getRecords() {
            return ImmutableList.copyOf(this.outputRecords);
        }
    }
}

