/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.action;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.RetryOption;
import com.google.cloud.StringEnumValue;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.etl.api.action.ActionContext;
import io.cdap.plugin.gcp.bigquery.action.AbstractBigQueryAction;
import io.cdap.plugin.gcp.bigquery.action.AbstractBigQueryActionConfig;
import io.cdap.plugin.gcp.bigquery.action.BigQueryArgumentSetterConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="action")
@Name(value="BigQueryArgumentSetter")
@Description(value="Argument setter for dynamically configuring pipeline from BiqQuery table.")
public final class BigQueryArgumentSetter
extends AbstractBigQueryAction {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryArgumentSetter.class);
    public static final String NAME = "BigQueryArgumentSetter";
    private static final Set<LegacySQLTypeName> SUPPORTED_SQL_TYPES = ImmutableSet.of((Object)LegacySQLTypeName.BOOLEAN, (Object)LegacySQLTypeName.STRING, (Object)LegacySQLTypeName.FLOAT, (Object)LegacySQLTypeName.INTEGER, (Object)LegacySQLTypeName.NUMERIC, (Object)LegacySQLTypeName.TIMESTAMP, (Object[])new LegacySQLTypeName[0]);
    private BigQueryArgumentSetterConfig config;

    @Override
    public AbstractBigQueryActionConfig getConfig() {
        return this.config;
    }

    public void run(ActionContext context) throws Exception {
        this.config.validate(context.getFailureCollector());
        QueryJobConfiguration queryConfig = this.config.getQueryJobConfiguration(context.getFailureCollector());
        JobId jobId = JobId.newBuilder().setRandomJob().build();
        GoogleCredentials credentials = this.config.getServiceAccount() == null ? null : GCPUtils.loadServiceAccountCredentials(this.config.getServiceAccount(), this.config.isServiceAccountFilePath());
        BigQuery bigQuery = GCPUtils.getBigQuery(this.config.getProject(), credentials);
        Job queryJob = bigQuery.create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
        LOG.info("Executing SQL as job {}.", (Object)jobId.getJob());
        LOG.debug("The BigQuery SQL  {}", (Object)queryConfig.getQuery());
        queryJob.waitFor(new RetryOption[0]);
        if (queryJob.getStatus().getError() != null) {
            throw new RuntimeException(queryJob.getStatus().getExecutionErrors().toString());
        }
        TableResult queryResults = queryJob.getQueryResults(new BigQuery.QueryResultsOption[0]);
        if (queryResults.getTotalRows() == 0L || queryResults.getTotalRows() > 1L) {
            throw new RuntimeException(String.format("The query result total rows should be \"1\" but is \"%d\"", queryResults.getTotalRows()));
        }
        Schema schema = queryResults.getSchema();
        FieldValueList row = (FieldValueList)queryResults.iterateAll().iterator().next();
        for (int i = 0; i < schema.getFields().size(); ++i) {
            Field field = schema.getFields().get(i);
            if (!SUPPORTED_SQL_TYPES.contains(field.getType())) {
                context.getFailureCollector().addFailure(String.format("Field '%s'  with type '%s' , is not supported.", field.getName(), field.getType().name()), String.format("Supported types are: %s", SUPPORTED_SQL_TYPES.stream().map(StringEnumValue::name).collect(Collectors.joining(","))));
                context.getFailureCollector().getOrThrowException();
            }
            String name = field.getName();
            FieldValue fieldValue = row.get(name);
            context.getArguments().set(name, fieldValue.getStringValue());
        }
    }
}

