/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.action;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.gcp.bigquery.action.AbstractBigQueryActionConfig;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class BigQueryArgumentSetterConfig
extends AbstractBigQueryActionConfig {
    public static final String NAME_DATASET = "dataset";
    public static final String NAME_TABLE = "table";
    public static final String NAME_DATASET_PROJECT = "datasetProject";
    public static final String NAME_ARGUMENT_SELECTION_CONDITIONS = "argumentSelectionConditions";
    public static final String NAME_ARGUMENTS_COLUMNS = "argumentsColumns";
    private static final String QUERY_TEMPLATE = "Select %s from %s where %s";
    @Name(value="dataset")
    @Macro
    @Description(value="The dataset the table belongs to. A dataset is contained within a specific project. Datasets are top-level containers that are used to organize and control access to tables and views.")
    private String dataset;
    @Name(value="table")
    @Macro
    @Description(value="The table to read from. A table contains individual records organized in rows. Each record is composed of columns (also called fields). Every table is defined by a schema that describes the column names, data types, and other information.")
    private String table;
    @Name(value="argumentSelectionConditions")
    @Macro
    @Description(value="A set of conditions for identifying the arguments to run a pipeline.A particular use case for this would be feed=marketing;date=20200427.")
    private String argumentSelectionConditions;
    @Name(value="argumentsColumns")
    @Macro
    @Description(value="Name of the columns, separated by `,` ,that contains the arguments for this run.A particular use case for this would be country, device")
    private String argumentsColumns;

    private BigQueryArgumentSetterConfig(String datasetProject, String dataset, String table, String argumentSelectionConditions, String argumentsColumns) {
        this.datasetProject = datasetProject;
        this.dataset = dataset;
        this.table = table;
        this.argumentSelectionConditions = argumentSelectionConditions;
        this.argumentsColumns = argumentsColumns;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTable() {
        return this.table;
    }

    public String getArgumentSelectionConditions() {
        return this.argumentSelectionConditions;
    }

    @Nullable
    public String getArgumentsColumns() {
        return this.argumentsColumns;
    }

    @Override
    public void validate(FailureCollector collector) {
        this.validateProperties(collector);
        if (this.canConnect()) {
            this.getQueryJobConfiguration(collector);
        }
    }

    public void validateProperties(FailureCollector collector) {
        if (!this.containsMacro(NAME_DATASET)) {
            BigQueryUtil.validateDataset(this.dataset, NAME_DATASET, collector);
        }
        if (!this.containsMacro(NAME_TABLE)) {
            BigQueryUtil.validateTable(this.table, NAME_TABLE, collector);
        }
        this.validateArgumentsSelectionConditions(this.getArgumentSelectionConditions(), collector);
        this.validateArgumentsColumns(this.argumentsColumns, collector);
        collector.getOrThrowException();
    }

    private boolean canConnect() {
        return !this.containsMacro(NAME_DATASET) && !this.containsMacro(NAME_TABLE) && !this.containsMacro(NAME_DATASET_PROJECT) && !this.containsMacro("serviceAccountType") && !this.containsMacro("serviceFilePath") && !this.containsMacro("serviceAccountJSON") && !this.containsMacro("project") && !this.containsMacro(NAME_ARGUMENT_SELECTION_CONDITIONS) && !this.containsMacro(this.argumentsColumns);
    }

    private void validateArgumentsSelectionConditions(String argumentSelectionConditions, FailureCollector collector) {
        if (this.containsMacro(NAME_ARGUMENT_SELECTION_CONDITIONS)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)argumentSelectionConditions)) {
            collector.addFailure("Arguments Selection Conditions is empty.", "Arguments Selection condition can not be empty.").withConfigProperty(NAME_ARGUMENT_SELECTION_CONDITIONS);
            return;
        }
        try {
            this.getArgumentSelectionConditionsMap();
        }
        catch (Exception e) {
            collector.addFailure(e.getMessage(), "Invalid key value pair for Argument Selection Conditions.").withConfigProperty(NAME_ARGUMENT_SELECTION_CONDITIONS);
        }
    }

    private void validateArgumentsColumns(String argumentsColumns, FailureCollector collector) {
        if (this.containsMacro(NAME_ARGUMENTS_COLUMNS)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)argumentsColumns)) {
            collector.addFailure("Arguments Columns is empty.", "Arguments Columns can not be empty.").withConfigProperty(NAME_ARGUMENTS_COLUMNS);
        }
    }

    public QueryJobConfiguration getQueryJobConfiguration(FailureCollector collector) {
        Table sourceTable = BigQueryUtil.getBigQueryTable(this.getDatasetProject(), this.dataset, this.table, this.getServiceAccount(), this.isServiceAccountFilePath(), collector);
        if (sourceTable == null) {
            collector.addFailure(String.format("BigQuery table '%s:%s.%s' does not exist.", this.getDatasetProject(), this.dataset, this.table), "Ensure correct table name is provided.").withConfigProperty(NAME_TABLE);
            throw collector.getOrThrowException();
        }
        StandardTableDefinition tableDefinition = (StandardTableDefinition)Objects.requireNonNull(sourceTable).getDefinition();
        FieldList fields = Objects.requireNonNull(tableDefinition.getSchema()).getFields();
        Map<String, String> argumentConditionMap = this.getArgumentSelectionConditionsMap();
        Map<String, Field> argumentConditionFields = this.extractArgumentsFields(fields, argumentConditionMap);
        this.checkIfArgumentsColumnsExitsInSource(argumentConditionMap, argumentConditionFields);
        String selectClause = this.getSelectClause();
        String whereCondition = this.getWhereCondition(argumentConditionMap.keySet());
        String tableName = this.dataset + "." + this.table;
        String query = String.format(QUERY_TEMPLATE, selectClause, tableName, whereCondition);
        QueryJobConfiguration.Builder queryJobConfiguration = QueryJobConfiguration.newBuilder((String)query);
        this.getParametersValues(argumentConditionMap.entrySet(), argumentConditionFields).forEach(stringQueryParameterValueSimpleEntry -> queryJobConfiguration.addNamedParameter((String)stringQueryParameterValueSimpleEntry.getKey(), (QueryParameterValue)stringQueryParameterValueSimpleEntry.getValue()));
        return queryJobConfiguration.build();
    }

    private void checkIfArgumentsColumnsExitsInSource(Map<String, String> argumentConditionMap, Map<String, Field> argumentConditionFields) {
        if (argumentConditionMap.size() == argumentConditionFields.size()) {
            return;
        }
        String nonExistingColumnNames = argumentConditionMap.keySet().stream().filter(columnName -> !argumentConditionFields.containsKey(columnName)).collect(Collectors.joining(" ,"));
        throw new RuntimeException(String.format("Columns: \" %s \"do not exist in table. Argument selections columns must exist in table.", nonExistingColumnNames));
    }

    private Map<String, Field> extractArgumentsFields(FieldList fields, Map<String, String> argumentConditionKeyPair) {
        return fields.stream().filter(field -> argumentConditionKeyPair.containsKey(field.getName())).collect(Collectors.toMap(Field::getName, Function.identity()));
    }

    private String getSelectClause() {
        return String.join((CharSequence)" ,", this.getArgumentsColumnsList());
    }

    private List<AbstractMap.SimpleEntry<String, QueryParameterValue>> getParametersValues(Set<Map.Entry<String, String>> argumentConditionKeyPair, Map<String, Field> argumentConditionFields) {
        return argumentConditionKeyPair.stream().map(entry -> {
            Field field = (Field)argumentConditionFields.get(entry.getKey());
            String value = (String)entry.getValue();
            QueryParameterValue build = QueryParameterValue.newBuilder().setType(field.getType().getStandardType()).setValue(value).build();
            return new AbstractMap.SimpleEntry(entry.getKey(), build);
        }).collect(Collectors.toList());
    }

    private String getWhereCondition(Set<String> argumentConditionKey) {
        return argumentConditionKey.stream().map(columnName -> String.format("%s = @%s ", columnName, columnName)).collect(Collectors.joining(" AND "));
    }

    private Map<String, String> getArgumentSelectionConditionsMap() {
        return ConfigUtil.parseKeyValueConfig((String)this.argumentSelectionConditions, (String)";", (String)"=");
    }

    private List<String> getArgumentsColumnsList() {
        Object[] parts = this.getArgumentsColumns().split(",");
        return Lists.newArrayList((Object[])parts);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String dataset;
        private String datasetProject;
        private String table;
        private String argumentSelectionConditions;
        private String argumentsColumns;

        private Builder() {
        }

        public Builder setDatasetProject(String datasetProject) {
            this.datasetProject = datasetProject;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setArgumentSelectionConditions(String argumentSelectionConditions) {
            this.argumentSelectionConditions = argumentSelectionConditions;
            return this;
        }

        public Builder setArgumentsColumns(String argumentsColumns) {
            this.argumentsColumns = argumentsColumns;
            return this;
        }

        public BigQueryArgumentSetterConfig build() {
            return new BigQueryArgumentSetterConfig(this.datasetProject, this.dataset, this.table, this.argumentSelectionConditions, this.argumentsColumns);
        }
    }
}

