/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.common;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.bigquery.connector.BigQueryConnectorConfig;
import io.cdap.plugin.gcp.common.CmekUtils;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import java.io.IOException;
import javax.annotation.Nullable;

public class BigQueryBaseConfig
extends PluginConfig {
    private static final String SCHEME = "gs://";
    public static final String NAME_DATASET = "dataset";
    public static final String NAME_BUCKET = "bucket";
    public static final String NAME_CMEK_KEY = "cmekKey";
    @Name(value="dataset")
    @Macro
    @Description(value="The dataset to write to. A dataset is contained within a specific project. Datasets are top-level containers that are used to organize and control access to tables and views.")
    public String dataset;
    @Name(value="bucket")
    @Macro
    @Nullable
    @Description(value="The Google Cloud Storage bucket to store temporary data in. Cloud Storage data will be deleted after it is loaded into BigQuery. If it is not provided, a unique bucket will be automatically created and then deleted after the run finishes. The service account must have permission to create buckets in the configured project.")
    public String bucket;
    @Name(value="cmekKey")
    @Macro
    @Nullable
    @Description(value="The GCP customer managed encryption key (CMEK) name used to encrypt data written to any bucket, dataset or table created by the plugin. If the bucket, dataset or table already exists, this is ignored. More information can be found at https://cloud.google.com/data-fusion/docs/how-to/customer-managed-encryption-keys")
    public String cmekKey;
    @Name(value="useConnection")
    @Nullable
    @Description(value="Whether to use an existing connection.")
    public Boolean useConnection;
    @Name(value="connection")
    @Macro
    @Nullable
    @Description(value="The existing connection to use.")
    public BigQueryConnectorConfig connection;

    public BigQueryBaseConfig(BigQueryConnectorConfig connection, String dataset, String cmekKey, String bucket) {
        this.connection = connection;
        this.dataset = dataset;
        this.cmekKey = cmekKey;
        this.bucket = bucket;
    }

    @Nullable
    public BigQueryConnectorConfig getConnection() {
        return this.connection;
    }

    public boolean autoServiceAccountUnavailable() {
        if (this.connection == null || this.connection.getServiceAccountFilePath() == null && this.connection.isServiceAccountFilePath().booleanValue()) {
            try {
                ServiceAccountCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public String getProject() {
        if (this.connection == null) {
            throw new IllegalArgumentException("Could not get project information, connection should not be null!");
        }
        return this.connection.getProject();
    }

    @Nullable
    public String tryGetProject() {
        return this.connection == null ? null : this.connection.tryGetProject();
    }

    @Nullable
    public String getServiceAccount() {
        return this.connection == null ? null : this.connection.getServiceAccount();
    }

    @Nullable
    public String getServiceAccountFilePath() {
        return this.connection == null ? null : this.connection.getServiceAccountFilePath();
    }

    @Nullable
    public Boolean isServiceAccountJson() {
        return this.connection == null ? null : this.connection.isServiceAccountJson();
    }

    @Nullable
    public String getServiceAccountJson() {
        return this.connection == null ? null : this.connection.getServiceAccountJson();
    }

    @Nullable
    public Boolean isServiceAccountFilePath() {
        return this.connection == null ? null : this.connection.isServiceAccountFilePath();
    }

    @Nullable
    public String getServiceAccountType() {
        return this.connection == null ? null : this.connection.getServiceAccountType();
    }

    @Nullable
    public String getDataset() {
        return this.dataset;
    }

    @Nullable
    public String getCmekKey() {
        return this.cmekKey;
    }

    @Nullable
    public String getBucket() {
        if (this.bucket != null) {
            this.bucket = this.bucket.trim();
            if (this.bucket.isEmpty()) {
                return null;
            }
            if (this.bucket.startsWith(SCHEME)) {
                this.bucket = this.bucket.substring(SCHEME.length());
            }
        }
        return this.bucket;
    }

    @Nullable
    private Bucket getBucketIfExists(Storage storage, String bucketName) {
        Bucket bucket = null;
        try {
            bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
        }
        catch (StorageException storageException) {
            // empty catch block
        }
        return bucket;
    }

    public void validateCmekKeyLocation(@Nullable CryptoKeyName cmekKeyName, @Nullable String tableName, @Nullable String location, FailureCollector failureCollector) {
        if (cmekKeyName == null || this.containsMacro(NAME_DATASET) || this.connection == null || !this.connection.canConnect() || this.containsMacro(NAME_BUCKET)) {
            return;
        }
        String datasetProjectId = this.connection.getDatasetProject();
        String datasetName = this.getDataset();
        DatasetId datasetId = DatasetId.of((String)datasetProjectId, (String)datasetName);
        TableId tableId = tableName == null ? null : TableId.of((String)datasetProjectId, (String)datasetName, (String)tableName);
        Credentials credentials = this.connection.getCredentials(failureCollector);
        BigQuery bigQuery = GCPUtils.getBigQuery(this.connection.getProject(), credentials);
        Storage storage = GCPUtils.getStorage(this.connection.getProject(), credentials);
        if (bigQuery == null || storage == null) {
            return;
        }
        String bucketName = this.getBucket();
        Bucket bucket = bucketName == null ? null : this.getBucketIfExists(storage, bucketName);
        location = bucket == null ? location : bucket.getLocation();
        Dataset dataset = CmekUtils.validateCmekKeyAndDatasetOrTableLocation(bigQuery, datasetId, tableId, cmekKeyName, location, failureCollector);
        if (bucket == null && dataset != null) {
            location = dataset.getLocation();
            GCSPath gcsPath = Strings.isNullOrEmpty((String)bucketName) ? null : GCSPath.from(bucketName);
            CmekUtils.validateCmekKeyAndBucketLocation(storage, gcsPath, cmekKeyName, location, failureCollector);
        }
    }
}

