/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.connector;

import com.google.cloud.ServiceOptions;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import javax.annotation.Nullable;

public class BigQueryConnectorConfig
extends GCPConnectorConfig {
    public static final String NAME_DATASET_PROJECT = "datasetProject";
    @Name(value="datasetProject")
    @Macro
    @Nullable
    @Description(value="The project the dataset belongs to. This is only required if the dataset is not in the same project that the BigQuery job will run in. If no value is given, it will default to the configured project ID.")
    private String datasetProject;

    public String getDatasetProject() {
        if ("auto-detect".equalsIgnoreCase(this.datasetProject)) {
            String defaultProject = ServiceOptions.getDefaultProjectId();
            if (defaultProject == null) {
                throw new IllegalArgumentException("Could not detect Google Cloud project id from the environment. Please specify a dataset project id.");
            }
            return defaultProject;
        }
        return Strings.isNullOrEmpty((String)this.datasetProject) ? this.getProject() : this.datasetProject;
    }

    @Override
    public boolean canConnect() {
        return super.canConnect() && !this.containsMacro(NAME_DATASET_PROJECT);
    }

    public BigQueryConnectorConfig(@Nullable String project, @Nullable String datasetProject, @Nullable String serviceAccountType, @Nullable String serviceFilePath, @Nullable String serviceAccountJson) {
        super(project, serviceAccountType, serviceFilePath, serviceAccountJson);
        this.datasetProject = datasetProject;
    }
}

