/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.connector;

import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class BigQueryPath {
    private String dataset;
    private String table;
    private static final int NAME_MAX_LENGTH = 1024;
    private static final Pattern VALID_DATASET_NAME_REGEX = Pattern.compile("[\\w]+");
    private static final Pattern VALID_TABLE_NAME_REGEX = Pattern.compile("[\\p{L}\\p{M}\\p{N}\\p{Pc}\\p{Pd}\\p{Zs}]+");

    public BigQueryPath(String path) {
        this.parsePath(path);
    }

    private void parsePath(String path) {
        String[] parts;
        if (path == null) {
            throw new IllegalArgumentException("Path should not be null.");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.isEmpty()) {
            return;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((parts = path.split("/", -1)).length > 2) {
            throw new IllegalArgumentException("Path should at most contain two parts.");
        }
        this.dataset = parts[0];
        this.validateDatasetName(this.dataset);
        if (parts.length == 2) {
            this.table = parts[1];
            this.validateTableName(this.table);
        }
    }

    private void validateDatasetName(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Dataset should not be empty.");
        }
        if (name.length() > 1024) {
            throw new IllegalArgumentException(String.format("Dataset is invalid, it should contain at most %d characters.", 1024));
        }
        if (!VALID_DATASET_NAME_REGEX.matcher(name).matches()) {
            throw new IllegalArgumentException("Dataset is invalid, it should contain only letters, numbers, and underscores.");
        }
    }

    private void validateTableName(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Table should not be empty.");
        }
        if (name.length() > 1024) {
            throw new IllegalArgumentException(String.format("Table is invalid, it should contain at most %d characters.", 1024));
        }
        if (!VALID_TABLE_NAME_REGEX.matcher(name).matches()) {
            throw new IllegalArgumentException("Table is invalid, it should only contain Unicode characters in category L (letter), M (mark), N (number), Pc (connector, including underscore), Pd (dash), Zs (space).");
        }
    }

    @Nullable
    public String getDataset() {
        return this.dataset;
    }

    @Nullable
    public String getTable() {
        return this.table;
    }
}

