/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.relational;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.feature.FeatureFlagsProvider;
import io.cdap.cdap.etl.api.aggregation.AggregationDefinition;
import io.cdap.cdap.etl.api.aggregation.DeduplicateAggregationDefinition;
import io.cdap.cdap.etl.api.aggregation.GroupByAggregationDefinition;
import io.cdap.cdap.etl.api.aggregation.WindowAggregationDefinition;
import io.cdap.cdap.etl.api.engine.sql.SQLEngineException;
import io.cdap.cdap.etl.api.relational.Expression;
import io.cdap.cdap.etl.api.relational.InvalidRelation;
import io.cdap.cdap.etl.api.relational.Relation;
import io.cdap.cdap.features.Feature;
import io.cdap.plugin.gcp.bigquery.relational.SQLExpression;
import io.cdap.plugin.gcp.bigquery.relational.SQLExpressionFactory;
import io.cdap.plugin.gcp.bigquery.sqlengine.BigQuerySQLDataset;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryDeduplicateSQLBuilder;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryGroupBySQLBuilder;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryNestedSelectSQLBuilder;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQuerySelectSQLBuilder;
import io.cdap.plugin.gcp.bigquery.sqlengine.builder.BigQueryWindowsAggregationSQLBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.parquet.Strings;

public class BigQueryRelation
implements Relation {
    private static final SQLExpressionFactory factory = new SQLExpressionFactory();
    private final FeatureFlagsProvider featureFlagsProvider;
    private final String datasetName;
    private final Set<String> columns;
    private final BigQueryRelation parent;
    private final Supplier<String> sqlStatementSupplier;
    private final Schema schema;
    private Map<String, BigQuerySQLDataset> sourceDatasets;

    public static BigQueryRelation getInstance(String datasetName, Set<String> columnNames, FeatureFlagsProvider featureFlagsProvider) {
        return new BigQueryRelation(datasetName, columnNames, featureFlagsProvider);
    }

    public static BigQueryRelation getInstance(String datasetName, Set<String> columnNames, FeatureFlagsProvider featureFlagsProvider, @Nullable Schema schema) {
        return new BigQueryRelation(datasetName, columnNames, featureFlagsProvider, schema);
    }

    @VisibleForTesting
    protected BigQueryRelation(String datasetName, Set<String> columns, FeatureFlagsProvider featureFlagsProvider) {
        this(datasetName, columns, featureFlagsProvider, null);
    }

    @VisibleForTesting
    protected BigQueryRelation(String datasetName, Set<String> columns, FeatureFlagsProvider featureFlagsProvider, @Nullable Schema schema) {
        this.datasetName = datasetName;
        this.columns = columns;
        this.featureFlagsProvider = featureFlagsProvider;
        this.schema = schema;
        this.parent = null;
        this.sqlStatementSupplier = () -> {
            BigQuerySQLDataset sourceDataset = this.sourceDatasets.get(datasetName);
            if (sourceDataset == null) {
                throw new SQLEngineException("Unable to find dataset with name " + datasetName);
            }
            Map<String, Expression> selectedColumns = BigQueryRelation.getSelectedColumns(columns);
            String sourceTable = String.format("%s.%s.%s", sourceDataset.getBigQueryProject(), sourceDataset.getBigQueryDataset(), sourceDataset.getBigQueryTable());
            return BigQueryRelation.buildBaseSelect(selectedColumns, sourceTable, datasetName);
        };
    }

    @VisibleForTesting
    protected BigQueryRelation(String datasetName, Set<String> columns, FeatureFlagsProvider featureFlagsProvider, @Nullable BigQueryRelation parent, Supplier<String> sqlStatementSupplier) {
        this(datasetName, columns, featureFlagsProvider, parent, sqlStatementSupplier, null);
    }

    @VisibleForTesting
    protected BigQueryRelation(String datasetName, Set<String> columns, FeatureFlagsProvider featureFlagsProvider, @Nullable BigQueryRelation parent, Supplier<String> sqlStatementSupplier, @Nullable Schema schema) {
        this.datasetName = datasetName;
        this.columns = columns;
        this.featureFlagsProvider = featureFlagsProvider;
        this.parent = parent;
        this.sqlStatementSupplier = sqlStatementSupplier;
        this.schema = schema;
    }

    private Relation getInvalidRelation(String validationError) {
        return new InvalidRelation(validationError);
    }

    public boolean isValid() {
        return true;
    }

    public String getValidationError() {
        return null;
    }

    @Nullable
    public Relation getParent() {
        return this.parent;
    }

    public String getSQLStatement() {
        return this.sqlStatementSupplier.get();
    }

    public Set<String> getColumns() {
        return this.columns;
    }

    @Nullable
    public Schema getSchema() {
        return this.schema;
    }

    public void setInputDatasets(Map<String, BigQuerySQLDataset> datasets) {
        this.sourceDatasets = datasets;
        if (this.parent != null) {
            this.parent.setInputDatasets(datasets);
        }
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public Relation setDatasetName(String newDatasetName) {
        Map<String, Expression> selectedColumns = BigQueryRelation.getSelectedColumns(this.columns);
        Supplier<String> supplier = () -> BigQueryRelation.buildNestedSelect(selectedColumns, this.getSQLStatement(), newDatasetName, null);
        return new BigQueryRelation(newDatasetName, this.columns, this.featureFlagsProvider, this, supplier);
    }

    public Relation setColumn(String column, Expression value) {
        if (!BigQueryRelation.supportsExpression(value)) {
            return this.getInvalidRelation("Unsupported or invalid expression type : " + BigQueryRelation.getInvalidExpressionCause(value));
        }
        Map<String, Expression> selectedColumns = BigQueryRelation.getSelectedColumns(this.columns);
        selectedColumns.put(column, value);
        Supplier<String> supplier = () -> BigQueryRelation.buildNestedSelect(selectedColumns, this.getSQLStatement(), this.datasetName, null);
        return new BigQueryRelation(this.datasetName, selectedColumns.keySet(), this.featureFlagsProvider, this, supplier);
    }

    public Relation dropColumn(String column) {
        if (!this.columns.contains(column)) {
            return this.getInvalidRelation("Trying to remove non existing column in Relation: " + column);
        }
        Map<String, Expression> selectedColumns = BigQueryRelation.getSelectedColumns(this.columns);
        selectedColumns.remove(column);
        Supplier<String> supplier = () -> BigQueryRelation.buildNestedSelect(selectedColumns, this.getSQLStatement(), this.datasetName, null);
        return new BigQueryRelation(this.datasetName, selectedColumns.keySet(), this.featureFlagsProvider, this, supplier);
    }

    public Relation select(Map<String, Expression> columns) {
        if (!BigQueryRelation.supportsExpressions(columns.values())) {
            return this.getInvalidRelation("Unsupported or invalid expression type: " + BigQueryRelation.getInvalidExpressionCauses(columns.values()));
        }
        Supplier<String> supplier = () -> BigQueryRelation.buildNestedSelect(columns, this.getSQLStatement(), this.datasetName, null);
        return new BigQueryRelation(this.datasetName, columns.keySet(), this.featureFlagsProvider, this, supplier);
    }

    public Relation filter(Expression filter) {
        if (!BigQueryRelation.supportsExpression(filter)) {
            return this.getInvalidRelation("Unsupported or invalid expression type: " + BigQueryRelation.getInvalidExpressionCause(filter));
        }
        Map<String, Expression> selectedColumns = BigQueryRelation.getSelectedColumns(this.columns);
        Supplier<String> supplier = () -> BigQueryRelation.buildNestedSelect(selectedColumns, this.getSQLStatement(), this.datasetName, filter);
        return new BigQueryRelation(this.datasetName, this.columns, this.featureFlagsProvider, this, supplier);
    }

    public Relation groupBy(GroupByAggregationDefinition definition) {
        if (!Feature.PUSHDOWN_TRANSFORMATION_GROUPBY.isEnabled(this.featureFlagsProvider)) {
            return this.getInvalidRelation(String.format("Feature %s is not enabled.", Feature.PUSHDOWN_TRANSFORMATION_GROUPBY.getFeatureFlagString()));
        }
        if (!BigQueryRelation.supportsGroupByAggregationDefinition(definition)) {
            return this.getInvalidRelation("DeduplicateAggregationDefinition contains unsupported or invalid expressions: " + BigQueryRelation.collectGroupByAggregationDefinitionErrors(definition));
        }
        Set<String> columns = definition.getSelectExpressions().keySet();
        Supplier<String> supplier = () -> BigQueryRelation.buildGroupBy(definition, this.getSQLStatement(), this.datasetName);
        return new BigQueryRelation(this.datasetName, columns, this.featureFlagsProvider, this, supplier);
    }

    public Relation deduplicate(DeduplicateAggregationDefinition definition) {
        if (!Feature.PUSHDOWN_TRANSFORMATION_DEDUPLICATE.isEnabled(this.featureFlagsProvider)) {
            return this.getInvalidRelation(String.format("Feature %s is not enabled.", Feature.PUSHDOWN_TRANSFORMATION_DEDUPLICATE.getFeatureFlagString()));
        }
        if (!BigQueryRelation.supportsDeduplicateAggregationDefinition(definition)) {
            return this.getInvalidRelation("DeduplicateAggregationDefinition contains unsupported or invalid expressions: " + BigQueryRelation.collectDeduplicateAggregationDefinitionErrors(definition));
        }
        Set<String> columns = definition.getSelectExpressions().keySet();
        Supplier<String> supplier = () -> BigQueryRelation.buildDeduplicate(definition, this.getSQLStatement(), this.datasetName);
        return new BigQueryRelation(this.datasetName, columns, this.featureFlagsProvider, this, supplier);
    }

    public Relation window(WindowAggregationDefinition definition) {
        if (!Feature.PUSHDOWN_TRANSFORMATION_WINDOWAGGREGATION.isEnabled(this.featureFlagsProvider)) {
            return this.getInvalidRelation(String.format("Feature %s is not enabled.", Feature.PUSHDOWN_TRANSFORMATION_WINDOWAGGREGATION.getFeatureFlagString()));
        }
        if (!BigQueryRelation.supportsWindowAggregationDefinition(definition)) {
            return this.getInvalidRelation("WindowAggregationDefinition contains unsupported or invalid expressions: " + BigQueryRelation.collectWindowAggregationDefinitionErrors(definition));
        }
        Set<String> columns = definition.getSelectExpressions().keySet();
        Supplier<String> supplier = () -> BigQueryRelation.buildWindow(definition, this.getSQLStatement(), this.datasetName);
        return new BigQueryRelation(this.datasetName, columns, this.featureFlagsProvider, this, supplier);
    }

    private static String buildBaseSelect(Map<String, Expression> columns, String sourceTable, String datasetName) {
        BigQuerySelectSQLBuilder builder = new BigQuerySelectSQLBuilder(BigQueryRelation.qualifyKeys(columns), BigQueryRelation.qualify(sourceTable), BigQueryRelation.qualify(datasetName), null);
        return builder.getQuery();
    }

    private static String buildNestedSelect(Map<String, Expression> columns, String sourceExpression, String datasetName, @Nullable Expression filter) {
        String filterCondition = filter != null ? ((SQLExpression)filter).extract() : null;
        BigQueryNestedSelectSQLBuilder builder = new BigQueryNestedSelectSQLBuilder(BigQueryRelation.qualifyKeys(columns), sourceExpression, BigQueryRelation.qualify(datasetName), filterCondition);
        return builder.getQuery();
    }

    private static String buildGroupBy(GroupByAggregationDefinition definition, String sourceExpression, String datasetName) {
        BigQueryGroupBySQLBuilder builder = new BigQueryGroupBySQLBuilder((AggregationDefinition)BigQueryRelation.qualify(definition), sourceExpression, BigQueryRelation.qualify(datasetName));
        return builder.getQuery();
    }

    private static String buildDeduplicate(DeduplicateAggregationDefinition definition, String sourceExpression, String datasetName) {
        BigQueryDeduplicateSQLBuilder builder = new BigQueryDeduplicateSQLBuilder(BigQueryRelation.qualify(definition), sourceExpression, BigQueryRelation.qualify(datasetName));
        return builder.getQuery();
    }

    private static String buildWindow(WindowAggregationDefinition definition, String sourceExpression, String datasetName) {
        BigQueryWindowsAggregationSQLBuilder builder = new BigQueryWindowsAggregationSQLBuilder(BigQueryRelation.qualify(definition), sourceExpression, BigQueryRelation.qualify(datasetName));
        return builder.getQuery();
    }

    private static String qualify(String identifier) {
        return factory.qualify(identifier);
    }

    private static Map<String, Expression> qualifyKeys(Map<String, Expression> columns) {
        LinkedHashMap<String, Expression> qualified = new LinkedHashMap<String, Expression>();
        columns.forEach((k, v) -> qualified.put(BigQueryRelation.qualify(k), (Expression)v));
        return qualified;
    }

    private static Map<String, Expression> getSelectedColumns(Set<String> columns) {
        LinkedHashMap<String, Expression> selectedColumns = new LinkedHashMap<String, Expression>();
        columns.forEach(c -> selectedColumns.put((String)c, factory.compile(BigQueryRelation.qualify(c))));
        return selectedColumns;
    }

    @VisibleForTesting
    protected static boolean supportsGroupByAggregationDefinition(GroupByAggregationDefinition def) {
        Collection<Expression> selectExpressions = def.getSelectExpressions().values();
        List groupByExpressions = def.getGroupByExpressions();
        return BigQueryRelation.supportsExpressions(selectExpressions) && BigQueryRelation.supportsExpressions(groupByExpressions);
    }

    @Nullable
    @VisibleForTesting
    protected static String collectGroupByAggregationDefinitionErrors(GroupByAggregationDefinition def) {
        String groupByErrors;
        if (BigQueryRelation.supportsGroupByAggregationDefinition(def)) {
            return null;
        }
        Collection<Expression> selectExpressions = def.getSelectExpressions().values();
        List groupByExpressions = def.getGroupByExpressions();
        String selectErrors = BigQueryRelation.getInvalidExpressionCauses(selectExpressions);
        if (!Strings.isNullOrEmpty((String)selectErrors)) {
            selectErrors = "Select fields: " + selectErrors;
        }
        if (!Strings.isNullOrEmpty((String)(groupByErrors = BigQueryRelation.getInvalidExpressionCauses(groupByExpressions)))) {
            groupByErrors = "Grouping fields: " + groupByErrors;
        }
        return Stream.of(selectErrors, groupByErrors).filter(Objects::nonNull).collect(Collectors.joining(" - "));
    }

    protected static GroupByAggregationDefinition qualify(GroupByAggregationDefinition def) {
        GroupByAggregationDefinition.Builder builder = GroupByAggregationDefinition.builder();
        builder.select(BigQueryRelation.qualifyKeys(def.getSelectExpressions()));
        builder.groupBy(def.getGroupByExpressions());
        return builder.build();
    }

    @VisibleForTesting
    protected static boolean supportsDeduplicateAggregationDefinition(DeduplicateAggregationDefinition def) {
        Collection<Expression> selectExpressions = def.getSelectExpressions().values();
        List dedupExpressions = def.getGroupByExpressions();
        Collection orderExpressions = def.getFilterExpressions().stream().map(DeduplicateAggregationDefinition.FilterExpression::getExpression).collect(Collectors.toSet());
        return BigQueryRelation.supportsExpressions(selectExpressions) && BigQueryRelation.supportsExpressions(dedupExpressions) && BigQueryRelation.supportsExpressions(orderExpressions);
    }

    @Nullable
    @VisibleForTesting
    protected static String collectDeduplicateAggregationDefinitionErrors(DeduplicateAggregationDefinition def) {
        String orderErrors;
        String dedupErrors;
        if (BigQueryRelation.supportsDeduplicateAggregationDefinition(def)) {
            return null;
        }
        Collection<Expression> selectExpressions = def.getSelectExpressions().values();
        List dedupExpressions = def.getGroupByExpressions();
        Collection orderExpressions = def.getFilterExpressions().stream().map(DeduplicateAggregationDefinition.FilterExpression::getExpression).collect(Collectors.toSet());
        String selectErrors = BigQueryRelation.getInvalidExpressionCauses(selectExpressions);
        if (!Strings.isNullOrEmpty((String)selectErrors)) {
            selectErrors = "Select fields: " + selectErrors;
        }
        if (!Strings.isNullOrEmpty((String)(dedupErrors = BigQueryRelation.getInvalidExpressionCauses(dedupExpressions)))) {
            dedupErrors = "Deduplication fields: " + dedupErrors;
        }
        if (!Strings.isNullOrEmpty((String)(orderErrors = BigQueryRelation.getInvalidExpressionCauses(orderExpressions)))) {
            orderErrors = "Order fields: " + orderErrors;
        }
        return Stream.of(selectErrors, dedupErrors, orderErrors).filter(Objects::nonNull).collect(Collectors.joining(" - "));
    }

    protected static DeduplicateAggregationDefinition qualify(DeduplicateAggregationDefinition def) {
        DeduplicateAggregationDefinition.Builder builder = DeduplicateAggregationDefinition.builder();
        builder.select(BigQueryRelation.qualifyKeys(def.getSelectExpressions()));
        builder.dedupOn(def.getGroupByExpressions());
        builder.filterDuplicatesBy(def.getFilterExpressions());
        return builder.build();
    }

    protected static boolean supportsWindowAggregationDefinition(WindowAggregationDefinition def) {
        List partitionExpressions = def.getPartitionExpressions();
        Collection<Expression> selectExpressions = def.getSelectExpressions().values();
        Collection<Expression> orderExpressions = BigQueryRelation.getWindowAggregationOrderByExpression(def);
        return BigQueryRelation.supportsExpressions(partitionExpressions) && BigQueryRelation.supportsExpressions(selectExpressions) && BigQueryRelation.supportsExpressions(orderExpressions);
    }

    private static Collection<Expression> getWindowAggregationOrderByExpression(WindowAggregationDefinition def) {
        ArrayList<Expression> orderExpressions = new ArrayList<Expression>(def.getOrderByExpressions().size());
        for (WindowAggregationDefinition.OrderByExpression orderByExpression : def.getOrderByExpressions()) {
            orderExpressions.add(orderByExpression.getExpression());
        }
        return orderExpressions;
    }

    @VisibleForTesting
    protected static WindowAggregationDefinition qualify(WindowAggregationDefinition def) {
        return WindowAggregationDefinition.builder().select(BigQueryRelation.qualifyKeys(def.getSelectExpressions())).partition(def.getPartitionExpressions()).aggregate(def.getAggregateExpressions()).orderBy(def.getOrderByExpressions()).windowFrameType(def.getWindowFrameType()).unboundedFollowing(def.getUnboundedFollowing()).unboundedPreceding(def.getUnboundedPreceding()).following(def.getFollowing()).preceding(def.getPreceding()).build();
    }

    @Nullable
    @VisibleForTesting
    protected static String collectWindowAggregationDefinitionErrors(WindowAggregationDefinition def) {
        String orderErrors;
        String partitionErrors;
        if (BigQueryRelation.supportsWindowAggregationDefinition(def)) {
            return null;
        }
        List orderByExpressions = def.getOrderByExpressions();
        Collection<Expression> orderExpressions = BigQueryRelation.getWindowAggregationOrderByExpression(def);
        String selectErrors = BigQueryRelation.getInvalidExpressionCauses(def.getSelectExpressions().values());
        if (!Strings.isNullOrEmpty((String)selectErrors)) {
            selectErrors = "Select fields: " + selectErrors;
        }
        if (!Strings.isNullOrEmpty((String)(partitionErrors = BigQueryRelation.getInvalidExpressionCauses(def.getPartitionExpressions())))) {
            partitionErrors = "Window fields: " + partitionErrors;
        }
        if (!Strings.isNullOrEmpty((String)(orderErrors = BigQueryRelation.getInvalidExpressionCauses(orderExpressions)))) {
            orderErrors = "Order fields: " + orderErrors;
        }
        return Stream.of(selectErrors, partitionErrors, orderErrors).filter(Objects::nonNull).collect(Collectors.joining(" - "));
    }

    @VisibleForTesting
    protected static boolean supportsExpressions(Collection<Expression> expressions) {
        return expressions.stream().allMatch(BigQueryRelation::supportsExpression);
    }

    @VisibleForTesting
    protected static boolean supportsExpression(Expression expression) {
        return expression instanceof SQLExpression && expression.isValid();
    }

    @Nullable
    @VisibleForTesting
    protected static String getInvalidExpressionCauses(Collection<Expression> expressions) {
        if (BigQueryRelation.supportsExpressions(expressions)) {
            return null;
        }
        return expressions.stream().map(BigQueryRelation::getInvalidExpressionCause).filter(Objects::nonNull).collect(Collectors.joining(" ; "));
    }

    @Nullable
    @VisibleForTesting
    protected static String getInvalidExpressionCause(Expression expression) {
        if (BigQueryRelation.supportsExpression(expression)) {
            return null;
        }
        if (expression == null) {
            return "Expression is null";
        }
        if (!(expression instanceof SQLExpression)) {
            return "Unsupported Expression type \"" + expression.getClass().getCanonicalName() + "\"";
        }
        return expression.getValidationError() != null ? expression.getValidationError() : "Unknown";
    }
}

