/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.relational;

import io.cdap.cdap.etl.api.engine.sql.StandardSQLCapabilities;
import io.cdap.cdap.etl.api.relational.Capability;
import io.cdap.cdap.etl.api.relational.CoreExpressionCapabilities;
import io.cdap.cdap.etl.api.relational.Expression;
import io.cdap.cdap.etl.api.relational.ExpressionFactory;
import io.cdap.cdap.etl.api.relational.ExpressionFactoryType;
import io.cdap.cdap.etl.api.relational.ExtractableExpression;
import io.cdap.cdap.etl.api.relational.InvalidExtractableExpression;
import io.cdap.cdap.etl.api.relational.InvalidRelation;
import io.cdap.cdap.etl.api.relational.Relation;
import io.cdap.cdap.etl.api.relational.StringExpressionFactoryType;
import io.cdap.plugin.gcp.bigquery.relational.BigQueryRelation;
import io.cdap.plugin.gcp.bigquery.relational.SQLExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SQLExpressionFactory
implements ExpressionFactory<String> {
    private static final Set<Capability> CAPABILITIES = Collections.unmodifiableSet(new HashSet<Capability>(){
        {
            this.add(StringExpressionFactoryType.SQL);
            this.add(StandardSQLCapabilities.BIGQUERY);
            this.add(CoreExpressionCapabilities.CAN_GET_QUALIFIED_DATASET_NAME);
            this.add(CoreExpressionCapabilities.CAN_GET_QUALIFIED_COLUMN_NAME);
            this.add(CoreExpressionCapabilities.CAN_SET_DATASET_ALIAS);
        }
    });

    public ExpressionFactoryType<String> getType() {
        return StringExpressionFactoryType.SQL;
    }

    public Expression compile(String expression) {
        return new SQLExpression(expression);
    }

    public Set<Capability> getCapabilities() {
        return CAPABILITIES;
    }

    public ExtractableExpression<String> getQualifiedDataSetName(Relation relation) {
        if (!(relation instanceof BigQueryRelation)) {
            return new InvalidExtractableExpression("Relation is not BigQueryRelation");
        }
        String datasetName = ((BigQueryRelation)relation).getDatasetName();
        return new SQLExpression(this.qualify(datasetName));
    }

    public ExtractableExpression<String> getQualifiedColumnName(Relation relation, String column) {
        if (!(relation instanceof BigQueryRelation)) {
            return new InvalidExtractableExpression("Relation is not BigQueryRelation");
        }
        BigQueryRelation bqRelation = (BigQueryRelation)relation;
        if (!bqRelation.getColumns().contains(column)) {
            return new InvalidExtractableExpression("Column " + column + " is not present in dataset");
        }
        return new SQLExpression(this.qualify(column));
    }

    public Relation setDataSetAlias(Relation relation, String alias) {
        if (!(relation instanceof BigQueryRelation)) {
            return new InvalidRelation("Alias cannot be set when the relation is not BigQueryRelation");
        }
        BigQueryRelation bqRelation = (BigQueryRelation)relation;
        return bqRelation.setDatasetName(alias);
    }

    public String qualify(String identifier) {
        return "`" + identifier + "`";
    }
}

