/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.api.client.util.Strings;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.gcp.bigquery.common.BigQueryBaseConfig;
import io.cdap.plugin.gcp.bigquery.connector.BigQueryConnectorConfig;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import io.cdap.plugin.gcp.common.CmekUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractBigQuerySinkConfig
extends BigQueryBaseConfig {
    public static final Set<Schema.Type> SUPPORTED_TYPES = ImmutableSet.of((Object)Schema.Type.INT, (Object)Schema.Type.LONG, (Object)Schema.Type.STRING, (Object)Schema.Type.FLOAT, (Object)Schema.Type.DOUBLE, (Object)Schema.Type.BOOLEAN, (Object[])new Schema.Type[]{Schema.Type.BYTES, Schema.Type.ARRAY, Schema.Type.RECORD});
    public static final String NAME_TRUNCATE_TABLE = "truncateTable";
    public static final String NAME_LOCATION = "location";
    private static final String NAME_GCS_CHUNK_SIZE = "gcsChunkSize";
    protected static final String NAME_UPDATE_SCHEMA = "allowSchemaRelaxation";
    private static final String SCHEME = "gs://";
    @Name(value="referenceName")
    @Nullable
    @Description(value="This will be used to uniquely identify this source/sink for lineage, annotating metadata, etc.")
    protected String referenceName;
    @Name(value="gcsChunkSize")
    @Macro
    @Nullable
    @Description(value="Optional property to tune chunk size in gcs upload request. The value of this property should be in number of bytes. By default, 8388608 bytes (8MB) will be used as upload request chunk size.")
    protected String gcsChunkSize;
    @Name(value="allowSchemaRelaxation")
    @Macro
    @Nullable
    @Description(value="Whether to modify the BigQuery table schema if it differs from the input schema.")
    protected Boolean allowSchemaRelaxation;
    @Name(value="truncateTable")
    @Macro
    @Nullable
    @Description(value="Whether or not to truncate the table before writing to it. Should only be used with the Insert operation. This could overwrite the table schema")
    protected Boolean truncateTable;
    @Name(value="location")
    @Macro
    @Nullable
    @Description(value="The location where the big query dataset will get created. This value is ignored if the dataset or temporary bucket already exist.")
    protected String location;

    public AbstractBigQuerySinkConfig(BigQueryConnectorConfig connection, String dataset, String cmekKey, String bucket) {
        super(connection, dataset, cmekKey, bucket);
    }

    @Nullable
    public String getReferenceName() {
        return Strings.isNullOrEmpty((String)this.referenceName) ? ReferenceNames.normalizeFqn((String)BigQueryUtil.getFQN(this.getDatasetProject(), this.dataset, this.getTable())) : this.referenceName;
    }

    @Nullable
    public String getLocation() {
        return this.location;
    }

    @Nullable
    protected String getTable() {
        return null;
    }

    @Nullable
    public String getGcsChunkSize() {
        return this.gcsChunkSize;
    }

    public boolean isAllowSchemaRelaxation() {
        return this.allowSchemaRelaxation == null ? false : this.allowSchemaRelaxation;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.isTruncateTableSet() ? JobInfo.WriteDisposition.WRITE_TRUNCATE : JobInfo.WriteDisposition.WRITE_APPEND;
    }

    public boolean isTruncateTableSet() {
        return this.truncateTable != null && this.truncateTable != false;
    }

    public void validate(FailureCollector collector) {
        this.validate(collector, Collections.emptyMap());
    }

    public void validate(FailureCollector collector, Map<String, String> arguments) {
        if (!Strings.isNullOrEmpty((String)this.referenceName)) {
            IdUtils.validateReferenceName((String)this.referenceName, (FailureCollector)collector);
        }
        ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
        String bucket = this.getBucket();
        if (!this.containsMacro("bucket")) {
            BigQueryUtil.validateBucket(bucket, "bucket", collector);
        }
        if (!this.containsMacro(NAME_GCS_CHUNK_SIZE)) {
            BigQueryUtil.validateGCSChunkSize(this.gcsChunkSize, NAME_GCS_CHUNK_SIZE, collector);
        }
        if (!this.containsMacro("dataset")) {
            BigQueryUtil.validateDataset(this.dataset, "dataset", collector);
        }
        if (!this.containsMacro("cmekKey")) {
            this.validateCmekKey(collector, arguments);
        }
    }

    void validateCmekKey(FailureCollector failureCollector, Map<String, String> arguments) {
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.cmekKey, arguments, failureCollector);
        if (this.containsMacro(NAME_LOCATION)) {
            return;
        }
        this.validateCmekKeyLocation(cmekKeyName, null, this.location, failureCollector);
    }

    public String getDatasetProject() {
        return this.connection == null ? null : this.connection.getDatasetProject();
    }
}

