/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import io.cdap.plugin.gcp.bigquery.sink.AvroRecordWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroSerialization;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AvroOutputFormat
extends AvroKeyOutputFormat<GenericRecord> {
    public AvroOutputFormat() {
    }

    public AvroOutputFormat(AvroKeyOutputFormat.RecordWriterFactory recordWriterFactory) {
        super(recordWriterFactory);
    }

    public RecordWriter<AvroKey<GenericRecord>, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        Schema mapOutputSchema;
        boolean isMapOnly;
        Configuration conf = context.getConfiguration();
        Schema writerSchema = AvroJob.getOutputKeySchema((Configuration)conf);
        boolean bl = isMapOnly = context.getNumReduceTasks() == 0;
        if (isMapOnly && (mapOutputSchema = AvroJob.getMapOutputKeySchema((Configuration)conf)) != null) {
            writerSchema = mapOutputSchema;
        }
        GenericData dataModel = AvroSerialization.createDataModel((Configuration)conf);
        return this.create(writerSchema, dataModel, AvroOutputFormat.getCompressionCodec((TaskAttemptContext)context), this.getOutputStreamSupplier(context), AvroOutputFormat.getSyncInterval((TaskAttemptContext)context));
    }

    private Supplier<OutputStream> getOutputStreamSupplier(TaskAttemptContext context) {
        return () -> {
            try {
                return this.getAvroFileOutputStream(context);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private RecordWriter<AvroKey<GenericRecord>, NullWritable> create(Schema writerSchema, GenericData dataModel, CodecFactory compressionCodec, Supplier<OutputStream> outputStreamSupplier, int syncInterval) {
        return new AvroRecordWriter(writerSchema, dataModel, compressionCodec, outputStreamSupplier, syncInterval);
    }
}

