/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.Syncable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AvroRecordWriter
extends RecordWriter<AvroKey<GenericRecord>, NullWritable>
implements Syncable {
    private DataFileWriter<GenericRecord> mAvroFileWriter;
    private Schema prevSchema;
    private GenericData dataModel;
    private CodecFactory compressionCodec;
    private Supplier<OutputStream> outputStreamSupplier;
    private int syncInterval;

    public AvroRecordWriter(Schema writerSchema, GenericData dataModel, CodecFactory compressionCodec, Supplier<OutputStream> outputStreamSupplier, int syncInterval) {
        this.dataModel = dataModel;
        this.compressionCodec = compressionCodec;
        this.syncInterval = syncInterval;
        this.outputStreamSupplier = outputStreamSupplier;
    }

    public AvroRecordWriter(Schema writerSchema, GenericData dataModel, CodecFactory compressionCodec, Supplier<OutputStream> outputStreamSupplier) {
        this(writerSchema, dataModel, compressionCodec, outputStreamSupplier, 64000);
    }

    public void write(AvroKey<GenericRecord> record, NullWritable ignore) throws IOException {
        Schema writerSchema = ((GenericRecord)record.datum()).getSchema();
        if (this.mAvroFileWriter == null) {
            this.createFileWriter(writerSchema);
        }
        if (this.prevSchema != null && !this.prevSchema.equals((Object)writerSchema)) {
            this.mAvroFileWriter.sync();
            this.mAvroFileWriter.close();
            this.createFileWriter(writerSchema);
        }
        this.mAvroFileWriter.append(record.datum());
    }

    private void createFileWriter(Schema writerSchema) throws IOException {
        this.mAvroFileWriter = new DataFileWriter(this.dataModel.createDatumWriter(writerSchema));
        this.mAvroFileWriter.setCodec(this.compressionCodec);
        this.mAvroFileWriter.setSyncInterval(this.syncInterval);
        this.mAvroFileWriter.create(writerSchema, this.outputStreamSupplier.get());
        this.prevSchema = writerSchema;
    }

    public void close(TaskAttemptContext context) throws IOException {
        if (this.mAvroFileWriter != null) {
            this.mAvroFileWriter.close();
        }
    }

    public long sync() throws IOException {
        if (this.mAvroFileWriter != null) {
            return this.mAvroFileWriter.sync();
        }
        return 0L;
    }
}

