/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.gson.JsonObject;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.common.RecordConverter;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryRecordToJson;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class BigQueryJsonConverter
extends RecordConverter<StructuredRecord, JsonObject> {
    public JsonObject transform(StructuredRecord input, @Nullable Schema schema) throws IOException {
        try (JsonTreeWriter writer = new JsonTreeWriter();){
            writer.beginObject();
            for (Schema.Field recordField : Objects.requireNonNull(input.getSchema().getFields())) {
                if (schema != null && schema.getField(recordField.getName()) == null) continue;
                BigQueryRecordToJson.write((JsonWriter)writer, recordField.getName(), input.get(recordField.getName()), recordField.getSchema());
            }
            writer.endObject();
            JsonObject jsonObject = writer.get().getAsJsonObject();
            return jsonObject;
        }
    }
}

