/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Table;
import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Metadata;
import io.cdap.cdap.api.annotation.MetadataProperty;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.batch.Output;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchSinkContext;
import io.cdap.plugin.gcp.bigquery.sink.AbstractBigQuerySink;
import io.cdap.plugin.gcp.bigquery.sink.BigQueryMultiSinkConfig;
import io.cdap.plugin.gcp.bigquery.sink.BigQuerySinkUtils;
import io.cdap.plugin.gcp.bigquery.sink.DelegatingMultiSinkOutputFormatProvider;
import io.cdap.plugin.gcp.bigquery.sink.MultiSinkOutputFormatProvider;
import io.cdap.plugin.gcp.bigquery.sink.Operation;
import io.cdap.plugin.gcp.bigquery.util.BigQueryUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;

@Plugin(type="batchsink")
@Name(value="BigQueryMultiTable")
@Description(value="Writes records to one or more Big Query tables. BigQuery is Google's serverless, highly scalable, enterprise data warehouse. Data is first written to a temporary location on Google Cloud Storage, then loaded into BigQuery from there.")
@Metadata(properties={@MetadataProperty(key="connector", value="BigQuery")})
public class BigQueryMultiSink
extends AbstractBigQuerySink {
    public static final String NAME = "BigQueryMultiTable";
    private static final String TABLE_PREFIX = "multisink.";
    private static final String OUTPUT_PATTERN = "[A-Za-z0-9_-]+";
    private final BigQueryMultiSinkConfig config;

    public BigQueryMultiSink(BigQueryMultiSinkConfig config) {
        this.config = config;
    }

    @Override
    protected BigQueryMultiSinkConfig getConfig() {
        return this.config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        this.config.validate(pipelineConfigurer.getStageConfigurer().getFailureCollector());
        super.configurePipeline(pipelineConfigurer);
    }

    @Override
    protected void prepareRunValidation(BatchSinkContext context) {
        FailureCollector collector = context.getFailureCollector();
        this.config.validate(collector, context.getArguments().asMap());
        collector.getOrThrowException();
    }

    @Override
    protected void prepareRunInternal(BatchSinkContext context, BigQuery bigQuery, String bucket) throws IOException {
        this.baseConfiguration.set("cdap.bq.sink.operation", Operation.INSERT.name());
        HashMap<String, String> arguments = new HashMap<String, String>(context.getArguments().asMap());
        FailureCollector collector = context.getFailureCollector();
        if (this.config.getAllowFlexibleSchema().booleanValue()) {
            this.configureSchemalessOutput(context, bucket);
        } else {
            this.configureOutputSchemas(context, bigQuery, bucket, arguments, collector);
        }
        collector.getOrThrowException();
    }

    protected void configureOutputSchemas(BatchSinkContext context, BigQuery bigQuery, String bucket, Map<String, String> arguments, FailureCollector collector) {
        for (Map.Entry<String, String> argument : arguments.entrySet()) {
            String key = argument.getKey();
            if (!key.startsWith(TABLE_PREFIX)) continue;
            String tableName = key.substring(TABLE_PREFIX.length());
            String[] split = tableName.split("\\.");
            if (split.length == 2) {
                tableName = split[1];
            }
            try {
                Schema configuredSchema = Schema.parseJson((String)argument.getValue());
                Table table = BigQueryUtil.getBigQueryTable(this.config.getDatasetProject(), this.config.getDataset(), tableName, this.config.getServiceAccount(), this.config.isServiceAccountFilePath(), collector);
                Schema tableSchema = configuredSchema;
                if (table != null) {
                    com.google.cloud.bigquery.Schema bqSchema = table.getDefinition().getSchema();
                    BigQuerySinkUtils.validateSchema(tableName, bqSchema, configuredSchema, this.config.allowSchemaRelaxation, this.config.isTruncateTableSet(), this.config.getDataset(), collector);
                }
                String outputName = String.format("%s-%s", this.config.getReferenceName(), tableName);
                outputName = this.sanitizeOutputName(outputName);
                this.initOutput(context, bigQuery, outputName, BigQueryUtil.getFQN(this.config.getDatasetProject(), this.config.getDataset(), tableName), tableName, tableSchema, bucket, context.getFailureCollector(), tableName);
            }
            catch (IOException e) {
                collector.addFailure("Invalid schema: " + e.getMessage(), null);
            }
        }
    }

    protected void configureSchemalessOutput(BatchSinkContext context, String bucket) throws IOException {
        Configuration conf = this.getOutputConfiguration();
        String splitField = this.config.getSplitField();
        String projectName = this.config.getDatasetProject();
        String datasetName = this.config.getDataset();
        context.addOutput(Output.of((String)this.config.getReferenceName(), (OutputFormatProvider)new DelegatingMultiSinkOutputFormatProvider(conf, splitField, bucket, projectName, datasetName)));
    }

    @VisibleForTesting
    String sanitizeOutputName(String outputName) {
        Pattern compilePattern = Pattern.compile(OUTPUT_PATTERN);
        boolean validatePattern = compilePattern.matcher(outputName).matches();
        return !validatePattern ? outputName.replaceAll("[^\\p{Alpha}\\p{Digit}-]+", "_") : outputName;
    }

    @Override
    protected OutputFormatProvider getOutputFormatProvider(Configuration configuration, String tableName, Schema tableSchema) {
        return new MultiSinkOutputFormatProvider(configuration, tableName, tableSchema, this.config.getSplitField());
    }
}

