/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.bigquery.sink;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.plugin.gcp.bigquery.connector.BigQueryConnectorConfig;
import io.cdap.plugin.gcp.bigquery.sink.AbstractBigQuerySinkConfig;
import javax.annotation.Nullable;

public class BigQueryMultiSinkConfig
extends AbstractBigQuerySinkConfig {
    private static final String SPLIT_FIELD_DEFAULT = "tablename";
    private static final String NAME_ALLOW_FLEXIBLE_SCHEMA = "allowFlexibleSchema";
    @Macro
    @Nullable
    @Description(value="The name of the field that will be used to determine which table to write to.")
    private String splitField;
    @Name(value="allowFlexibleSchema")
    @Macro
    @Nullable
    @Description(value="Allow Flexible Schemas in output. If disabled, only records with schemas set as arguments will be processed. If enabled, all records will be written as-is.")
    private Boolean allowFlexibleSchema;

    private BigQueryMultiSinkConfig(BigQueryConnectorConfig connection, String dataset, String cmekKey, String bucket) {
        super(connection, dataset, cmekKey, bucket);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSplitField() {
        return Strings.isNullOrEmpty((String)this.splitField) ? SPLIT_FIELD_DEFAULT : this.splitField;
    }

    public Boolean getAllowFlexibleSchema() {
        return this.allowFlexibleSchema != null ? this.allowFlexibleSchema : false;
    }

    public static class Builder {
        private BigQueryConnectorConfig connection;
        private String dataset;
        private String cmekKey;
        private String bucket;

        public Builder setConnection(@Nullable BigQueryConnectorConfig connection) {
            this.connection = connection;
            return this;
        }

        public Builder setDataset(@Nullable String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setCmekKey(@Nullable String cmekKey) {
            this.cmekKey = cmekKey;
            return this;
        }

        public Builder setBucket(@Nullable String bucket) {
            this.bucket = bucket;
            return this;
        }

        public BigQueryMultiSinkConfig build() {
            return new BigQueryMultiSinkConfig(this.connection, this.dataset, this.cmekKey, this.bucket);
        }
    }
}

